/*
 * Decompiled with CFR 0.152.
 */
package com.queue.file.controller;

import com.queue.file.exception.InitializeException;
import com.queue.file.exception.UnsteadyStateException;
import com.queue.file.utils.Contents;
import com.queue.file.vo.DataSyncInfo;
import com.queue.file.vo.FileQueueData;
import com.queue.file.vo.PartitionContext;
import com.queue.file.vo.PartitionIndexVo;
import com.queue.file.vo.StoreInfo;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Paths;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentSkipListSet;
import org.h2.mvstore.MVMap;
import org.h2.mvstore.MVStore;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PartitionManager {
    private static final Logger logger = LoggerFactory.getLogger(PartitionManager.class);
    private final StoreInfo storeInfo;
    private final Map<String, PartitionContext> partitionContextMap = new ConcurrentHashMap<String, PartitionContext>();

    public PartitionManager(StoreInfo storeInfo) {
        this.storeInfo = storeInfo;
        logger.debug("initialize PartitionManager");
        this.initializePartitions();
    }

    private void initializePartitions() throws InitializeException {
        logger.debug("initializePartitions");
        MVStore store = this.storeInfo.getStore();
        if (store == null || store.isClosed()) {
            throw new InitializeException("\uc2a4\ud1a0\uc5b4\uac00 \ucd08\uae30\ud654\ub418\uc9c0 \uc54a\uc74c \ub610\ub294 \ub2eb\ud798");
        }
        Set schemaNameSet = store.getMapNames();
        if (schemaNameSet == null || schemaNameSet.isEmpty()) {
            try {
                PartitionContext partitionContext = new PartitionContext("DP201019");
                partitionContext.setDataMap((MVMap<Long, FileQueueData>)store.openMap(Contents.getDataMapName()));
                partitionContext.setReadBufferMap((MVMap<String, List<FileQueueData>>)store.openMap(Contents.getReadBufferName()));
                partitionContext.setCacheMap((MVMap<String, Object>)store.openMap(Contents.getCacheName()));
                this.partitionContextMap.put("DP201019", partitionContext);
            }
            catch (Exception e) {
                throw new InitializeException("\uae30\ubcf8 \ud30c\ud2f0\uc158 \ub370\uc774\ud130 \uc624\ud508 \uc911 \uc608\uc678 \ubc1c\uc0dd: " + e.getMessage());
            }
        } else {
            for (String schemaName : schemaNameSet) {
                int idx = schemaName.indexOf("___");
                if (idx <= 0) continue;
                String partitionName = schemaName.substring(0, idx);
                String suffix = schemaName.substring(idx + "___".length());
                PartitionContext partitionContext = this.partitionContextMap.computeIfAbsent(partitionName, PartitionContext::new);
                try {
                    switch (suffix) {
                        case "DATA_MAP": {
                            partitionContext.setDataMap((MVMap<Long, FileQueueData>)store.openMap(Contents.getDataMapName(partitionName)));
                            break;
                        }
                        case "READ_BUFFER": {
                            partitionContext.setReadBufferMap((MVMap<String, List<FileQueueData>>)store.openMap(Contents.getReadBufferName(partitionName)));
                            break;
                        }
                        case "CACHE": {
                            partitionContext.setCacheMap((MVMap<String, Object>)store.openMap(Contents.getCacheName(partitionName)));
                        }
                    }
                }
                catch (Exception e) {
                    throw new InitializeException("\ub0b4\ubd80 \uc2a4\ud0a4\ub9c8[" + schemaName + "] \ub370\uc774\ud130 \uc624\ud508 \uc911 \uc608\uc678 \ubc1c\uc0dd: " + e.getMessage());
                }
            }
            this.realignAllPartitions();
        }
    }

    private void realignAllPartitions() throws InitializeException {
        logger.debug("realignAllPartitions");
        MVStore store = this.storeInfo.getStore();
        if (store == null || store.isClosed()) {
            throw new InitializeException("\uc2a4\ud1a0\uc5b4\uac00 \ucd08\uae30\ud654\ub418\uc9c0 \uc54a\uc74c \ub610\ub294 \ub2eb\ud798");
        }
        for (PartitionContext partitionContext : this.partitionContextMap.values()) {
            partitionContext.getLock().writeLock().lock();
            String partitionName = partitionContext.getPartitionName();
            try {
                this.realignDataKey(partitionName);
            }
            catch (UnsteadyStateException e) {
                throw new InitializeException("\ud30c\ud2f0\uc158 [" + partitionName + "] \uc7ac\uc815\ub82c \uc911 \uc608\uc678 \ubc1c\uc0dd", e);
            }
            finally {
                partitionContext.getLock().writeLock().unlock();
            }
        }
    }

    public void realignDataKey(String partitionName) throws UnsteadyStateException {
        long keyListMaxKey;
        logger.debug("realignDataKey partition={}", (Object)partitionName);
        PartitionContext partitionContext = this.partitionContextMap.get(partitionName);
        if (partitionContext == null) {
            throw new UnsteadyStateException(partitionName + " \ud30c\ud2f0\uc158\uc774 \uc874\uc7ac\ud558\uc9c0 \uc54a\uc74c");
        }
        ConcurrentSkipListSet<Long> dataKeyList = partitionContext.getTransactionKeyList();
        MVMap<Long, FileQueueData> dataMap = partitionContext.getDataMap();
        if (dataMap == null) {
            throw new UnsteadyStateException(partitionName + " \ud30c\ud2f0\uc158\uc5d0 \ub370\uc774\ud130 \uc601\uc5ed\uc774 \uc874\uc7ac\ud558\uc9c0 \uc54a\uc74c");
        }
        int dataCount = dataMap.size();
        long dataMapMaxKey = dataCount == 0 ? 0L : (Long)Collections.max(dataMap.keySet());
        int keyCount = dataKeyList.size();
        long l = keyListMaxKey = keyCount == 0 ? 0L : dataKeyList.last();
        if (dataCount != keyCount || dataMapMaxKey != keyListMaxKey) {
            dataKeyList.clear();
            dataKeyList.addAll(dataMap.keySet());
            DataSyncInfo dataSyncInfo = new DataSyncInfo(dataCount, keyCount, dataCount - keyCount, Math.max(dataMapMaxKey, keyListMaxKey));
            PartitionIndexVo indexVo = partitionContext.getIndexVo();
            indexVo.setTransactionIndex(dataSyncInfo.getMaxKey() + 1L);
            partitionContext.setSyncInfo(dataSyncInfo);
        }
    }

    public void checkAllState() throws UnsteadyStateException {
        logger.debug("checkAllState");
        this.checkStore();
        for (String partitionName : this.partitionContextMap.keySet()) {
            this.checkState(partitionName, false);
        }
    }

    public void checkState(String partitionName, boolean checkStore) throws UnsteadyStateException {
        PartitionContext partitionContext;
        logger.debug("checkState partition={}", (Object)partitionName);
        if (checkStore) {
            this.checkStore();
        }
        if ((partitionContext = this.partitionContextMap.get(partitionName)) == null) {
            throw new UnsteadyStateException(partitionName + " \ud574\ub2f9 \ud30c\ud2f0\uc158\uc744 \ucc3e\uc744 \uc218 \uc5c6\uc74c");
        }
        MVMap<Long, FileQueueData> dataMap = partitionContext.getDataMap();
        if (dataMap == null || dataMap.isClosed()) {
            throw new UnsteadyStateException(partitionName + " \ud30c\ud2f0\uc158\uc758 \ub370\uc774\ud130 \uc601\uc5ed\uc774 \uc720\ud6a8\ud558\uc9c0 \uc54a\uc740 \uc0c1\ud0dc");
        }
        MVMap<String, List<FileQueueData>> readBufferMap = partitionContext.getReadBufferMap();
        if (readBufferMap == null || readBufferMap.isClosed()) {
            throw new UnsteadyStateException(partitionName + " \ud30c\ud2f0\uc158\uc758 Read Buffer \uc601\uc5ed\uc774 \uc720\ud6a8\ud558\uc9c0 \uc54a\uc740 \uc0c1\ud0dc");
        }
    }

    public void checkStore() throws UnsteadyStateException {
        logger.debug("checkStore");
        MVStore store = this.storeInfo.getStore();
        if (store == null || store.isClosed()) {
            throw new UnsteadyStateException(this.storeInfo.getCONFIG().getQueueName() + " \ud30c\uc77c\ud050\uac00 \uc720\ud6a8\ud558\uc9c0 \uc54a\uc740 \uc0c1\ud0dc");
        }
        if (!Files.exists(Paths.get(this.storeInfo.getCONFIG().getQueue(), new String[0]), new LinkOption[0])) {
            throw new UnsteadyStateException(this.storeInfo.getCONFIG().getQueue() + " \ud30c\uc77c\ud050\ub97c \ucc3e\uc744 \uc218 \uc5c6\uc74c - \uc0ad\uc81c\ub428");
        }
    }

    public PartitionContext getPartitionContext(String partitionName) throws InitializeException {
        return this.partitionContextMap.computeIfAbsent(partitionName, k -> {
            MVStore store = this.storeInfo.getStore();
            PartitionContext context = new PartitionContext((String)k);
            context.setDataMap((MVMap<Long, FileQueueData>)store.openMap(Contents.getDataMapName(k)));
            context.setReadBufferMap((MVMap<String, List<FileQueueData>>)store.openMap(Contents.getReadBufferName(k)));
            context.setCacheMap((MVMap<String, Object>)store.openMap(Contents.getCacheName(k)));
            return context;
        });
    }

    public Map<String, PartitionContext> getPartitionContextMap() {
        return this.partitionContextMap;
    }
}

