/*
 * Decompiled with CFR 0.152.
 */
package com.queue.file.vo;

import com.queue.file.vo.FileQueueCustomConfigVo;
import java.io.File;

public class FileQueueConfigVo {
    private final String queuePath;
    private final String queueName;
    private final String queue;
    private boolean encryptMode = false;
    private boolean compressMode = true;
    private boolean readOnlyMode = false;
    private boolean restoreMode = false;
    private int limit = 0;
    private FileQueueCustomConfigVo customConfig = new FileQueueCustomConfigVo();

    public FileQueueConfigVo(String queue) {
        int index = 0;
        if (queue != null && !queue.trim().isEmpty()) {
            index = queue.lastIndexOf(File.separator);
        }
        this.queuePath = index > 0 ? queue.substring(0, index) : "";
        this.queueName = index > 0 ? queue.substring(index + 1) : "";
        this.queue = queue;
    }

    public FileQueueConfigVo(String queuePath, String queueName) {
        this.queuePath = queuePath;
        this.queueName = queueName;
        this.queue = queuePath + (queuePath.endsWith(File.separator) ? "" : File.separator) + queueName;
    }

    public String getQueue() {
        return this.queue;
    }

    public String getQueuePath() {
        return this.queuePath;
    }

    public String getQueueName() {
        return this.queueName;
    }

    public boolean isEncryptMode() {
        return this.encryptMode;
    }

    public void setEncryptMode(boolean encryptMode) {
        this.encryptMode = encryptMode;
    }

    public boolean isCompressMode() {
        return this.compressMode;
    }

    public void setCompressMode(boolean compressMode) {
        this.compressMode = compressMode;
    }

    public boolean isReadOnlyMode() {
        return this.readOnlyMode;
    }

    public void setReadOnlyMode(boolean readOnlyMode) {
        this.readOnlyMode = readOnlyMode;
    }

    public boolean isRestoreMode() {
        return this.restoreMode;
    }

    public void setRestoreMode(boolean restoreMode) {
        this.restoreMode = restoreMode;
    }

    public int getLimit() {
        return this.limit;
    }

    public void setLimit(int limit) {
        this.limit = limit;
    }

    public FileQueueCustomConfigVo getCustomConfig() {
        return this.customConfig;
    }

    public void setCustomConfig(FileQueueCustomConfigVo customConfig) {
        this.customConfig = customConfig;
    }
}

