/*
 * Decompiled with CFR 0.152.
 */
package com.queue.file.vo;

import java.time.LocalDateTime;
import java.util.Collections;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicLong;

public class InOutStorage {
    private final Map<String, LocalDateTime> outputInvokeHistoryMap = new ConcurrentHashMap<String, LocalDateTime>();
    private final Map<String, LocalDateTime> bufferOutputInvokeHistoryMap = new ConcurrentHashMap<String, LocalDateTime>();
    private final Map<String, LocalDateTime> inputHistoryMap = new ConcurrentHashMap<String, LocalDateTime>();
    private final AtomicLong inputCount = new AtomicLong(0L);
    private final Map<String, LocalDateTime> outputHistoryMap = new ConcurrentHashMap<String, LocalDateTime>();
    private final AtomicLong outputCount = new AtomicLong(0L);
    private final Map<String, LocalDateTime> bufferInputHistoryMap = new ConcurrentHashMap<String, LocalDateTime>();
    private final AtomicLong bufferInputCount = new AtomicLong(0L);
    private final Map<String, LocalDateTime> bufferOutputHistoryMap = new ConcurrentHashMap<String, LocalDateTime>();
    private final AtomicLong bufferOutputCount = new AtomicLong(0L);

    public void recordOutputInvokeHistory(String executorName) {
        this.outputInvokeHistoryMap.put(executorName, LocalDateTime.now());
    }

    public Map<String, LocalDateTime> getOutputInvokeHistoryMap() {
        return Collections.unmodifiableMap(this.outputInvokeHistoryMap);
    }

    public void recordBufferOutputInvokeHistory(String executorName) {
        this.bufferOutputInvokeHistoryMap.put(executorName, LocalDateTime.now());
    }

    public Map<String, LocalDateTime> getBufferOutputInvokeHistoryMap() {
        return Collections.unmodifiableMap(this.bufferOutputInvokeHistoryMap);
    }

    public Long getInputCount() {
        return this.inputCount.get();
    }

    public void addInputCount(String executorName, Long count) {
        this.inputCount.updateAndGet(currentValue -> {
            if (currentValue >= Long.MAX_VALUE - count) {
                return count;
            }
            this.inputHistoryMap.put(executorName, LocalDateTime.now());
            return currentValue + count;
        });
    }

    public Long getOutputCount() {
        return this.outputCount.get();
    }

    public void addOutputCount(String executorName, Long count) {
        this.outputCount.updateAndGet(currentValue -> {
            if (currentValue >= Long.MAX_VALUE - count) {
                return count;
            }
            this.outputHistoryMap.put(executorName, LocalDateTime.now());
            return currentValue + count;
        });
    }

    public Long getBufferInputCount() {
        return this.bufferInputCount.get();
    }

    public void addBufferInputCount(String executorName, Long count) {
        this.bufferInputCount.updateAndGet(currentValue -> {
            if (currentValue >= Long.MAX_VALUE - count) {
                return count;
            }
            this.bufferInputHistoryMap.put(executorName, LocalDateTime.now());
            return currentValue + count;
        });
    }

    public Long getBufferOutputCount() {
        return this.bufferOutputCount.get();
    }

    public void addBufferOutputCount(String executorName, Long count) {
        this.bufferOutputCount.updateAndGet(currentValue -> {
            if (currentValue >= Long.MAX_VALUE - count) {
                return count;
            }
            this.bufferOutputHistoryMap.put(executorName, LocalDateTime.now());
            return currentValue + count;
        });
    }
}

