/*
 * Decompiled with CFR 0.152.
 */
package ar.edu.uade;

import ar.edu.uade.Body;
import ar.edu.uade.ConverterException;
import com.google.gson.Gson;
import com.rabbitmq.client.Delivery;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.List;

public class Utilities {
    public static Body convertDelivery(Delivery delivery) throws ConverterException {
        try {
            String body = new String(delivery.getBody(), StandardCharsets.UTF_8);
            Gson gson = new Gson();
            return (Body)gson.fromJson(body, Body.class);
        }
        catch (Exception e) {
            System.out.println("Error in CoreSender.Utilities.convertBody(): " + e.getMessage());
            throw new ConverterException("No se recibi\u00f3 un delivery.");
        }
    }

    public static <T> T convertBody(Body body, Class<T> target) throws ConverterException {
        try {
            Gson gson = new Gson();
            return (T)gson.fromJson(body.getPayload(), target);
        }
        catch (Exception e) {
            System.out.println("Error in CoreSender.Utilities.convertBody(): " + e.getMessage());
            throw new ConverterException("No se pudo convertir a la clase objetivo.");
        }
    }

    public static <T> String convertClass(T src) throws ConverterException {
        try {
            Gson gson = new Gson();
            return gson.toJson(src);
        }
        catch (Exception e) {
            System.out.println("Error in CoreSender.Utilities.convertClass(): " + e.getMessage());
            throw new ConverterException("No se pudo convertir la clase.");
        }
    }

    public static String convertArray(List<String> mensajes) throws ConverterException {
        try {
            return String.join((CharSequence)"--!--##-->>DELIMITER<<--##--!--", mensajes);
        }
        catch (Exception e) {
            System.out.println("Error in CoreSender.Utilities.convertArray(): " + e.getMessage());
            throw new ConverterException("No se pudo convertir el Array.");
        }
    }

    public static List<String> convertString(String mensaje) throws ConverterException {
        try {
            if (!mensaje.contains("--!--##-->>DELIMITER<<--##--!--")) {
                throw new Exception();
            }
            return Arrays.asList(mensaje.split("--!--##-->>DELIMITER<<--##--!--"));
        }
        catch (Exception e) {
            System.out.println("Error in CoreSender.Utilities.convertString(): " + e.getMessage());
            throw new ConverterException("No se pudo convertir el mensaje.");
        }
    }
}

