/*
 * Decompiled with CFR 0.152.
 */
package io.github.matts.emailengine.model.hook;

import io.github.matts.emailengine.model.hook.Event;
import io.github.matts.emailengine.model.hook.Events;
import io.github.matts.emailengine.model.hook.data.MessageEventData;

public class MessageEvent
extends Event {
    private MessageEventData data;

    public MessageEvent(String serviceUrl, String account, String date, Events event, MessageEventData data) {
        super(serviceUrl, account, date, event);
        this.data = data;
    }

    public static MessageEventBuilder builder() {
        return new MessageEventBuilder();
    }

    public MessageEventData getData() {
        return this.data;
    }

    public void setData(MessageEventData data) {
        this.data = data;
    }

    public String toString() {
        return "MessageEvent(data=" + this.getData() + ")";
    }

    public MessageEvent() {
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof MessageEvent)) {
            return false;
        }
        MessageEvent other = (MessageEvent)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        MessageEventData this$data = this.getData();
        MessageEventData other$data = other.getData();
        return !(this$data == null ? other$data != null : !((Object)this$data).equals(other$data));
    }

    protected boolean canEqual(Object other) {
        return other instanceof MessageEvent;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        MessageEventData $data = this.getData();
        result = result * 59 + ($data == null ? 43 : ((Object)$data).hashCode());
        return result;
    }

    public static class MessageEventBuilder {
        private String serviceUrl;
        private String account;
        private String date;
        private Events event;
        private MessageEventData data;

        MessageEventBuilder() {
        }

        public MessageEventBuilder serviceUrl(String serviceUrl) {
            this.serviceUrl = serviceUrl;
            return this;
        }

        public MessageEventBuilder account(String account) {
            this.account = account;
            return this;
        }

        public MessageEventBuilder date(String date) {
            this.date = date;
            return this;
        }

        public MessageEventBuilder event(Events event) {
            this.event = event;
            return this;
        }

        public MessageEventBuilder data(MessageEventData data) {
            this.data = data;
            return this;
        }

        public MessageEvent build() {
            return new MessageEvent(this.serviceUrl, this.account, this.date, this.event, this.data);
        }

        public String toString() {
            return "MessageEvent.MessageEventBuilder(serviceUrl=" + this.serviceUrl + ", account=" + this.account + ", date=" + this.date + ", event=" + this.event + ", data=" + this.data + ")";
        }
    }
}

