/*
 * Decompiled with CFR 0.152.
 */
package io.github.matts.emailengine.model.hook;

import io.github.matts.emailengine.model.hook.Event;
import io.github.matts.emailengine.model.hook.Events;
import io.github.matts.emailengine.model.hook.data.AccountEventData;
import java.util.Date;

public class AccountEvent
extends Event {
    private AccountEventData data;

    public AccountEvent(String serviceUrl, String account, Date date, Events event, AccountEventData data) {
        super(serviceUrl, account, date, event);
        this.data = data;
    }

    public static AccountEventBuilder builder() {
        return new AccountEventBuilder();
    }

    public AccountEventData getData() {
        return this.data;
    }

    public void setData(AccountEventData data) {
        this.data = data;
    }

    public AccountEvent() {
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AccountEvent)) {
            return false;
        }
        AccountEvent other = (AccountEvent)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        AccountEventData this$data = this.getData();
        AccountEventData other$data = other.getData();
        return !(this$data == null ? other$data != null : !((Object)this$data).equals(other$data));
    }

    protected boolean canEqual(Object other) {
        return other instanceof AccountEvent;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        AccountEventData $data = this.getData();
        result = result * 59 + ($data == null ? 43 : ((Object)$data).hashCode());
        return result;
    }

    @Override
    public String toString() {
        return "AccountEvent(super=" + super.toString() + ", data=" + this.getData() + ")";
    }

    public static class AccountEventBuilder {
        private String serviceUrl;
        private String account;
        private Date date;
        private Events event;
        private AccountEventData data;

        AccountEventBuilder() {
        }

        public AccountEventBuilder serviceUrl(String serviceUrl) {
            this.serviceUrl = serviceUrl;
            return this;
        }

        public AccountEventBuilder account(String account) {
            this.account = account;
            return this;
        }

        public AccountEventBuilder date(Date date) {
            this.date = date;
            return this;
        }

        public AccountEventBuilder event(Events event) {
            this.event = event;
            return this;
        }

        public AccountEventBuilder data(AccountEventData data) {
            this.data = data;
            return this;
        }

        public AccountEvent build() {
            return new AccountEvent(this.serviceUrl, this.account, this.date, this.event, this.data);
        }

        public String toString() {
            return "AccountEvent.AccountEventBuilder(serviceUrl=" + this.serviceUrl + ", account=" + this.account + ", date=" + this.date + ", event=" + this.event + ", data=" + this.data + ")";
        }
    }
}

