/*
 * Decompiled with CFR 0.152.
 */
package io.github.matts.emailengine.model.hook;

import io.github.matts.emailengine.model.hook.Event;
import io.github.matts.emailengine.model.hook.Events;
import io.github.matts.emailengine.model.hook.data.AuthenticationEventData;
import java.util.Date;

public class AuthenticationEvent
extends Event {
    private AuthenticationEventData data;

    public AuthenticationEvent(String serviceUrl, String account, Date date, Events event, AuthenticationEventData data) {
        super(serviceUrl, account, date, event);
        this.data = data;
    }

    public static AuthenticationEventBuilder builder() {
        return new AuthenticationEventBuilder();
    }

    public AuthenticationEventData getData() {
        return this.data;
    }

    public void setData(AuthenticationEventData data) {
        this.data = data;
    }

    public AuthenticationEvent() {
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AuthenticationEvent)) {
            return false;
        }
        AuthenticationEvent other = (AuthenticationEvent)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        AuthenticationEventData this$data = this.getData();
        AuthenticationEventData other$data = other.getData();
        return !(this$data == null ? other$data != null : !((Object)this$data).equals(other$data));
    }

    protected boolean canEqual(Object other) {
        return other instanceof AuthenticationEvent;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        AuthenticationEventData $data = this.getData();
        result = result * 59 + ($data == null ? 43 : ((Object)$data).hashCode());
        return result;
    }

    @Override
    public String toString() {
        return "AuthenticationEvent(super=" + super.toString() + ", data=" + String.valueOf(this.getData()) + ")";
    }

    public static class AuthenticationEventBuilder {
        private String serviceUrl;
        private String account;
        private Date date;
        private Events event;
        private AuthenticationEventData data;

        AuthenticationEventBuilder() {
        }

        public AuthenticationEventBuilder serviceUrl(String serviceUrl) {
            this.serviceUrl = serviceUrl;
            return this;
        }

        public AuthenticationEventBuilder account(String account) {
            this.account = account;
            return this;
        }

        public AuthenticationEventBuilder date(Date date) {
            this.date = date;
            return this;
        }

        public AuthenticationEventBuilder event(Events event) {
            this.event = event;
            return this;
        }

        public AuthenticationEventBuilder data(AuthenticationEventData data) {
            this.data = data;
            return this;
        }

        public AuthenticationEvent build() {
            return new AuthenticationEvent(this.serviceUrl, this.account, this.date, this.event, this.data);
        }

        public String toString() {
            return "AuthenticationEvent.AuthenticationEventBuilder(serviceUrl=" + this.serviceUrl + ", account=" + this.account + ", date=" + String.valueOf(this.date) + ", event=" + String.valueOf((Object)this.event) + ", data=" + String.valueOf(this.data) + ")";
        }
    }
}

