/*
 * Decompiled with CFR 0.152.
 */
package io.github.matts.emailengine.api.v1;

import feign.FeignException;
import feign.Param;
import feign.QueryMap;
import feign.RequestLine;
import io.github.matts.emailengine.api.EmailEngineApi;
import io.github.matts.emailengine.model.MessageEntry;
import io.github.matts.emailengine.model.request.MessageFilterQuery;
import io.github.matts.emailengine.model.request.MessageInformationQuery;
import io.github.matts.emailengine.model.request.MessageSearchQuery;
import io.github.matts.emailengine.model.request.MessageUpload;
import io.github.matts.emailengine.model.response.MessageList;
import io.github.matts.emailengine.model.response.MessageUploadResponse;
import io.github.matts.emailengine.model.response.SubmitMessageResponse;

public interface MessageApi
extends EmailEngineApi {
    @RequestLine(value="GET /v1/account/{accountId}/messages")
    public MessageList listMessagesInternal(@Param(value="accountId") String var1, @Param(value="path") String var2, @QueryMap MessageFilterQuery var3);

    @RequestLine(value="GET /v1/account/{accountId}/message/{message}")
    public MessageEntry getMessageInformation(@Param(value="accountId") String var1, @Param(value="message") String var2, @QueryMap MessageInformationQuery var3);

    @RequestLine(value="POST /v1/account/{accountId}/message")
    public MessageUploadResponse uploadMessage(@Param(value="accountId") String var1, MessageUpload var2);

    @RequestLine(value="POST /v1/account/{accountId}/submit")
    public SubmitMessageResponse submitMessage(@Param(value="accountId") String var1, MessageUpload var2);

    @RequestLine(value="POST /v1/account/{accountId}/search")
    public MessageList searchMessagesInternal(MessageSearchQuery.Form var1, @Param(value="accountId") String var2, @QueryMap MessageFilterQuery var3);

    default public MessageList listMessages(String accountId, String path, MessageFilterQuery queryMap) {
        try {
            return this.listMessagesInternal(accountId, path, queryMap);
        }
        catch (FeignException e) {
            e.printStackTrace();
            return null;
        }
    }

    default public MessageList searchMessages(MessageSearchQuery.Form request, String accountId, MessageFilterQuery queryMap) {
        try {
            return this.searchMessagesInternal(request, accountId, queryMap);
        }
        catch (FeignException e) {
            e.printStackTrace();
            return null;
        }
    }
}

