/*
 * Decompiled with CFR 0.152.
 */
package dev.framework.stack.wrapper;

import dev.framework.stack.wrapper.Stack;
import dev.framework.stack.wrapper.nbt.NBTCompound;
import java.util.function.UnaryOperator;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractStack<T>
implements Stack<T> {
    protected final T providingStack;
    protected NBTCompound compound = new NBTCompound();

    protected AbstractStack(@NotNull T providingStack) {
        this.providingStack = providingStack;
    }

    @Override
    @Nullable
    public NBTCompound tag() {
        return this.compound;
    }

    @Override
    @NotNull
    public NBTCompound tagOrCreate() {
        return this.compound == null ? new NBTCompound() : this.compound;
    }

    @Override
    public void updateTag(@NotNull NBTCompound compound) {
        this.compound = compound;
    }

    @Override
    public void supplyTag(@NotNull UnaryOperator<NBTCompound> operator) {
        this.compound = (NBTCompound)operator.apply(this.compound);
    }

    @Override
    @NotNull
    public T asProvidingStack() {
        return this.updateStack();
    }

    protected abstract T updateStack();
}

