/*
 * Decompiled with CFR 0.152.
 */
package dev.framework.stack.wrapper.nbt;

import dev.framework.stack.wrapper.nbt.NBTCompound;
import dev.framework.stack.wrapper.nbt.NBTEnd;
import dev.framework.stack.wrapper.nbt.NBTList;
import dev.framework.stack.wrapper.nbt.array.NBTByteArray;
import dev.framework.stack.wrapper.nbt.array.NBTIntArray;
import dev.framework.stack.wrapper.nbt.array.NBTLongArray;
import dev.framework.stack.wrapper.nbt.primitive.NBTByte;
import dev.framework.stack.wrapper.nbt.primitive.NBTDouble;
import dev.framework.stack.wrapper.nbt.primitive.NBTFloat;
import dev.framework.stack.wrapper.nbt.primitive.NBTInt;
import dev.framework.stack.wrapper.nbt.primitive.NBTLong;
import dev.framework.stack.wrapper.nbt.primitive.NBTShort;
import dev.framework.stack.wrapper.nbt.primitive.NBTString;
import org.jetbrains.annotations.NotNull;

public interface NBTBase {
    default public boolean isCompound() {
        return false;
    }

    default public boolean isEnd() {
        return false;
    }

    default public boolean isList() {
        return false;
    }

    default public boolean isByte() {
        return false;
    }

    default public boolean isByteArray() {
        return false;
    }

    default public boolean isDouble() {
        return false;
    }

    default public boolean isFloat() {
        return false;
    }

    default public boolean isInt() {
        return false;
    }

    default public boolean isIntArray() {
        return false;
    }

    default public boolean isLong() {
        return false;
    }

    default public boolean isLongArray() {
        return false;
    }

    default public boolean isShort() {
        return false;
    }

    default public boolean isString() {
        return false;
    }

    default public NBTCompound asNBTCompound() {
        throw new IllegalArgumentException("Tag is not compound!");
    }

    default public NBTEnd asNBTEnd() {
        throw new IllegalArgumentException("Tag is not end!");
    }

    default public NBTList asNBTList() {
        throw new IllegalArgumentException("Tag is not list!");
    }

    default public NBTByte asNBTByte() {
        throw new IllegalArgumentException("Tag is not byte!");
    }

    default public NBTByteArray asNBTByteArray() {
        throw new IllegalArgumentException("Tag is not byte[]!");
    }

    default public NBTDouble asNBTDouble() {
        throw new IllegalArgumentException("Tag is not double!");
    }

    default public NBTFloat asNBTFloat() {
        throw new IllegalArgumentException("Tag is not float!");
    }

    default public NBTInt asNBTInt() {
        throw new IllegalArgumentException("Tag is not int!");
    }

    default public NBTIntArray asNBTIntArray() {
        throw new IllegalArgumentException("Tag is not int[]!");
    }

    default public NBTLong asNBTLong() {
        throw new IllegalArgumentException("Tag is not long!");
    }

    default public NBTLongArray asNBTLongArray() {
        throw new IllegalArgumentException("Tag is not long[]!");
    }

    default public NBTShort asNBTShort() {
        throw new IllegalArgumentException("Tag is not short!");
    }

    default public NBTString asNBTString() {
        throw new IllegalArgumentException("Tag is not string!");
    }

    @NotNull
    public String asString();

    public boolean empty();

    default public boolean notEmpty() {
        return !this.empty();
    }

    @NotNull
    public NBTBase copy();
}

