/*
 * Decompiled with CFR 0.152.
 */
package dev.framework.stack.wrapper.nbt;

import com.google.common.collect.Maps;
import dev.framework.stack.wrapper.nbt.NBTBase;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.function.BiConsumer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class NBTCompound
implements NBTBase {
    private final Map<String, NBTBase> members = Maps.newHashMap();

    @Override
    @NotNull
    public String asString() {
        return this.members.toString();
    }

    @Override
    public boolean empty() {
        return false;
    }

    @Override
    @NotNull
    public NBTBase copy() {
        NBTCompound compound = new NBTCompound();
        compound.putAll(new HashMap<String, NBTBase>(this.members));
        return compound;
    }

    @Override
    public boolean isCompound() {
        return true;
    }

    @Override
    public NBTCompound asNBTCompound() {
        return this;
    }

    public int size() {
        return this.members.size();
    }

    public boolean containsKey(@NotNull String key) {
        return this.members.containsKey(key);
    }

    public NBTBase get(@NotNull String key) {
        return this.members.get(key);
    }

    @Nullable
    public NBTBase put(@NotNull String key, @NotNull NBTBase value) {
        return this.members.put(key, value);
    }

    public NBTBase remove(@NotNull String key) {
        return this.members.remove(key);
    }

    public void putAll(@NotNull Map<? extends String, ? extends NBTBase> m) {
        this.members.putAll(m);
    }

    public void clear() {
        this.members.clear();
    }

    @NotNull
    public Set<String> keySet() {
        return this.members.keySet();
    }

    @NotNull
    public Collection<NBTBase> values() {
        return this.members.values();
    }

    @NotNull
    public Set<Map.Entry<String, NBTBase>> entrySet() {
        return this.members.entrySet();
    }

    public void forEach(@NotNull BiConsumer<String, NBTBase> consumer) {
        for (Map.Entry<String, NBTBase> entry : this.entrySet()) {
            consumer.accept(entry.getKey(), entry.getValue());
        }
    }
}

