/*
 * Decompiled with CFR 0.152.
 */
package dev.framework.stack.wrapper.nbt;

import dev.framework.stack.wrapper.nbt.NBTBase;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class NBTList
implements NBTBase,
Iterable<NBTBase> {
    private final List<NBTBase> members;

    private NBTList(@NotNull List<NBTBase> members) {
        this.members = new ArrayList<NBTBase>(members);
    }

    public NBTList() {
        this.members = new ArrayList<NBTBase>();
    }

    @Override
    @NotNull
    public String asString() {
        return this.members.toString();
    }

    @Override
    public boolean empty() {
        return this.members.isEmpty();
    }

    @Override
    @NotNull
    public NBTBase copy() {
        return new NBTList(this.members);
    }

    @Override
    public boolean isList() {
        return true;
    }

    @Override
    public NBTList asNBTList() {
        return this;
    }

    public void add(@NotNull NBTBase base) {
        this.members.add(base);
    }

    public void remove(@NotNull NBTBase base) {
        this.members.remove(base);
    }

    public boolean containsAll(@NotNull Collection<? extends NBTBase> collection) {
        return this.members.containsAll(collection);
    }

    public void addAll(@NotNull Collection<? extends NBTBase> collection) {
        this.members.addAll(collection);
    }

    public void addAll(int index, @NotNull Collection<? extends NBTBase> collection) {
        this.members.addAll(index, collection);
    }

    @Nullable
    public NBTBase get(int index) {
        return this.members.get(index);
    }

    public void set(int index, @NotNull NBTBase element) {
        this.members.set(index, element);
    }

    public void add(int index, @NotNull NBTBase element) {
        this.members.add(index, element);
    }

    public void remove(int index) {
        this.members.remove(index);
    }

    @NotNull
    public List<NBTBase> subList(int fromIndex, int toIndex) {
        return this.members.subList(fromIndex, toIndex);
    }

    public boolean contains(@NotNull NBTBase base) {
        return this.members.contains(base);
    }

    @Override
    @NotNull
    public Iterator<NBTBase> iterator() {
        return this.members.iterator();
    }
}

