/*
 * Decompiled with CFR 0.152.
 */
package dev.framework.stack.wrapper.nbt.array;

import dev.framework.stack.wrapper.nbt.NBTBase;
import java.util.Arrays;
import org.jetbrains.annotations.NotNull;

public final class NBTByteArray
implements NBTBase {
    private final byte[] data;

    public NBTByteArray(byte[] data) {
        this.data = data;
    }

    @Override
    @NotNull
    public String asString() {
        return Arrays.toString(this.data);
    }

    @Override
    public boolean empty() {
        return false;
    }

    @Override
    @NotNull
    public NBTBase copy() {
        byte[] copied = new byte[this.data.length];
        System.arraycopy(this.data, 0, copied, 0, this.data.length);
        return new NBTByteArray(copied);
    }

    @Override
    public boolean isByteArray() {
        return true;
    }

    @Override
    public NBTByteArray asNBTByteArray() {
        return this;
    }

    public byte[] asByteArray() {
        return this.data;
    }
}

