/*
 * Decompiled with CFR 0.152.
 */
package dev.framework.stack.wrapper.nbt.array;

import dev.framework.stack.wrapper.nbt.NBTBase;
import java.util.Arrays;
import org.jetbrains.annotations.NotNull;

public final class NBTIntArray
implements NBTBase {
    private final int[] data;

    public NBTIntArray(int[] data) {
        this.data = data;
    }

    @Override
    @NotNull
    public String asString() {
        return Arrays.toString(this.data);
    }

    @Override
    public boolean empty() {
        return false;
    }

    @Override
    @NotNull
    public NBTBase copy() {
        int[] copied = new int[this.data.length];
        System.arraycopy(this.data, 0, copied, 0, this.data.length);
        return new NBTIntArray(copied);
    }

    @Override
    public boolean isIntArray() {
        return true;
    }

    @Override
    public NBTIntArray asNBTIntArray() {
        return this;
    }

    public int[] asIntArray() {
        return this.data;
    }
}

