/*
 * Decompiled with CFR 0.152.
 */
package dev.framework.stack.wrapper.nbt.array;

import dev.framework.stack.wrapper.nbt.NBTBase;
import java.util.Arrays;
import org.jetbrains.annotations.NotNull;

public final class NBTLongArray
implements NBTBase {
    private final long[] data;

    public NBTLongArray(long[] data) {
        this.data = data;
    }

    @Override
    @NotNull
    public String asString() {
        return Arrays.toString(this.data);
    }

    @Override
    public boolean empty() {
        return false;
    }

    @Override
    @NotNull
    public NBTBase copy() {
        long[] copied = new long[this.data.length];
        System.arraycopy(this.data, 0, copied, 0, this.data.length);
        return new NBTLongArray(copied);
    }

    @Override
    public boolean isLongArray() {
        return true;
    }

    @Override
    public NBTLongArray asNBTLongArray() {
        return this;
    }

    public long[] asLongArray() {
        return this.data;
    }
}

