/*
 * Decompiled with CFR 0.152.
 */
package io.github.kbridge.outbound;

import io.github.kbridge.outbound.InternalGateway;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.integration.annotation.ServiceActivator;
import org.springframework.messaging.support.GenericMessage;
import org.springframework.stereotype.Component;

@Component
public class MqOutboundImpl {
    private static final Logger log = LoggerFactory.getLogger(MqOutboundImpl.class);
    @Autowired
    private InternalGateway internalGateway;

    @ServiceActivator(inputChannel="toMqChannel")
    public void toMqHandler(GenericMessage<Object> message) {
        log.info("received from toMqChannel: {} ", message.getPayload());
        this.internalGateway.sendToMq(message);
        log.info("sent to mq {} ", message.getHeaders().get((Object)"mqTopic"));
    }
}

