/*
 * Decompiled with CFR 0.152.
 */
package io.github.kbridge.outbound;

import io.github.kbridge.props.TransformerContainer;
import io.github.kbridge.transform.KafkaPayloadTransformer;
import io.github.kbridge.transform.MqPayloadTransformer;
import javax.annotation.PostConstruct;
import org.apache.kafka.clients.producer.ProducerRecord;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.jms.core.JmsTemplate;
import org.springframework.kafka.core.KafkaTemplate;
import org.springframework.messaging.support.GenericMessage;
import org.springframework.retry.annotation.Recover;
import org.springframework.retry.annotation.Retryable;
import org.springframework.stereotype.Component;

@Component
public class InternalGateway {
    private static final Logger log = LoggerFactory.getLogger(InternalGateway.class);
    @Autowired
    private KafkaTemplate<String, Object> kafkaTemplate;
    @Autowired
    private TransformerContainer transformerContainer;
    @Autowired
    private JmsTemplate jmsTemplate;
    private JmsTemplate queueJmsTemplate;
    private JmsTemplate jmsProducer = null;

    @PostConstruct
    public void init() {
        this.queueJmsTemplate = new JmsTemplate(this.jmsTemplate.getConnectionFactory());
        this.queueJmsTemplate.setPubSubDomain(false);
    }

    @Retryable(maxAttemptsExpression="${kbridge.kafka.max-try:3}", recover="recoverKafka")
    public void sendToKafka(GenericMessage<ProducerRecord<String, Object>> message) {
        try {
            this.kafkaTemplate.send((ProducerRecord)message.getPayload());
            String mqTopic = (String)message.getHeaders().get((Object)"mqTopic");
            String kafkaTopic = (String)message.getHeaders().get((Object)"kafkatopic");
            log.info("from mq-{} => kafka-{} payload:{} sent", new Object[]{mqTopic, kafkaTopic, message});
        }
        catch (Exception e) {
            log.error("something went wrong: {} ", (Object)e.toString());
            throw e;
        }
    }

    @Recover
    public void recoverKafka(Exception ex, GenericMessage<ProducerRecord<String, Object>> message) {
        String mqTopicName = (String)message.getHeaders().get((Object)"mqTopic");
        log.error("failed to send from mq: {}  to kafka: {} - after all tried: {} ", new Object[]{mqTopicName, ((ProducerRecord)message.getPayload()).topic(), ex.toString()});
        MqPayloadTransformer transformer = this.transformerContainer.findMqTransformer(message.getHeaders());
        transformer.handleOnFail(ex, message);
    }

    @Retryable(maxAttemptsExpression="${kbridge.mq.max-try:3}", recover="recoverMq")
    public void sendToMq(GenericMessage<Object> message) {
        try {
            KafkaPayloadTransformer transformer = this.transformerContainer.findKafkaTransformer(message.getHeaders());
            this.jmsProducer = transformer.isPubSubDomain() ? this.jmsTemplate : this.queueJmsTemplate;
            this.jmsProducer.convertAndSend(transformer.mqTopic(), message.getPayload());
            log.info("from kafka-{} => mq-{} payload:{} sent", new Object[]{transformer.kafkaTopic(), transformer.mqTopic(), message});
        }
        catch (Exception e) {
            log.error("something went wrong: {} ", (Object)e.toString());
            throw e;
        }
    }

    @Recover
    public void recoverMq(Exception ex, GenericMessage<Object> message) {
        String kafkaTopic = (String)message.getHeaders().get((Object)"kafkatopic");
        KafkaPayloadTransformer transformer = this.transformerContainer.findKafkaTransformer(message.getHeaders());
        log.error("failed to send from kafka: {}  to mq: {} - after all tried: {} ", new Object[]{kafkaTopic, transformer.mqTopic(), ex.toString()});
        transformer.handleOnFail(ex, message);
    }
}

