/*
 * Decompiled with CFR 0.152.
 */
package io.github.md2java.lock;

import io.github.md2java.lock.annotation.ClusterLock;
import io.github.md2java.lock.annotation.EnableClusterLock;
import io.github.md2java.lock.provider.UpdateLockScheduler;
import io.github.md2java.lock.service.ProviderWrapper;
import io.github.md2java.lock.util.BeanScannerUtil;
import java.util.Map;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.ApplicationListener;
import org.springframework.context.event.ContextRefreshedEvent;
import org.springframework.scheduling.concurrent.CustomizableThreadFactory;
import org.springframework.stereotype.Component;

@Component
public class LockInitializer
implements ApplicationListener<ContextRefreshedEvent> {
    private static final Logger log = LoggerFactory.getLogger(LockInitializer.class);
    private final ProviderWrapper providerWrapper;
    private final UpdateLockScheduler updateLockScheduler;
    private final BeanScannerUtil beanScannerUtil;
    @Value(value="${lock.bg.threads.size:2}")
    private int bgThredsSize;

    public void onApplicationEvent(ContextRefreshedEvent event) {
        this.init();
    }

    public void init() {
        this.beanScannerUtil.init();
        this.providerWrapper.initilize();
        EnableClusterLock enabledLock = BeanScannerUtil.enableClusterLock();
        Map<String, ClusterLock> configuredLocks = BeanScannerUtil.configuredLocks();
        CustomizableThreadFactory enableThreadGroup = new CustomizableThreadFactory("monitor-");
        ScheduledExecutorService enableSE = Executors.newScheduledThreadPool(this.bgThredsSize, (ThreadFactory)enableThreadGroup);
        TimeUnit milli = TimeUnit.MILLISECONDS;
        enableSE.scheduleWithFixedDelay(this.providerWrapper::monitorAll, 100L, enabledLock.monitorAt(), milli);
        CustomizableThreadFactory updateThreadGroup = new CustomizableThreadFactory("updateLock-");
        ScheduledExecutorService updateSE = Executors.newScheduledThreadPool(this.bgThredsSize, (ThreadFactory)updateThreadGroup);
        this.updateLockScheduler.setLocknames(configuredLocks.keySet());
        updateSE.scheduleWithFixedDelay(this.updateLockScheduler, 1000L, enabledLock.updateAt(), milli);
        log.debug("Initialized: {} ", (Object)this);
    }

    public LockInitializer(ProviderWrapper providerWrapper, UpdateLockScheduler updateLockScheduler, BeanScannerUtil beanScannerUtil) {
        this.providerWrapper = providerWrapper;
        this.updateLockScheduler = updateLockScheduler;
        this.beanScannerUtil = beanScannerUtil;
    }
}

