/*
 * Decompiled with CFR 0.152.
 */
package io.github.md2java.lock.provider;

import io.github.md2java.lock.model.LockInfo;
import io.github.md2java.lock.provider.LockProvider;
import io.github.md2java.lock.util.DBUtil;
import io.github.md2java.lock.util.NodeUtil;
import io.github.md2java.lock.util.QueryList;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import javax.sql.DataSource;
import org.apache.commons.lang3.BooleanUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.dao.EmptyResultDataAccessException;
import org.springframework.jdbc.core.JdbcTemplate;

public class JdbcLockProvider
implements LockProvider {
    private static final Logger log = LoggerFactory.getLogger(JdbcLockProvider.class);
    private final DataSource dataSource;
    private String node;
    private JdbcTemplate jdbcTemplate;
    private String driverClassName;

    @Override
    public void initilize() {
        this.node = NodeUtil.hostId();
        this.jdbcTemplate = new JdbcTemplate(this.dataSource);
        this.driverClassName = DBUtil.getDriverClassName(this.dataSource);
        this.createTableIfNotExist("CLUSTERLOCKINFO");
    }

    @Override
    public Map<String, Object> updateLockInfo(LockInfo lockInfo) {
        return this.updateLastRun(lockInfo.getLockname(), lockInfo);
    }

    @Override
    public Map<String, Object> updateNodeInfo(LockInfo lockInfo) {
        return this.updateSwitchNode(lockInfo.getLockname(), lockInfo);
    }

    private void createTableIfNotExist(String locktablename) {
        if (BooleanUtils.isFalse((Boolean)this.doesTableExist(locktablename))) {
            QueryList[] values = QueryList.values();
            String createTableQuery = null;
            for (QueryList queryList : values) {
                boolean contains = StringUtils.contains((CharSequence)this.driverClassName.toUpperCase(), (CharSequence)queryList.name());
                if (!contains) continue;
                createTableQuery = queryList.query();
                break;
            }
            if (StringUtils.isBlank(createTableQuery)) {
                throw new RuntimeException("something went wrong to find create table query.");
            }
            try {
                this.jdbcTemplate.execute(createTableQuery);
            }
            catch (Exception e) {
                log.error("something went wrong to to execute query: {} => {} ", createTableQuery, (Object)e.toString());
                throw e;
            }
        }
    }

    private boolean doesTableExist(String tableName) {
        try {
            this.jdbcTemplate.queryForObject("SELECT 1 FROM " + tableName + " WHERE 1 = 0", Integer.class);
            return true;
        }
        catch (EmptyResultDataAccessException e) {
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    @Override
    public Map<String, Object> findLockInfo(String lockname) {
        Map mapData = null;
        try {
            mapData = this.jdbcTemplate.queryForMap("SELECT * FROM CLUSTERLOCKINFO WHERE name =? ", new Object[]{lockname});
            return mapData;
        }
        catch (EmptyResultDataAccessException e) {
            Date currTime = new Date();
            this.jdbcTemplate.update(String.format("INSERT INTO %s  (name,lastrun,lastnoderun,activenode) VALUES(?,?,?,?)", "CLUSTERLOCKINFO"), new Object[]{lockname, currTime, currTime, this.node});
            mapData = this.jdbcTemplate.queryForMap("SELECT * FROM CLUSTERLOCKINFO WHERE name = ?", new Object[]{lockname});
            return mapData;
        }
        catch (Exception e) {
            return null;
        }
    }

    private Map<String, Object> updateLastRun(String lockname, LockInfo lockInfo) {
        Map<String, Object> mapData = null;
        try {
            lockInfo.setLastnoderun(new Date());
            int update = this.jdbcTemplate.update(String.format("UPDATE %s set lastrun=?,lastnoderun=? where name=? and activenode=?", "CLUSTERLOCKINFO"), new Object[]{lockInfo.getLastrun(), lockInfo.getLastnoderun(), lockname, lockInfo.getActiveNode()});
            if (update > 0) {
                mapData = this.buildResponse(lockname, lockInfo.getActiveNode(), lockInfo.getLastrun(), lockInfo.getLastnoderun());
            }
            return mapData;
        }
        catch (Exception e) {
            return null;
        }
    }

    private Map<String, Object> updateSwitchNode(String lockname, LockInfo lockInfo) {
        Map<String, Object> mapData = null;
        try {
            lockInfo.setLastnoderun(new Date());
            int update = this.jdbcTemplate.update(String.format("UPDATE %s set lastrun=?,lastnoderun=? ,activenode=? where name=? ", "CLUSTERLOCKINFO"), new Object[]{lockInfo.getLastrun(), lockInfo.getLastnoderun(), lockInfo.getActiveNode(), lockname});
            if (update > 0) {
                mapData = this.buildResponse(lockname, lockInfo.getActiveNode(), lockInfo.getLastrun(), lockInfo.getLastnoderun());
            }
            return mapData;
        }
        catch (Exception e) {
            log.error("something went wrong: ", (Throwable)e);
            return null;
        }
    }

    private Map<String, Object> buildResponse(String lockname, String node, Date lastrun, Date lastnoderun) {
        HashMap<String, Object> mapData = new HashMap<String, Object>();
        mapData.put("name", lockname);
        mapData.put("lastrun", lastrun);
        mapData.put("activenode", node);
        mapData.put("lastnoderun", lastnoderun);
        return mapData;
    }

    public JdbcLockProvider(DataSource dataSource) {
        this.dataSource = dataSource;
    }
}

