/*
 * Decompiled with CFR 0.152.
 */
package io.github.md2java.lock.service;

import io.github.md2java.lock.model.LockInfo;
import io.github.md2java.lock.provider.LockProvider;
import io.github.md2java.lock.service.ProviderWrapper;
import io.github.md2java.lock.util.BeanScannerUtil;
import io.github.md2java.lock.util.MemoryUtil;
import io.github.md2java.lock.util.NodeUtil;
import java.util.Date;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class ProviderWrapperImpl
implements ProviderWrapper {
    private static final Logger log = LoggerFactory.getLogger(ProviderWrapperImpl.class);
    private final LockProvider lockProvider;

    @Override
    public void initilize() {
        this.lockProvider.initilize();
        Set<String> names = BeanScannerUtil.configuredLocks().keySet();
        names.forEach(s -> this.monitorLock((String)s));
    }

    @Override
    public void monitorAll() {
        Set<String> names = BeanScannerUtil.configuredLocks().keySet();
        names.forEach(s -> {
            LockInfo lockInfo = MemoryUtil.getLockInfo(s);
            if (Objects.nonNull(lockInfo) && StringUtils.equalsIgnoreCase((CharSequence)NodeUtil.hostId(), (CharSequence)lockInfo.getActiveNode())) {
                log.debug("skipped because activenode is the current node");
                return;
            }
            this.monitorLock((String)s);
        });
    }

    private void monitorLock(String lockName) {
        log.debug("monitor scheduler started...");
        Map<String, Object> lockInfo = this.lockProvider.findLockInfo(lockName);
        MemoryUtil.updateLockInfo(lockName, lockInfo);
        if (this.isNeedToSwitchNode(lockInfo)) {
            this.switchNode(lockName);
            lockInfo = this.lockProvider.findLockInfo(lockName);
            MemoryUtil.updateLockInfo(lockName, lockInfo);
        }
    }

    private void switchNode(String lockName) {
        LockInfo updateLock = LockInfo.builder().activeNode(NodeUtil.hostId()).lockname(lockName).lastrun(new Date()).build();
        Map<String, Object> lockDetails = this.lockProvider.updateNodeInfo(updateLock);
        if (Objects.nonNull(lockDetails)) {
            log.debug("lock switched node to : {} ", (Object)updateLock.getActiveNode());
        }
    }

    private boolean isNeedToSwitchNode(Map<String, Object> lockInfo) {
        LockInfo lockInfoModel = MemoryUtil.getLockInfo(String.valueOf(lockInfo.get("name")));
        Date lastnoderun = lockInfoModel.getLastnoderun();
        Date now = new Date();
        long updateAt = MemoryUtil.getEnableClusterLock().updateAt();
        return now.getTime() - lastnoderun.getTime() > updateAt + 100L;
    }

    @Override
    public Map<String, Object> updateLock(String lockname) {
        LockInfo lockInfo = MemoryUtil.getLockInfo(lockname);
        Map<String, Object> updateLastRun = this.lockProvider.updateLockInfo(lockInfo);
        return updateLastRun;
    }

    public ProviderWrapperImpl(LockProvider lockProvider) {
        this.lockProvider = lockProvider;
    }
}

