/*
 * Decompiled with CFR 0.152.
 */
package io.github.md2java.lock.util;

import java.net.InetAddress;
import java.util.UUID;
import javax.annotation.PostConstruct;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;

@Component
public class NodeUtil {
    private static final Logger log = LoggerFactory.getLogger(NodeUtil.class);
    private static String nodeId;
    private static String hostName;
    private static String hostId;
    @Value(value="${server.port:8080}")
    private String port;

    @PostConstruct
    public void init() {
        nodeId = UUID.randomUUID().toString();
        hostName = NodeUtil.getHostName();
        hostId = String.format("%s_%s", NodeUtil.hostName(), this.port);
        log.debug("initialized - hostId: {} ", (Object)NodeUtil.hostId());
    }

    private static String getHostName() {
        try {
            InetAddress localHost = InetAddress.getLocalHost();
            return localHost.getHostName();
        }
        catch (Exception e) {
            e.printStackTrace();
            return "Unknown Host";
        }
    }

    public static String nodeId() {
        return nodeId;
    }

    public static String hostName() {
        return hostName;
    }

    public static String hostId() {
        return hostId;
    }
}

