/*
 * Decompiled with CFR 0.152.
 */
package org.example.functionapi;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.example.functionapi.FunctionDto;
import org.example.functionapi.FunctionResult;
import org.example.functionapi.RootNode;

public interface Function {
    public FunctionResult execute(FunctionDto var1, Map<Long, Map<String, Object>> var2, Map<String, Object> var3);

    public Set<Class<?>> getClassSet();

    default public void initiate() {
        for (Class<?> aClass : this.getClassSet()) {
            try {
                aClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            }
            catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
                throw new RuntimeException(e);
            }
        }
    }

    default public List<String> argumentList() {
        return new ArrayList<String>();
    }

    default public RootNode getRootNode(Object objectJson) {
        ObjectMapper mapper = new ObjectMapper();
        try {
            return new RootNode(objectJson.toString(), mapper);
        }
        catch (JsonProcessingException e) {
            throw new RuntimeException(e);
        }
    }

    default public String serializeValue(Object value) {
        ObjectMapper objectMapper = new ObjectMapper();
        try {
            return objectMapper.writeValueAsString(value);
        }
        catch (JsonProcessingException e) {
            throw new RuntimeException(e);
        }
    }
}

