/*
 * Decompiled with CFR 0.152.
 */
package org.example.functionapi;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class FunctionDto {
    private String id;
    private String functionName;
    private String versionFile;
    private Integer functionLevel;
    private Map<String, Object> argumentMap;
    private Set<String> outPutParameterCodeSet;

    public FunctionDto() {
    }

    public FunctionDto(String id, String functionName, String versionFile, Integer functionLevel, Map<String, Object> argumentMap, Set<String> outPutParameterCodeSet) {
        this.id = id;
        this.functionName = functionName;
        this.versionFile = versionFile;
        this.functionLevel = functionLevel;
        this.argumentMap = argumentMap;
        this.outPutParameterCodeSet = outPutParameterCodeSet;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getFunctionName() {
        return this.functionName;
    }

    public void setFunctionName(String functionName) {
        this.functionName = functionName;
    }

    public String getVersionFile() {
        return this.versionFile;
    }

    public void setVersionFile(String versionFile) {
        this.versionFile = versionFile;
    }

    public Integer getFunctionLevel() {
        return this.functionLevel;
    }

    public void setFunctionLevel(Integer functionLevel) {
        this.functionLevel = functionLevel;
    }

    public Map<String, Object> getArgumentMap() {
        return this.argumentMap;
    }

    public void setArgumentMap(Map<String, Object> argumentMap) {
        this.argumentMap = argumentMap;
    }

    public Set<String> getOutPutParameterCodeSet() {
        return this.outPutParameterCodeSet;
    }

    public void setOutPutParameterCodeSet(Set<String> outPutParameterCodeSet) {
        this.outPutParameterCodeSet = outPutParameterCodeSet;
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        return "FunctionDto{id='" + this.id + "', functionName='" + this.functionName + "', versionFile='" + this.versionFile + "', functionLevel=" + this.functionLevel + ", argumentMap=" + String.valueOf(this.argumentMap) + ", outPutParameterCodeSet=" + String.valueOf(this.outPutParameterCodeSet) + "}";
    }

    public static class Builder {
        private String id;
        private String functionName;
        private String versionFile;
        private Integer functionLevel;
        private Map<String, Object> argumentMap = new HashMap<String, Object>();
        private Set<String> outPutParameterCodeSet = new HashSet<String>();

        public Builder id(String id) {
            this.id = id;
            return this;
        }

        public Builder functionName(String functionName) {
            this.functionName = functionName;
            return this;
        }

        public Builder versionFile(String versionFile) {
            this.versionFile = versionFile;
            return this;
        }

        public Builder functionLevel(Integer functionLevel) {
            this.functionLevel = functionLevel;
            return this;
        }

        public Builder argumentMap(Map<String, Object> argumentMap) {
            if (argumentMap != null) {
                this.argumentMap = new HashMap<String, Object>(argumentMap);
            }
            return this;
        }

        public Builder addArgument(String key, Object value) {
            this.argumentMap.put(key, value);
            return this;
        }

        public Builder outPutParameterCodeSet(Set<String> outPutParameterCodeSet) {
            if (outPutParameterCodeSet != null) {
                this.outPutParameterCodeSet = new HashSet<String>(outPutParameterCodeSet);
            }
            return this;
        }

        public Builder addOutputParameter(String parameterCode) {
            this.outPutParameterCodeSet.add(parameterCode);
            return this;
        }

        public Builder addOutputParameters(Set<String> parameterCodes) {
            this.outPutParameterCodeSet.addAll(parameterCodes);
            return this;
        }

        public FunctionDto build() {
            return new FunctionDto(this.id, this.functionName, this.versionFile, this.functionLevel, this.argumentMap, this.outPutParameterCodeSet);
        }
    }
}

