/*
 * Decompiled with CFR 0.152.
 */
package org.example.functionapi;

import java.util.HashMap;
import java.util.Map;

public class FunctionResult {
    private Map<Long, Map<String, Object>> functionResultMap;
    private Map<String, Object> someParam;

    public FunctionResult() {
    }

    public FunctionResult(Map<Long, Map<String, Object>> functionResultMap, Map<String, Object> someParam) {
        this.functionResultMap = functionResultMap;
        this.someParam = someParam;
    }

    public Map<Long, Map<String, Object>> getFunctionResultMap() {
        return this.functionResultMap;
    }

    public void setFunctionResultMap(Map<Long, Map<String, Object>> functionResultMap) {
        this.functionResultMap = functionResultMap;
    }

    public Map<String, Object> getSomeParam() {
        return this.someParam;
    }

    public void setSomeParam(Map<String, Object> someParam) {
        this.someParam = someParam;
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        return "FunctionResult{functionResultMap=" + String.valueOf(this.functionResultMap) + ", someParam=" + String.valueOf(this.someParam) + "}";
    }

    public static class Builder {
        private Map<Long, Map<String, Object>> functionResultMap = new HashMap<Long, Map<String, Object>>();
        private Map<String, Object> someParam = new HashMap<String, Object>();

        public Builder functionResultMap(Map<Long, Map<String, Object>> functionResultMap) {
            if (functionResultMap != null) {
                this.functionResultMap = new HashMap<Long, Map<String, Object>>(functionResultMap);
            }
            return this;
        }

        public Builder addFunctionResult(Long key, Map<String, Object> valueMap) {
            if (key != null && valueMap != null) {
                this.functionResultMap.put(key, new HashMap<String, Object>(valueMap));
            }
            return this;
        }

        public Builder addFunctionResultEntry(Long key, String innerKey, Object innerValue) {
            if (key != null && innerKey != null) {
                this.functionResultMap.computeIfAbsent(key, k -> new HashMap()).put(innerKey, innerValue);
            }
            return this;
        }

        public Builder someParam(Map<String, Object> someParam) {
            if (someParam != null) {
                this.someParam = new HashMap<String, Object>(someParam);
            }
            return this;
        }

        public Builder addSomeParam(String key, Object value) {
            if (key != null) {
                this.someParam.put(key, value);
            }
            return this;
        }

        public Builder addSomeParams(Map<String, Object> params) {
            if (params != null) {
                this.someParam.putAll(params);
            }
            return this;
        }

        public Builder clearFunctionResultMap() {
            this.functionResultMap.clear();
            return this;
        }

        public Builder clearSomeParam() {
            this.someParam.clear();
            return this;
        }

        public FunctionResult build() {
            return new FunctionResult(this.functionResultMap, this.someParam);
        }
    }
}

