/*
 * Decompiled with CFR 0.152.
 */
package org.example.functionapi;

import java.util.Map;
import org.springframework.http.HttpMethod;
import org.springframework.web.reactive.function.client.WebClient;
import org.springframework.web.util.UriBuilder;
import reactor.core.publisher.Mono;

public class DynamicWebClient {
    private final WebClient webClient;

    public DynamicWebClient(String baseUrl) {
        this.webClient = WebClient.builder().baseUrl(baseUrl).build();
    }

    public <T> Mono<T> execute(String path, HttpMethod method, Map<String, String> params, Object body, Class<T> responseType) {
        WebClient.RequestBodySpec requestSpec = (WebClient.RequestBodySpec)this.webClient.method(method).uri(uriBuilder -> {
            UriBuilder builder = uriBuilder.path(path);
            if (params != null) {
                params.forEach((x$0, xva$1) -> builder.queryParam(x$0, new Object[]{xva$1}));
            }
            return builder.build(new Object[0]);
        });
        if (this.requiresBody(method) && body != null) {
            requestSpec = (WebClient.RequestBodySpec)requestSpec.bodyValue(body);
        }
        return requestSpec.retrieve().bodyToMono(responseType);
    }

    private boolean requiresBody(HttpMethod method) {
        return method == HttpMethod.POST || method == HttpMethod.PUT || method == HttpMethod.PATCH;
    }
}

