/*
 * Decompiled with CFR 0.152.
 */
package org.example.functionapi;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.BigIntegerNode;
import com.fasterxml.jackson.databind.node.BooleanNode;
import com.fasterxml.jackson.databind.node.DecimalNode;
import com.fasterxml.jackson.databind.node.DoubleNode;
import com.fasterxml.jackson.databind.node.FloatNode;
import com.fasterxml.jackson.databind.node.IntNode;
import com.fasterxml.jackson.databind.node.LongNode;
import com.fasterxml.jackson.databind.node.ShortNode;
import com.fasterxml.jackson.databind.node.TextNode;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.example.functionapi.ExportType;

public class RootNode {
    private final JsonNode rootJsonNode;
    private final ObjectMapper objectMapper;
    private JsonNode transientJsonNode;

    public RootNode(String objectJson, ObjectMapper mapper) throws JsonProcessingException {
        this.objectMapper = mapper;
        this.rootJsonNode = mapper.readTree(objectJson);
    }

    public RootNode(JsonNode rootJsonNode, ObjectMapper mapper) {
        this.objectMapper = mapper;
        this.rootJsonNode = rootJsonNode;
    }

    public RootNode getNode() {
        this.transientJsonNode = null;
        return this;
    }

    public RootNode goToNode(String fieldName) {
        if (this.transientJsonNode != null) {
            this.transientJsonNode = Optional.ofNullable(this.transientJsonNode.get(fieldName)).orElseThrow(() -> new RuntimeException("Cannot invoke \"getNode\" because \"" + fieldName + "\" not found"));
        } else {
            if (this.rootJsonNode == null) {
                throw new IllegalArgumentException("rootJsonNode is null");
            }
            this.transientJsonNode = Optional.ofNullable(this.rootJsonNode.get(fieldName)).orElseThrow(() -> new RuntimeException("Cannot invoke \"getNode\" because \"" + fieldName + "\" not found"));
        }
        return this;
    }

    public List<RootNode> toRootNodeList() {
        ArrayList<RootNode> result;
        JsonNode jsonNode;
        JsonNode jsonNode2 = jsonNode = this.transientJsonNode != null ? this.transientJsonNode : this.rootJsonNode;
        if (jsonNode == null) {
            throw new IllegalArgumentException("rootJsonNode is null");
        }
        if (this.getType(jsonNode).contains((Object)ExportType.ARRAY)) {
            result = new ArrayList<RootNode>();
            for (JsonNode node : jsonNode) {
                result.add(new RootNode(node, this.objectMapper));
            }
        } else {
            throw new RuntimeException("Cannot invoke \"toRootNodeList\" because \"" + String.valueOf(jsonNode) + "\" not Array");
        }
        return result;
    }

    public List<RootNode> toRootNodeList(String fieldName) {
        return this.goToNode(fieldName).toRootNodeList();
    }

    public <T> List<T> toObjectList(Class<T> aClass) {
        return this.toRootNodeList().stream().map(rootNode -> rootNode.toObject(aClass)).collect(Collectors.toList());
    }

    public <T> List<T> toObjectList(String fieldName, Class<T> aClass) {
        return this.goToNode(fieldName).toObjectList(aClass);
    }

    public <T> T toObject(String fieldName, Class<T> aClass) {
        Optional<JsonNode> jsonNode = this.getValue(fieldName);
        return jsonNode.map(node -> this.objectMapper.convertValue(node, aClass)).orElse(null);
    }

    public <T> T toObject(Class<T> aClass) {
        if (this.transientJsonNode != null) {
            return (T)this.objectMapper.convertValue((Object)this.transientJsonNode, aClass);
        }
        return (T)this.objectMapper.convertValue((Object)this.rootJsonNode, aClass);
    }

    public Optional<JsonNode> getValue() {
        if (this.transientJsonNode != null) {
            return Optional.of(this.transientJsonNode);
        }
        return Optional.ofNullable(this.rootJsonNode);
    }

    public Optional<JsonNode> getValue(String fieldName) {
        return this.goToNode(fieldName).getValue();
    }

    public String getStringValue(String fieldName) {
        return this.getValue(fieldName).map(this::textValue).map(this::writeValueAsString).orElse(null);
    }

    private String writeValueAsString(String s) {
        try {
            return this.objectMapper.writeValueAsString((Object)s);
        }
        catch (JsonProcessingException e) {
            throw new RuntimeException(e);
        }
    }

    public String getStringValue() {
        return this.getValue().map(this::textValue).orElse(null);
    }

    private String textValue(JsonNode jsonNode) {
        if (this.getType(jsonNode).contains((Object)ExportType.TEXT)) {
            return jsonNode.textValue();
        }
        throw new RuntimeException("Cannot invoke \"getStringValue\" because '" + String.valueOf(jsonNode) + "' not String");
    }

    public BigDecimal getBigDecimalValue(String fieldName) {
        return this.getValue(fieldName).map(this::asBigDecimal).orElse(null);
    }

    public BigDecimal getBigDecimalValue() {
        return this.getValue().map(this::asBigDecimal).orElse(null);
    }

    private BigDecimal asBigDecimal(JsonNode jsonNode) {
        if (this.getType(jsonNode).contains((Object)ExportType.BIG_DECIMAL)) {
            return jsonNode.decimalValue();
        }
        throw new RuntimeException("Cannot invoke \"getDecimalValue\" because '" + String.valueOf(jsonNode) + "' not BigDecimal");
    }

    public Boolean getBooleanValue(String fieldName) {
        return this.getValue(fieldName).map(JsonNode::booleanValue).orElse(null);
    }

    public Boolean getBooleanValue() {
        return this.getValue().map(this::booleanValue).orElse(null);
    }

    private Boolean booleanValue(JsonNode jsonNode) {
        if (this.getType(jsonNode).contains((Object)ExportType.BOOLEAN)) {
            return jsonNode.booleanValue();
        }
        throw new RuntimeException("Cannot invoke \"getBooleanValue\" because '" + String.valueOf(jsonNode) + "' not Boolean");
    }

    public Integer getIntegerValue(String fieldName) {
        return this.getValue(fieldName).map(this::intValue).orElse(null);
    }

    public Integer getIntegerValue() {
        return this.getValue().map(this::intValue).orElse(null);
    }

    private Integer intValue(JsonNode jsonNode) {
        if (this.getType(jsonNode).contains((Object)ExportType.INTEGER)) {
            return jsonNode.intValue();
        }
        throw new RuntimeException("Cannot invoke \"getIntegerValue\" because '" + String.valueOf(jsonNode) + "' not Integer");
    }

    public Long getLongValue(String fieldName) {
        return this.getValue(fieldName).map(this::longValue).orElse(null);
    }

    public Long getLongValue() {
        return this.getValue().map(this::longValue).orElse(null);
    }

    private Long longValue(JsonNode jsonNode) {
        if (this.getType(jsonNode).contains((Object)ExportType.LONG)) {
            return jsonNode.longValue();
        }
        throw new RuntimeException("Cannot invoke \"getLongValue\" because '" + String.valueOf(jsonNode) + "' not Long");
    }

    private List<ExportType> getType(JsonNode jsonNode) {
        ExportType[] result = new ExportType[]{};
        if (jsonNode instanceof ArrayNode) {
            result = new ExportType[]{ExportType.ARRAY};
        }
        if (jsonNode instanceof BooleanNode) {
            result = new ExportType[]{ExportType.BOOLEAN};
        }
        if (jsonNode instanceof TextNode) {
            result = new ExportType[]{ExportType.TEXT};
        }
        if (jsonNode instanceof BigIntegerNode || jsonNode instanceof DecimalNode || jsonNode instanceof DoubleNode || jsonNode instanceof FloatNode) {
            result = new ExportType[]{ExportType.BIG_DECIMAL};
        }
        if (jsonNode instanceof IntNode || jsonNode instanceof ShortNode) {
            result = new ExportType[]{ExportType.INTEGER, ExportType.LONG, ExportType.BIG_DECIMAL};
        }
        if (jsonNode instanceof LongNode) {
            result = new ExportType[]{ExportType.LONG, ExportType.BIG_DECIMAL};
        }
        return Arrays.stream(result).collect(Collectors.toList());
    }
}

