/*
 * Decompiled with CFR 0.152.
 */
package io.github.microapplet.remote.config;

import io.github.microapplet.remote.config.RemoteLocalEnvProperty;
import io.github.microapplet.remote.config.RemoteLocalEnvironment;
import java.util.Objects;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.env.Environment;

@Configuration
public class RemoteLocalEnvConfiguration
implements ApplicationContextAware,
InitializingBean {
    private static final Logger log = LoggerFactory.getLogger(RemoteLocalEnvConfiguration.class);
    private ApplicationContext applicationContext;
    private RemoteLocalEnvProperty property;

    @Autowired(required=false)
    public void setProperty(RemoteLocalEnvProperty property) {
        this.property = property;
    }

    public void afterPropertiesSet() {
        if (Objects.isNull(this.property)) {
            this.property = new RemoteLocalEnvProperty();
        }
        if (Objects.nonNull(this.property.getEnable()) || Objects.nonNull(this.property.getEnv()) || Objects.nonNull(this.property.getArch()) || Objects.nonNull(this.property.getPrimaries())) {
            return;
        }
        Environment environment = this.applicationContext.getEnvironment();
        String enable = environment.getProperty("remote.local.enable");
        String env = environment.getProperty("remote.local.env");
        String arch = environment.getProperty("remote.local.arch");
        String primaries = environment.getProperty("remote.local.primaries");
        this.property.setEnable(Boolean.valueOf(enable));
        this.property.setEnv(RemoteLocalEnvironment.RemoteLocalEnv.nameOf((String)env));
        this.property.setArch(RemoteLocalEnvironment.Arch.nameOf((String)arch));
        this.property.setPrimaries(primaries);
    }

    @Bean
    @ConditionalOnMissingBean
    public RemoteLocalEnvironment localEnvironment() {
        log.info("Remote \u672c\u5730\u73af\u5883\uff1a{}", (Object)this.property);
        return new RemoteLocalEnvironment(){

            public RemoteLocalEnvironment.RemoteLocalEnv doLocalEnv() {
                return Optional.ofNullable(RemoteLocalEnvConfiguration.this.property).map(RemoteLocalEnvProperty::getEnv).orElse(RemoteLocalEnvironment.RemoteLocalEnv.DEFT);
            }

            public RemoteLocalEnvironment.Arch arch() {
                return Optional.ofNullable(RemoteLocalEnvConfiguration.this.property).map(RemoteLocalEnvProperty::getArch).orElse(RemoteLocalEnvironment.Arch.X86);
            }
        };
    }

    public void setApplicationContext(ApplicationContext applicationContext) {
        this.applicationContext = applicationContext;
    }
}

