/*
 * Decompiled with CFR 0.152.
 */
package io.github.microapplet.remote.spring;

import io.github.microapplet.remote.annotation.RemoteLifeCycle;
import io.github.microapplet.remote.context.RemoteLifeCycleHandlerFactory;
import io.github.microapplet.remote.loader.RemoteClassLoader;
import io.github.microapplet.remote.spring.RemoteFactoryBean;
import io.github.microapplet.remote.spring.RemoteScan;
import java.io.IOException;
import java.lang.annotation.Annotation;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.support.AbstractBeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.beans.factory.support.DefaultListableBeanFactory;
import org.springframework.context.annotation.ImportBeanDefinitionRegistrar;
import org.springframework.core.env.Environment;
import org.springframework.core.env.StandardEnvironment;
import org.springframework.core.io.Resource;
import org.springframework.core.io.support.PathMatchingResourcePatternResolver;
import org.springframework.core.io.support.ResourcePatternResolver;
import org.springframework.core.type.AnnotationMetadata;
import org.springframework.core.type.ClassMetadata;
import org.springframework.core.type.classreading.CachingMetadataReaderFactory;
import org.springframework.core.type.classreading.MetadataReader;
import org.springframework.core.type.classreading.MetadataReaderFactory;
import org.springframework.util.ClassUtils;

public class RemoteBeanDefinitionRegistrar
implements ImportBeanDefinitionRegistrar {
    private static final Logger log = LoggerFactory.getLogger(RemoteBeanDefinitionRegistrar.class);
    private static final Set<String> CLASSES = new HashSet<String>();
    private static final ResourcePatternResolver RESOLVER = new PathMatchingResourcePatternResolver();
    private static final MetadataReaderFactory METADATA_READER_FACTORY = new CachingMetadataReaderFactory();
    private static final Environment ENVIRONMENT = new StandardEnvironment();
    private static boolean init = false;

    private void init(BeanDefinitionRegistry applicationContext) {
        if (init) {
            return;
        }
        if (!(applicationContext instanceof DefaultListableBeanFactory)) {
            return;
        }
        DefaultListableBeanFactory beanFactory = (DefaultListableBeanFactory)applicationContext;
        Environment environment = (Environment)beanFactory.getBean(Environment.class);
        String primaries = environment.getProperty("remote.local.primaries");
        RemoteLifeCycleHandlerFactory.primary((String)primaries);
        RemoteClassLoader.classLoader((ClassLoader)beanFactory.getBeanClassLoader());
        RemoteClassLoader.INSTANCE.init();
        init = true;
    }

    public void registerBeanDefinitions(AnnotationMetadata metadata, BeanDefinitionRegistry registry) {
        this.init(registry);
        String configClassName = metadata.getClassName();
        HashSet<String> packages = new HashSet<String>();
        try {
            this.selectBrokerScanClass(Class.forName(configClassName), packages);
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        for (String aPackage : packages) {
            try {
                Resource[] resources;
                String resourcePattern = "**/*.class";
                String packageSearchPath = "classpath*:" + ClassUtils.convertClassNameToResourcePath((String)ENVIRONMENT.resolveRequiredPlaceholders(aPackage)) + "/" + resourcePattern;
                for (Resource resource : resources = RESOLVER.getResources(packageSearchPath)) {
                    ClassMetadata classMetadata;
                    String className;
                    MetadataReader metadataReader = METADATA_READER_FACTORY.getMetadataReader(resource);
                    AnnotationMetadata annotationMetadata = metadataReader.getAnnotationMetadata();
                    if (Objects.isNull(annotationMetadata) || annotationMetadata.isAnnotation() || !annotationMetadata.isInterface() || StringUtils.isBlank((CharSequence)(className = (classMetadata = metadataReader.getClassMetadata()).getClassName()))) continue;
                    try {
                        Class<?> aClass = Class.forName(className);
                        boolean candidateClass = this.candidateClass(aClass);
                        if (!candidateClass || CLASSES.contains(className)) continue;
                        CLASSES.add(className);
                        BeanDefinitionBuilder builder = BeanDefinitionBuilder.genericBeanDefinition(RemoteFactoryBean.class);
                        builder.addPropertyValue("remoteInterface", (Object)className);
                        builder.setLazyInit(true);
                        AbstractBeanDefinition beanDefinition = builder.getBeanDefinition();
                        registry.registerBeanDefinition(className, (BeanDefinition)beanDefinition);
                    }
                    catch (ClassNotFoundException e) {
                        log.error("Cannot Found Class: {}, Exception: {}", new Object[]{className, e.getMessage(), e});
                    }
                }
            }
            catch (IOException e) {
                log.warn("Resolve package: {} to Find Remote Client Classes Exception Happen: {}", new Object[]{aPackage, e.getMessage(), e});
            }
        }
    }

    private void selectBrokerScanClass(Class<?> sourceClass, Set<String> packages) {
        Annotation[] annotations;
        Class<?> superclass = sourceClass.getSuperclass();
        if (!Object.class.equals(superclass)) {
            this.selectBrokerScanClass(superclass, packages);
        }
        for (Annotation annotation : annotations = sourceClass.getAnnotations()) {
            this.selectBrokerScanClass(annotation, packages);
        }
    }

    private void selectBrokerScanClass(Annotation annotation, Set<String> packages) {
        if (Objects.isNull(annotation)) {
            return;
        }
        if (annotation instanceof RemoteScan) {
            String[] value = ((RemoteScan)annotation).value();
            packages.addAll(Arrays.asList(value));
            return;
        }
        if (annotation.annotationType().getName().startsWith("java.lang.annotation")) {
            return;
        }
        Object[] annotations = annotation.annotationType().getAnnotations();
        if (ArrayUtils.isNotEmpty((Object[])annotations)) {
            for (Object annotation1 : annotations) {
                this.selectBrokerScanClass((Annotation)annotation1, packages);
            }
        }
    }

    private boolean candidateClass(Class<?> sourceClass) {
        Annotation[] annotations;
        for (Annotation annotation : annotations = sourceClass.getAnnotations()) {
            boolean b = this.candidateAnnotation(annotation);
            if (!b) continue;
            return true;
        }
        Class<?> superclass = sourceClass.getSuperclass();
        if (Objects.nonNull(superclass)) {
            return this.candidateClass(superclass);
        }
        return false;
    }

    private boolean candidateAnnotation(Annotation annotation) {
        Class<? extends Annotation> annotationType = annotation.annotationType();
        if (annotationType.getName().startsWith("java.lang.annotation")) {
            return false;
        }
        if (annotationType.isAnnotationPresent(RemoteLifeCycle.class)) {
            return true;
        }
        Object[] annotations = annotationType.getAnnotations();
        if (ArrayUtils.isNotEmpty((Object[])annotations)) {
            for (Object annotation1 : annotations) {
                boolean b = this.candidateAnnotation((Annotation)annotation1);
                if (!b) continue;
                return true;
            }
        }
        return false;
    }
}

