/*
 * Decompiled with CFR 0.152.
 */
package io.github.microapplet.remote.spring;

import io.github.microapplet.remote.proxy.RemoteProxy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.FactoryBean;

public class RemoteFactoryBean<T>
implements FactoryBean<T> {
    private static final Logger log = LoggerFactory.getLogger(RemoteFactoryBean.class);
    private Class<T> remoteInterface;

    public T getObject() {
        if (log.isDebugEnabled()) {
            log.info("Create Remote Instance for: {}", (Object)this.remoteInterface.getName());
        }
        return (T)RemoteProxy.create(this.remoteInterface);
    }

    public Class<?> getObjectType() {
        return this.remoteInterface;
    }

    public Class<T> getRemoteInterface() {
        return this.remoteInterface;
    }

    public void setRemoteInterface(Class<T> remoteInterface) {
        this.remoteInterface = remoteInterface;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof RemoteFactoryBean)) {
            return false;
        }
        RemoteFactoryBean other = (RemoteFactoryBean)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Class<T> this$remoteInterface = this.getRemoteInterface();
        Class<T> other$remoteInterface = other.getRemoteInterface();
        return !(this$remoteInterface == null ? other$remoteInterface != null : !this$remoteInterface.equals(other$remoteInterface));
    }

    protected boolean canEqual(Object other) {
        return other instanceof RemoteFactoryBean;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Class<T> $remoteInterface = this.getRemoteInterface();
        result = result * 59 + ($remoteInterface == null ? 43 : $remoteInterface.hashCode());
        return result;
    }

    public String toString() {
        return "RemoteFactoryBean(remoteInterface=" + this.getRemoteInterface() + ")";
    }
}

