/*
 * Decompiled with CFR 0.152.
 */
package io.github.microcks.client.api;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.github.microcks.client.ApiClient;
import io.github.microcks.client.ApiException;
import io.github.microcks.client.ApiResponse;
import io.github.microcks.client.Pair;
import io.github.microcks.client.model.Counter;
import io.github.microcks.client.model.ImportJob;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.nio.channels.Channels;
import java.nio.channels.Pipe;
import java.nio.charset.StandardCharsets;
import java.time.Duration;
import java.util.ArrayList;
import java.util.List;
import java.util.Scanner;
import java.util.StringJoiner;
import java.util.function.Consumer;
import org.apache.http.HttpEntity;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.entity.mime.MultipartEntityBuilder;
import org.apache.http.message.BasicNameValuePair;

public class JobApi {
    private final HttpClient memberVarHttpClient;
    private final ObjectMapper memberVarObjectMapper;
    private final String memberVarBaseUri;
    private final Consumer<HttpRequest.Builder> memberVarInterceptor;
    private final Duration memberVarReadTimeout;
    private final Consumer<HttpResponse<InputStream>> memberVarResponseInterceptor;
    private final Consumer<HttpResponse<String>> memberVarAsyncResponseInterceptor;

    public JobApi() {
        this(new ApiClient());
    }

    public JobApi(ApiClient apiClient) {
        this.memberVarHttpClient = apiClient.getHttpClient();
        this.memberVarObjectMapper = apiClient.getObjectMapper();
        this.memberVarBaseUri = apiClient.getBaseUri();
        this.memberVarInterceptor = apiClient.getRequestInterceptor();
        this.memberVarReadTimeout = apiClient.getReadTimeout();
        this.memberVarResponseInterceptor = apiClient.getResponseInterceptor();
        this.memberVarAsyncResponseInterceptor = apiClient.getAsyncResponseInterceptor();
    }

    protected ApiException getApiException(String operationId, HttpResponse<InputStream> response) throws IOException {
        String body = response.body() == null ? null : new String(response.body().readAllBytes());
        String message = this.formatExceptionMessage(operationId, response.statusCode(), body);
        return new ApiException(response.statusCode(), message, response.headers(), body);
    }

    private String formatExceptionMessage(String operationId, int statusCode, String body) {
        if (body == null || body.isEmpty()) {
            body = "[no body]";
        }
        return operationId + " call failed with: " + statusCode + " - " + body;
    }

    public ImportJob activateImportJob(String id) throws ApiException {
        ApiResponse<ImportJob> localVarResponse = this.activateImportJobWithHttpInfo(id);
        return localVarResponse.getData();
    }

    public ApiResponse<ImportJob> activateImportJobWithHttpInfo(String id) throws ApiException {
        HttpRequest.Builder localVarRequestBuilder = this.activateImportJobRequestBuilder(id);
        try {
            HttpResponse<InputStream> localVarResponse = this.memberVarHttpClient.send(localVarRequestBuilder.build(), HttpResponse.BodyHandlers.ofInputStream());
            if (this.memberVarResponseInterceptor != null) {
                this.memberVarResponseInterceptor.accept(localVarResponse);
            }
            if (localVarResponse.statusCode() / 100 != 2) {
                throw this.getApiException("activateImportJob", localVarResponse);
            }
            return new ApiResponse<Object>(localVarResponse.statusCode(), localVarResponse.headers().map(), (localVarResponse.body() == null ? null : (ImportJob)this.memberVarObjectMapper.readValue(localVarResponse.body(), (TypeReference)new TypeReference<ImportJob>(){})));
        }
        catch (IOException e) {
            throw new ApiException(e);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new ApiException(e);
        }
    }

    private HttpRequest.Builder activateImportJobRequestBuilder(String id) throws ApiException {
        if (id == null) {
            throw new ApiException(400, "Missing the required parameter 'id' when calling activateImportJob");
        }
        HttpRequest.Builder localVarRequestBuilder = HttpRequest.newBuilder();
        String localVarPath = "/jobs/{id}/activate".replace("{id}", ApiClient.urlEncode(id.toString()));
        localVarRequestBuilder.uri(URI.create(this.memberVarBaseUri + localVarPath));
        localVarRequestBuilder.header("Accept", "application/json");
        localVarRequestBuilder.method("PUT", HttpRequest.BodyPublishers.noBody());
        if (this.memberVarReadTimeout != null) {
            localVarRequestBuilder.timeout(this.memberVarReadTimeout);
        }
        if (this.memberVarInterceptor != null) {
            this.memberVarInterceptor.accept(localVarRequestBuilder);
        }
        return localVarRequestBuilder;
    }

    public ImportJob createImportJob(ImportJob importJob) throws ApiException {
        ApiResponse<ImportJob> localVarResponse = this.createImportJobWithHttpInfo(importJob);
        return localVarResponse.getData();
    }

    public ApiResponse<ImportJob> createImportJobWithHttpInfo(ImportJob importJob) throws ApiException {
        HttpRequest.Builder localVarRequestBuilder = this.createImportJobRequestBuilder(importJob);
        try {
            HttpResponse<InputStream> localVarResponse = this.memberVarHttpClient.send(localVarRequestBuilder.build(), HttpResponse.BodyHandlers.ofInputStream());
            if (this.memberVarResponseInterceptor != null) {
                this.memberVarResponseInterceptor.accept(localVarResponse);
            }
            if (localVarResponse.statusCode() / 100 != 2) {
                throw this.getApiException("createImportJob", localVarResponse);
            }
            return new ApiResponse<Object>(localVarResponse.statusCode(), localVarResponse.headers().map(), (localVarResponse.body() == null ? null : (ImportJob)this.memberVarObjectMapper.readValue(localVarResponse.body(), (TypeReference)new TypeReference<ImportJob>(){})));
        }
        catch (IOException e) {
            throw new ApiException(e);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new ApiException(e);
        }
    }

    private HttpRequest.Builder createImportJobRequestBuilder(ImportJob importJob) throws ApiException {
        if (importJob == null) {
            throw new ApiException(400, "Missing the required parameter 'importJob' when calling createImportJob");
        }
        HttpRequest.Builder localVarRequestBuilder = HttpRequest.newBuilder();
        String localVarPath = "/jobs";
        localVarRequestBuilder.uri(URI.create(this.memberVarBaseUri + localVarPath));
        localVarRequestBuilder.header("Content-Type", "application/json");
        localVarRequestBuilder.header("Accept", "application/json");
        try {
            byte[] localVarPostBody = this.memberVarObjectMapper.writeValueAsBytes((Object)importJob);
            localVarRequestBuilder.method("POST", HttpRequest.BodyPublishers.ofByteArray(localVarPostBody));
        }
        catch (IOException e) {
            throw new ApiException(e);
        }
        if (this.memberVarReadTimeout != null) {
            localVarRequestBuilder.timeout(this.memberVarReadTimeout);
        }
        if (this.memberVarInterceptor != null) {
            this.memberVarInterceptor.accept(localVarRequestBuilder);
        }
        return localVarRequestBuilder;
    }

    public void deleteImportJob(String id) throws ApiException {
        this.deleteImportJobWithHttpInfo(id);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ApiResponse<Void> deleteImportJobWithHttpInfo(String id) throws ApiException {
        ApiResponse<Object> apiResponse;
        HttpRequest.Builder localVarRequestBuilder = this.deleteImportJobRequestBuilder(id);
        HttpResponse<InputStream> localVarResponse = this.memberVarHttpClient.send(localVarRequestBuilder.build(), HttpResponse.BodyHandlers.ofInputStream());
        if (this.memberVarResponseInterceptor != null) {
            this.memberVarResponseInterceptor.accept(localVarResponse);
        }
        try {
            if (localVarResponse.statusCode() / 100 != 2) {
                throw this.getApiException("deleteImportJob", localVarResponse);
            }
            apiResponse = new ApiResponse<Object>(localVarResponse.statusCode(), localVarResponse.headers().map(), null);
        }
        catch (Throwable throwable) {
            try {
                while (localVarResponse.body().read() != -1) {
                }
                localVarResponse.body().close();
                throw throwable;
            }
            catch (IOException e) {
                throw new ApiException(e);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                throw new ApiException(e);
            }
        }
        while (localVarResponse.body().read() != -1) {
        }
        localVarResponse.body().close();
        return apiResponse;
    }

    private HttpRequest.Builder deleteImportJobRequestBuilder(String id) throws ApiException {
        if (id == null) {
            throw new ApiException(400, "Missing the required parameter 'id' when calling deleteImportJob");
        }
        HttpRequest.Builder localVarRequestBuilder = HttpRequest.newBuilder();
        String localVarPath = "/jobs/{id}".replace("{id}", ApiClient.urlEncode(id.toString()));
        localVarRequestBuilder.uri(URI.create(this.memberVarBaseUri + localVarPath));
        localVarRequestBuilder.header("Accept", "application/json");
        localVarRequestBuilder.method("DELETE", HttpRequest.BodyPublishers.noBody());
        if (this.memberVarReadTimeout != null) {
            localVarRequestBuilder.timeout(this.memberVarReadTimeout);
        }
        if (this.memberVarInterceptor != null) {
            this.memberVarInterceptor.accept(localVarRequestBuilder);
        }
        return localVarRequestBuilder;
    }

    public String downloadArtifact(String url, Boolean mainArtifact, String secretName) throws ApiException {
        ApiResponse<String> localVarResponse = this.downloadArtifactWithHttpInfo(url, mainArtifact, secretName);
        return localVarResponse.getData();
    }

    public ApiResponse<String> downloadArtifactWithHttpInfo(String url, Boolean mainArtifact, String secretName) throws ApiException {
        HttpRequest.Builder localVarRequestBuilder = this.downloadArtifactRequestBuilder(url, mainArtifact, secretName);
        try {
            HttpResponse<InputStream> localVarResponse = this.memberVarHttpClient.send(localVarRequestBuilder.build(), HttpResponse.BodyHandlers.ofInputStream());
            if (this.memberVarResponseInterceptor != null) {
                this.memberVarResponseInterceptor.accept(localVarResponse);
            }
            if (localVarResponse.statusCode() / 100 != 2) {
                throw this.getApiException("downloadArtifact", localVarResponse);
            }
            if (localVarResponse.headers().map().containsKey("Content-Type") && "text/plain".equalsIgnoreCase(localVarResponse.headers().map().get("Content-Type").get(0).split(";")[0].trim())) {
                Scanner s = new Scanner(localVarResponse.body()).useDelimiter("\\A");
                String responseBodyText = s.hasNext() ? s.next() : "";
                return new ApiResponse<String>(localVarResponse.statusCode(), localVarResponse.headers().map(), responseBodyText);
            }
            throw new RuntimeException("Error! The response Content-Type is supposed to be `text/plain` but it's not: " + localVarResponse);
        }
        catch (IOException e) {
            throw new ApiException(e);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new ApiException(e);
        }
    }

    private HttpRequest.Builder downloadArtifactRequestBuilder(String url, Boolean mainArtifact, String secretName) throws ApiException {
        if (url == null) {
            throw new ApiException(400, "Missing the required parameter 'url' when calling downloadArtifact");
        }
        HttpRequest.Builder localVarRequestBuilder = HttpRequest.newBuilder();
        String localVarPath = "/artifact/download";
        localVarRequestBuilder.uri(URI.create(this.memberVarBaseUri + localVarPath));
        localVarRequestBuilder.header("Accept", "text/plain");
        ArrayList<BasicNameValuePair> formValues = new ArrayList<BasicNameValuePair>();
        if (url != null) {
            formValues.add(new BasicNameValuePair("url", url.toString()));
        }
        if (mainArtifact != null) {
            formValues.add(new BasicNameValuePair("mainArtifact", mainArtifact.toString()));
        }
        if (secretName != null) {
            formValues.add(new BasicNameValuePair("secretName", secretName.toString()));
        }
        UrlEncodedFormEntity entity = new UrlEncodedFormEntity(formValues, StandardCharsets.UTF_8);
        ByteArrayOutputStream formOutputStream = new ByteArrayOutputStream();
        try {
            entity.writeTo((OutputStream)formOutputStream);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        localVarRequestBuilder.header("Content-Type", entity.getContentType().getValue()).method("POST", HttpRequest.BodyPublishers.ofInputStream(() -> new ByteArrayInputStream(formOutputStream.toByteArray())));
        if (this.memberVarReadTimeout != null) {
            localVarRequestBuilder.timeout(this.memberVarReadTimeout);
        }
        if (this.memberVarInterceptor != null) {
            this.memberVarInterceptor.accept(localVarRequestBuilder);
        }
        return localVarRequestBuilder;
    }

    public ImportJob getImportJob(String id) throws ApiException {
        ApiResponse<ImportJob> localVarResponse = this.getImportJobWithHttpInfo(id);
        return localVarResponse.getData();
    }

    public ApiResponse<ImportJob> getImportJobWithHttpInfo(String id) throws ApiException {
        HttpRequest.Builder localVarRequestBuilder = this.getImportJobRequestBuilder(id);
        try {
            HttpResponse<InputStream> localVarResponse = this.memberVarHttpClient.send(localVarRequestBuilder.build(), HttpResponse.BodyHandlers.ofInputStream());
            if (this.memberVarResponseInterceptor != null) {
                this.memberVarResponseInterceptor.accept(localVarResponse);
            }
            if (localVarResponse.statusCode() / 100 != 2) {
                throw this.getApiException("getImportJob", localVarResponse);
            }
            return new ApiResponse<Object>(localVarResponse.statusCode(), localVarResponse.headers().map(), (localVarResponse.body() == null ? null : (ImportJob)this.memberVarObjectMapper.readValue(localVarResponse.body(), (TypeReference)new TypeReference<ImportJob>(){})));
        }
        catch (IOException e) {
            throw new ApiException(e);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new ApiException(e);
        }
    }

    private HttpRequest.Builder getImportJobRequestBuilder(String id) throws ApiException {
        if (id == null) {
            throw new ApiException(400, "Missing the required parameter 'id' when calling getImportJob");
        }
        HttpRequest.Builder localVarRequestBuilder = HttpRequest.newBuilder();
        String localVarPath = "/jobs/{id}".replace("{id}", ApiClient.urlEncode(id.toString()));
        localVarRequestBuilder.uri(URI.create(this.memberVarBaseUri + localVarPath));
        localVarRequestBuilder.header("Accept", "application/json");
        localVarRequestBuilder.method("GET", HttpRequest.BodyPublishers.noBody());
        if (this.memberVarReadTimeout != null) {
            localVarRequestBuilder.timeout(this.memberVarReadTimeout);
        }
        if (this.memberVarInterceptor != null) {
            this.memberVarInterceptor.accept(localVarRequestBuilder);
        }
        return localVarRequestBuilder;
    }

    public Counter getImportJobCounter() throws ApiException {
        ApiResponse<Counter> localVarResponse = this.getImportJobCounterWithHttpInfo();
        return localVarResponse.getData();
    }

    public ApiResponse<Counter> getImportJobCounterWithHttpInfo() throws ApiException {
        HttpRequest.Builder localVarRequestBuilder = this.getImportJobCounterRequestBuilder();
        try {
            HttpResponse<InputStream> localVarResponse = this.memberVarHttpClient.send(localVarRequestBuilder.build(), HttpResponse.BodyHandlers.ofInputStream());
            if (this.memberVarResponseInterceptor != null) {
                this.memberVarResponseInterceptor.accept(localVarResponse);
            }
            if (localVarResponse.statusCode() / 100 != 2) {
                throw this.getApiException("getImportJobCounter", localVarResponse);
            }
            return new ApiResponse<Object>(localVarResponse.statusCode(), localVarResponse.headers().map(), (localVarResponse.body() == null ? null : (Counter)this.memberVarObjectMapper.readValue(localVarResponse.body(), (TypeReference)new TypeReference<Counter>(){})));
        }
        catch (IOException e) {
            throw new ApiException(e);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new ApiException(e);
        }
    }

    private HttpRequest.Builder getImportJobCounterRequestBuilder() throws ApiException {
        HttpRequest.Builder localVarRequestBuilder = HttpRequest.newBuilder();
        String localVarPath = "/jobs/count";
        localVarRequestBuilder.uri(URI.create(this.memberVarBaseUri + localVarPath));
        localVarRequestBuilder.header("Accept", "application/json");
        localVarRequestBuilder.method("GET", HttpRequest.BodyPublishers.noBody());
        if (this.memberVarReadTimeout != null) {
            localVarRequestBuilder.timeout(this.memberVarReadTimeout);
        }
        if (this.memberVarInterceptor != null) {
            this.memberVarInterceptor.accept(localVarRequestBuilder);
        }
        return localVarRequestBuilder;
    }

    public List<ImportJob> getImportJobs(Integer page, Integer size, String name) throws ApiException {
        ApiResponse<List<ImportJob>> localVarResponse = this.getImportJobsWithHttpInfo(page, size, name);
        return localVarResponse.getData();
    }

    public ApiResponse<List<ImportJob>> getImportJobsWithHttpInfo(Integer page, Integer size, String name) throws ApiException {
        HttpRequest.Builder localVarRequestBuilder = this.getImportJobsRequestBuilder(page, size, name);
        try {
            HttpResponse<InputStream> localVarResponse = this.memberVarHttpClient.send(localVarRequestBuilder.build(), HttpResponse.BodyHandlers.ofInputStream());
            if (this.memberVarResponseInterceptor != null) {
                this.memberVarResponseInterceptor.accept(localVarResponse);
            }
            if (localVarResponse.statusCode() / 100 != 2) {
                throw this.getApiException("getImportJobs", localVarResponse);
            }
            return new ApiResponse<Object>(localVarResponse.statusCode(), localVarResponse.headers().map(), (localVarResponse.body() == null ? null : (List)this.memberVarObjectMapper.readValue(localVarResponse.body(), (TypeReference)new TypeReference<List<ImportJob>>(){})));
        }
        catch (IOException e) {
            throw new ApiException(e);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new ApiException(e);
        }
    }

    private HttpRequest.Builder getImportJobsRequestBuilder(Integer page, Integer size, String name) throws ApiException {
        HttpRequest.Builder localVarRequestBuilder = HttpRequest.newBuilder();
        String localVarPath = "/jobs";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        String localVarQueryParameterBaseName = "page";
        localVarQueryParams.addAll(ApiClient.parameterToPairs("page", page));
        localVarQueryParameterBaseName = "size";
        localVarQueryParams.addAll(ApiClient.parameterToPairs("size", size));
        localVarQueryParameterBaseName = "name";
        localVarQueryParams.addAll(ApiClient.parameterToPairs("name", name));
        if (!localVarQueryParams.isEmpty() || localVarQueryStringJoiner.length() != 0) {
            StringJoiner queryJoiner = new StringJoiner("&");
            localVarQueryParams.forEach(p -> queryJoiner.add(p.getName() + "=" + p.getValue()));
            if (localVarQueryStringJoiner.length() != 0) {
                queryJoiner.add(localVarQueryStringJoiner.toString());
            }
            localVarRequestBuilder.uri(URI.create(this.memberVarBaseUri + localVarPath + "?" + queryJoiner.toString()));
        } else {
            localVarRequestBuilder.uri(URI.create(this.memberVarBaseUri + localVarPath));
        }
        localVarRequestBuilder.header("Accept", "application/json");
        localVarRequestBuilder.method("GET", HttpRequest.BodyPublishers.noBody());
        if (this.memberVarReadTimeout != null) {
            localVarRequestBuilder.timeout(this.memberVarReadTimeout);
        }
        if (this.memberVarInterceptor != null) {
            this.memberVarInterceptor.accept(localVarRequestBuilder);
        }
        return localVarRequestBuilder;
    }

    public ImportJob startImportJob(String id) throws ApiException {
        ApiResponse<ImportJob> localVarResponse = this.startImportJobWithHttpInfo(id);
        return localVarResponse.getData();
    }

    public ApiResponse<ImportJob> startImportJobWithHttpInfo(String id) throws ApiException {
        HttpRequest.Builder localVarRequestBuilder = this.startImportJobRequestBuilder(id);
        try {
            HttpResponse<InputStream> localVarResponse = this.memberVarHttpClient.send(localVarRequestBuilder.build(), HttpResponse.BodyHandlers.ofInputStream());
            if (this.memberVarResponseInterceptor != null) {
                this.memberVarResponseInterceptor.accept(localVarResponse);
            }
            if (localVarResponse.statusCode() / 100 != 2) {
                throw this.getApiException("startImportJob", localVarResponse);
            }
            return new ApiResponse<Object>(localVarResponse.statusCode(), localVarResponse.headers().map(), (localVarResponse.body() == null ? null : (ImportJob)this.memberVarObjectMapper.readValue(localVarResponse.body(), (TypeReference)new TypeReference<ImportJob>(){})));
        }
        catch (IOException e) {
            throw new ApiException(e);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new ApiException(e);
        }
    }

    private HttpRequest.Builder startImportJobRequestBuilder(String id) throws ApiException {
        if (id == null) {
            throw new ApiException(400, "Missing the required parameter 'id' when calling startImportJob");
        }
        HttpRequest.Builder localVarRequestBuilder = HttpRequest.newBuilder();
        String localVarPath = "/jobs/{id}/start".replace("{id}", ApiClient.urlEncode(id.toString()));
        localVarRequestBuilder.uri(URI.create(this.memberVarBaseUri + localVarPath));
        localVarRequestBuilder.header("Accept", "application/json");
        localVarRequestBuilder.method("PUT", HttpRequest.BodyPublishers.noBody());
        if (this.memberVarReadTimeout != null) {
            localVarRequestBuilder.timeout(this.memberVarReadTimeout);
        }
        if (this.memberVarInterceptor != null) {
            this.memberVarInterceptor.accept(localVarRequestBuilder);
        }
        return localVarRequestBuilder;
    }

    public ImportJob stopImportJob(String id) throws ApiException {
        ApiResponse<ImportJob> localVarResponse = this.stopImportJobWithHttpInfo(id);
        return localVarResponse.getData();
    }

    public ApiResponse<ImportJob> stopImportJobWithHttpInfo(String id) throws ApiException {
        HttpRequest.Builder localVarRequestBuilder = this.stopImportJobRequestBuilder(id);
        try {
            HttpResponse<InputStream> localVarResponse = this.memberVarHttpClient.send(localVarRequestBuilder.build(), HttpResponse.BodyHandlers.ofInputStream());
            if (this.memberVarResponseInterceptor != null) {
                this.memberVarResponseInterceptor.accept(localVarResponse);
            }
            if (localVarResponse.statusCode() / 100 != 2) {
                throw this.getApiException("stopImportJob", localVarResponse);
            }
            return new ApiResponse<Object>(localVarResponse.statusCode(), localVarResponse.headers().map(), (localVarResponse.body() == null ? null : (ImportJob)this.memberVarObjectMapper.readValue(localVarResponse.body(), (TypeReference)new TypeReference<ImportJob>(){})));
        }
        catch (IOException e) {
            throw new ApiException(e);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new ApiException(e);
        }
    }

    private HttpRequest.Builder stopImportJobRequestBuilder(String id) throws ApiException {
        if (id == null) {
            throw new ApiException(400, "Missing the required parameter 'id' when calling stopImportJob");
        }
        HttpRequest.Builder localVarRequestBuilder = HttpRequest.newBuilder();
        String localVarPath = "/jobs/{id}/stop".replace("{id}", ApiClient.urlEncode(id.toString()));
        localVarRequestBuilder.uri(URI.create(this.memberVarBaseUri + localVarPath));
        localVarRequestBuilder.header("Accept", "application/json");
        localVarRequestBuilder.method("PUT", HttpRequest.BodyPublishers.noBody());
        if (this.memberVarReadTimeout != null) {
            localVarRequestBuilder.timeout(this.memberVarReadTimeout);
        }
        if (this.memberVarInterceptor != null) {
            this.memberVarInterceptor.accept(localVarRequestBuilder);
        }
        return localVarRequestBuilder;
    }

    public ImportJob updateImportJob(String id, ImportJob importJob) throws ApiException {
        ApiResponse<ImportJob> localVarResponse = this.updateImportJobWithHttpInfo(id, importJob);
        return localVarResponse.getData();
    }

    public ApiResponse<ImportJob> updateImportJobWithHttpInfo(String id, ImportJob importJob) throws ApiException {
        HttpRequest.Builder localVarRequestBuilder = this.updateImportJobRequestBuilder(id, importJob);
        try {
            HttpResponse<InputStream> localVarResponse = this.memberVarHttpClient.send(localVarRequestBuilder.build(), HttpResponse.BodyHandlers.ofInputStream());
            if (this.memberVarResponseInterceptor != null) {
                this.memberVarResponseInterceptor.accept(localVarResponse);
            }
            if (localVarResponse.statusCode() / 100 != 2) {
                throw this.getApiException("updateImportJob", localVarResponse);
            }
            return new ApiResponse<Object>(localVarResponse.statusCode(), localVarResponse.headers().map(), (localVarResponse.body() == null ? null : (ImportJob)this.memberVarObjectMapper.readValue(localVarResponse.body(), (TypeReference)new TypeReference<ImportJob>(){})));
        }
        catch (IOException e) {
            throw new ApiException(e);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new ApiException(e);
        }
    }

    private HttpRequest.Builder updateImportJobRequestBuilder(String id, ImportJob importJob) throws ApiException {
        if (id == null) {
            throw new ApiException(400, "Missing the required parameter 'id' when calling updateImportJob");
        }
        if (importJob == null) {
            throw new ApiException(400, "Missing the required parameter 'importJob' when calling updateImportJob");
        }
        HttpRequest.Builder localVarRequestBuilder = HttpRequest.newBuilder();
        String localVarPath = "/jobs/{id}".replace("{id}", ApiClient.urlEncode(id.toString()));
        localVarRequestBuilder.uri(URI.create(this.memberVarBaseUri + localVarPath));
        localVarRequestBuilder.header("Content-Type", "application/json");
        localVarRequestBuilder.header("Accept", "application/json");
        try {
            byte[] localVarPostBody = this.memberVarObjectMapper.writeValueAsBytes((Object)importJob);
            localVarRequestBuilder.method("POST", HttpRequest.BodyPublishers.ofByteArray(localVarPostBody));
        }
        catch (IOException e) {
            throw new ApiException(e);
        }
        if (this.memberVarReadTimeout != null) {
            localVarRequestBuilder.timeout(this.memberVarReadTimeout);
        }
        if (this.memberVarInterceptor != null) {
            this.memberVarInterceptor.accept(localVarRequestBuilder);
        }
        return localVarRequestBuilder;
    }

    public String uploadArtifact(Boolean mainArtifact, File _file) throws ApiException {
        ApiResponse<String> localVarResponse = this.uploadArtifactWithHttpInfo(mainArtifact, _file);
        return localVarResponse.getData();
    }

    public ApiResponse<String> uploadArtifactWithHttpInfo(Boolean mainArtifact, File _file) throws ApiException {
        HttpRequest.Builder localVarRequestBuilder = this.uploadArtifactRequestBuilder(mainArtifact, _file);
        try {
            HttpResponse<InputStream> localVarResponse = this.memberVarHttpClient.send(localVarRequestBuilder.build(), HttpResponse.BodyHandlers.ofInputStream());
            if (this.memberVarResponseInterceptor != null) {
                this.memberVarResponseInterceptor.accept(localVarResponse);
            }
            if (localVarResponse.statusCode() / 100 != 2) {
                throw this.getApiException("uploadArtifact", localVarResponse);
            }
            if (localVarResponse.headers().map().containsKey("Content-Type") && "text/plain".equalsIgnoreCase(localVarResponse.headers().map().get("Content-Type").get(0).split(";")[0].trim())) {
                Scanner s = new Scanner(localVarResponse.body()).useDelimiter("\\A");
                String responseBodyText = s.hasNext() ? s.next() : "";
                return new ApiResponse<String>(localVarResponse.statusCode(), localVarResponse.headers().map(), responseBodyText);
            }
            throw new RuntimeException("Error! The response Content-Type is supposed to be `text/plain` but it's not: " + localVarResponse);
        }
        catch (IOException e) {
            throw new ApiException(e);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new ApiException(e);
        }
    }

    private HttpRequest.Builder uploadArtifactRequestBuilder(Boolean mainArtifact, File _file) throws ApiException {
        HttpRequest.BodyPublisher formDataPublisher;
        if (mainArtifact == null) {
            throw new ApiException(400, "Missing the required parameter 'mainArtifact' when calling uploadArtifact");
        }
        if (_file == null) {
            throw new ApiException(400, "Missing the required parameter '_file' when calling uploadArtifact");
        }
        HttpRequest.Builder localVarRequestBuilder = HttpRequest.newBuilder();
        String localVarPath = "/artifact/upload";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        String localVarQueryParameterBaseName = "mainArtifact";
        localVarQueryParams.addAll(ApiClient.parameterToPairs("mainArtifact", mainArtifact));
        if (!localVarQueryParams.isEmpty() || localVarQueryStringJoiner.length() != 0) {
            StringJoiner queryJoiner = new StringJoiner("&");
            localVarQueryParams.forEach(p -> queryJoiner.add(p.getName() + "=" + p.getValue()));
            if (localVarQueryStringJoiner.length() != 0) {
                queryJoiner.add(localVarQueryStringJoiner.toString());
            }
            localVarRequestBuilder.uri(URI.create(this.memberVarBaseUri + localVarPath + "?" + queryJoiner.toString()));
        } else {
            localVarRequestBuilder.uri(URI.create(this.memberVarBaseUri + localVarPath));
        }
        localVarRequestBuilder.header("Accept", "text/plain");
        MultipartEntityBuilder multiPartBuilder = MultipartEntityBuilder.create();
        boolean hasFiles = false;
        multiPartBuilder.addBinaryBody("file", _file);
        hasFiles = true;
        HttpEntity entity = multiPartBuilder.build();
        if (hasFiles) {
            Pipe pipe;
            try {
                pipe = Pipe.open();
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            new Thread(() -> {
                try (OutputStream outputStream = Channels.newOutputStream(pipe.sink());){
                    entity.writeTo(outputStream);
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }).start();
            formDataPublisher = HttpRequest.BodyPublishers.ofInputStream(() -> Channels.newInputStream(pipe.source()));
        } else {
            ByteArrayOutputStream formOutputStream = new ByteArrayOutputStream();
            try {
                entity.writeTo((OutputStream)formOutputStream);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            formDataPublisher = HttpRequest.BodyPublishers.ofInputStream(() -> new ByteArrayInputStream(formOutputStream.toByteArray()));
        }
        localVarRequestBuilder.header("Content-Type", entity.getContentType().getValue()).method("POST", formDataPublisher);
        if (this.memberVarReadTimeout != null) {
            localVarRequestBuilder.timeout(this.memberVarReadTimeout);
        }
        if (this.memberVarInterceptor != null) {
            this.memberVarInterceptor.accept(localVarRequestBuilder);
        }
        return localVarRequestBuilder;
    }
}

