/*
 * Decompiled with CFR 0.152.
 */
package io.github.microcks.client.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;

public enum TestRunnerType {
    HTTP("HTTP"),
    SOAP_HTTP("SOAP_HTTP"),
    SOAP_UI("SOAP_UI"),
    POSTMAN("POSTMAN"),
    OPEN_API_SCHEMA("OPEN_API_SCHEMA"),
    ASYNC_API_SCHEMA("ASYNC_API_SCHEMA"),
    GRPC_PROTOBUF("GRPC_PROTOBUF"),
    GRAPHQL_SCHEMA("GRAPHQL_SCHEMA");

    private String value;

    private TestRunnerType(String value) {
        this.value = value;
    }

    @JsonValue
    public String getValue() {
        return this.value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    @JsonCreator
    public static TestRunnerType fromValue(String value) {
        for (TestRunnerType b : TestRunnerType.values()) {
            if (!b.value.equals(value)) continue;
            return b;
        }
        throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }

    public String toUrlQueryString(String prefix) {
        if (prefix == null) {
            prefix = "";
        }
        return String.format("%s=%s", prefix, this.toString());
    }
}

