/*
 * Microcks API v1.10
 * API offered by Microcks, the Kubernetes native tool for API and microservices mocking and testing (microcks.io)
 *
 * The version of the OpenAPI document: 1.10.0
 * Contact: laurent@microcks.io
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

package io.github.microcks.client.api;

import io.github.microcks.client.ApiClient;
import io.github.microcks.client.ApiException;
import io.github.microcks.client.ApiResponse;
import io.github.microcks.client.Pair;

import io.github.microcks.client.model.Counter;
import java.io.File;
import io.github.microcks.client.model.ImportJob;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;

import org.apache.http.HttpEntity;
import org.apache.http.NameValuePair;
import org.apache.http.entity.mime.MultipartEntityBuilder;
import org.apache.http.message.BasicNameValuePair;
import org.apache.http.client.entity.UrlEncodedFormEntity;

import java.io.InputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.net.http.HttpRequest;
import java.nio.channels.Channels;
import java.nio.channels.Pipe;
import java.net.URI;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.time.Duration;

import java.util.ArrayList;
import java.util.StringJoiner;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;

@jakarta.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2024-08-23T22:01:06.998198+02:00[Europe/Paris]", comments = "Generator version: 7.7.0")
public class JobApi {
  private final HttpClient memberVarHttpClient;
  private final ObjectMapper memberVarObjectMapper;
  private final String memberVarBaseUri;
  private final Consumer<HttpRequest.Builder> memberVarInterceptor;
  private final Duration memberVarReadTimeout;
  private final Consumer<HttpResponse<InputStream>> memberVarResponseInterceptor;
  private final Consumer<HttpResponse<String>> memberVarAsyncResponseInterceptor;

  public JobApi() {
    this(new ApiClient());
  }

  public JobApi(ApiClient apiClient) {
    memberVarHttpClient = apiClient.getHttpClient();
    memberVarObjectMapper = apiClient.getObjectMapper();
    memberVarBaseUri = apiClient.getBaseUri();
    memberVarInterceptor = apiClient.getRequestInterceptor();
    memberVarReadTimeout = apiClient.getReadTimeout();
    memberVarResponseInterceptor = apiClient.getResponseInterceptor();
    memberVarAsyncResponseInterceptor = apiClient.getAsyncResponseInterceptor();
  }

  protected ApiException getApiException(String operationId, HttpResponse<InputStream> response) throws IOException {
    String body = response.body() == null ? null : new String(response.body().readAllBytes());
    String message = formatExceptionMessage(operationId, response.statusCode(), body);
    return new ApiException(response.statusCode(), message, response.headers(), body);
  }

  private String formatExceptionMessage(String operationId, int statusCode, String body) {
    if (body == null || body.isEmpty()) {
      body = "[no body]";
    }
    return operationId + " call failed with: " + statusCode + " - " + body;
  }

  /**
   * Activate an ImportJob
   * Make an ImportJob active, so that it is executed
   * @param id Unique identifier of ImportJob to manage (required)
   * @return ImportJob
   * @throws ApiException if fails to make API call
   */
  public ImportJob activateImportJob(String id) throws ApiException {
    ApiResponse<ImportJob> localVarResponse = activateImportJobWithHttpInfo(id);
    return localVarResponse.getData();
  }

  /**
   * Activate an ImportJob
   * Make an ImportJob active, so that it is executed
   * @param id Unique identifier of ImportJob to manage (required)
   * @return ApiResponse&lt;ImportJob&gt;
   * @throws ApiException if fails to make API call
   */
  public ApiResponse<ImportJob> activateImportJobWithHttpInfo(String id) throws ApiException {
    HttpRequest.Builder localVarRequestBuilder = activateImportJobRequestBuilder(id);
    try {
      HttpResponse<InputStream> localVarResponse = memberVarHttpClient.send(
          localVarRequestBuilder.build(),
          HttpResponse.BodyHandlers.ofInputStream());
      if (memberVarResponseInterceptor != null) {
        memberVarResponseInterceptor.accept(localVarResponse);
      }
      try {
        if (localVarResponse.statusCode()/ 100 != 2) {
          throw getApiException("activateImportJob", localVarResponse);
        }
        return new ApiResponse<ImportJob>(
          localVarResponse.statusCode(),
          localVarResponse.headers().map(),
          localVarResponse.body() == null ? null : memberVarObjectMapper.readValue(localVarResponse.body(), new TypeReference<ImportJob>() {}) // closes the InputStream
        );
      } finally {
      }
    } catch (IOException e) {
      throw new ApiException(e);
    }
    catch (InterruptedException e) {
      Thread.currentThread().interrupt();
      throw new ApiException(e);
    }
  }

  private HttpRequest.Builder activateImportJobRequestBuilder(String id) throws ApiException {
    // verify the required parameter 'id' is set
    if (id == null) {
      throw new ApiException(400, "Missing the required parameter 'id' when calling activateImportJob");
    }

    HttpRequest.Builder localVarRequestBuilder = HttpRequest.newBuilder();

    String localVarPath = "/jobs/{id}/activate"
        .replace("{id}", ApiClient.urlEncode(id.toString()));

    localVarRequestBuilder.uri(URI.create(memberVarBaseUri + localVarPath));

    localVarRequestBuilder.header("Accept", "application/json");

    localVarRequestBuilder.method("PUT", HttpRequest.BodyPublishers.noBody());
    if (memberVarReadTimeout != null) {
      localVarRequestBuilder.timeout(memberVarReadTimeout);
    }
    if (memberVarInterceptor != null) {
      memberVarInterceptor.accept(localVarRequestBuilder);
    }
    return localVarRequestBuilder;
  }

  /**
   * Create ImportJob
   * Create a new ImportJob
   * @param importJob  (required)
   * @return ImportJob
   * @throws ApiException if fails to make API call
   */
  public ImportJob createImportJob(ImportJob importJob) throws ApiException {
    ApiResponse<ImportJob> localVarResponse = createImportJobWithHttpInfo(importJob);
    return localVarResponse.getData();
  }

  /**
   * Create ImportJob
   * Create a new ImportJob
   * @param importJob  (required)
   * @return ApiResponse&lt;ImportJob&gt;
   * @throws ApiException if fails to make API call
   */
  public ApiResponse<ImportJob> createImportJobWithHttpInfo(ImportJob importJob) throws ApiException {
    HttpRequest.Builder localVarRequestBuilder = createImportJobRequestBuilder(importJob);
    try {
      HttpResponse<InputStream> localVarResponse = memberVarHttpClient.send(
          localVarRequestBuilder.build(),
          HttpResponse.BodyHandlers.ofInputStream());
      if (memberVarResponseInterceptor != null) {
        memberVarResponseInterceptor.accept(localVarResponse);
      }
      try {
        if (localVarResponse.statusCode()/ 100 != 2) {
          throw getApiException("createImportJob", localVarResponse);
        }
        return new ApiResponse<ImportJob>(
          localVarResponse.statusCode(),
          localVarResponse.headers().map(),
          localVarResponse.body() == null ? null : memberVarObjectMapper.readValue(localVarResponse.body(), new TypeReference<ImportJob>() {}) // closes the InputStream
        );
      } finally {
      }
    } catch (IOException e) {
      throw new ApiException(e);
    }
    catch (InterruptedException e) {
      Thread.currentThread().interrupt();
      throw new ApiException(e);
    }
  }

  private HttpRequest.Builder createImportJobRequestBuilder(ImportJob importJob) throws ApiException {
    // verify the required parameter 'importJob' is set
    if (importJob == null) {
      throw new ApiException(400, "Missing the required parameter 'importJob' when calling createImportJob");
    }

    HttpRequest.Builder localVarRequestBuilder = HttpRequest.newBuilder();

    String localVarPath = "/jobs";

    localVarRequestBuilder.uri(URI.create(memberVarBaseUri + localVarPath));

    localVarRequestBuilder.header("Content-Type", "application/json");
    localVarRequestBuilder.header("Accept", "application/json");

    try {
      byte[] localVarPostBody = memberVarObjectMapper.writeValueAsBytes(importJob);
      localVarRequestBuilder.method("POST", HttpRequest.BodyPublishers.ofByteArray(localVarPostBody));
    } catch (IOException e) {
      throw new ApiException(e);
    }
    if (memberVarReadTimeout != null) {
      localVarRequestBuilder.timeout(memberVarReadTimeout);
    }
    if (memberVarInterceptor != null) {
      memberVarInterceptor.accept(localVarRequestBuilder);
    }
    return localVarRequestBuilder;
  }

  /**
   * Delete ImportJob
   * Delete an ImportJob
   * @param id Unique identifier of ImportJob to manage (required)
   * @throws ApiException if fails to make API call
   */
  public void deleteImportJob(String id) throws ApiException {
    deleteImportJobWithHttpInfo(id);
  }

  /**
   * Delete ImportJob
   * Delete an ImportJob
   * @param id Unique identifier of ImportJob to manage (required)
   * @return ApiResponse&lt;Void&gt;
   * @throws ApiException if fails to make API call
   */
  public ApiResponse<Void> deleteImportJobWithHttpInfo(String id) throws ApiException {
    HttpRequest.Builder localVarRequestBuilder = deleteImportJobRequestBuilder(id);
    try {
      HttpResponse<InputStream> localVarResponse = memberVarHttpClient.send(
          localVarRequestBuilder.build(),
          HttpResponse.BodyHandlers.ofInputStream());
      if (memberVarResponseInterceptor != null) {
        memberVarResponseInterceptor.accept(localVarResponse);
      }
      try {
        if (localVarResponse.statusCode()/ 100 != 2) {
          throw getApiException("deleteImportJob", localVarResponse);
        }
        return new ApiResponse<Void>(
          localVarResponse.statusCode(),
          localVarResponse.headers().map(),
          null
        );
      } finally {
        // Drain the InputStream
        while (localVarResponse.body().read() != -1) {
            // Ignore
        }
        localVarResponse.body().close();
      }
    } catch (IOException e) {
      throw new ApiException(e);
    }
    catch (InterruptedException e) {
      Thread.currentThread().interrupt();
      throw new ApiException(e);
    }
  }

  private HttpRequest.Builder deleteImportJobRequestBuilder(String id) throws ApiException {
    // verify the required parameter 'id' is set
    if (id == null) {
      throw new ApiException(400, "Missing the required parameter 'id' when calling deleteImportJob");
    }

    HttpRequest.Builder localVarRequestBuilder = HttpRequest.newBuilder();

    String localVarPath = "/jobs/{id}"
        .replace("{id}", ApiClient.urlEncode(id.toString()));

    localVarRequestBuilder.uri(URI.create(memberVarBaseUri + localVarPath));

    localVarRequestBuilder.header("Accept", "application/json");

    localVarRequestBuilder.method("DELETE", HttpRequest.BodyPublishers.noBody());
    if (memberVarReadTimeout != null) {
      localVarRequestBuilder.timeout(memberVarReadTimeout);
    }
    if (memberVarInterceptor != null) {
      memberVarInterceptor.accept(localVarRequestBuilder);
    }
    return localVarRequestBuilder;
  }

  /**
   * Download an artifact
   * Ask Microcks to download an artifact and import it
   * @param url The URL of remote artifact to download and import (required)
   * @param mainArtifact Whether this remote artifact should be imported as main/primary or secondary artifact. Default is true. (optional)
   * @param secretName The name of a secret that can be used to authenticated when downloading remote artifact. (optional)
   * @return String
   * @throws ApiException if fails to make API call
   */
  public String downloadArtifact(String url, Boolean mainArtifact, String secretName) throws ApiException {
    ApiResponse<String> localVarResponse = downloadArtifactWithHttpInfo(url, mainArtifact, secretName);
    return localVarResponse.getData();
  }

  /**
   * Download an artifact
   * Ask Microcks to download an artifact and import it
   * @param url The URL of remote artifact to download and import (required)
   * @param mainArtifact Whether this remote artifact should be imported as main/primary or secondary artifact. Default is true. (optional)
   * @param secretName The name of a secret that can be used to authenticated when downloading remote artifact. (optional)
   * @return ApiResponse&lt;String&gt;
   * @throws ApiException if fails to make API call
   */
  public ApiResponse<String> downloadArtifactWithHttpInfo(String url, Boolean mainArtifact, String secretName) throws ApiException {
    HttpRequest.Builder localVarRequestBuilder = downloadArtifactRequestBuilder(url, mainArtifact, secretName);
    try {
      HttpResponse<InputStream> localVarResponse = memberVarHttpClient.send(
          localVarRequestBuilder.build(),
          HttpResponse.BodyHandlers.ofInputStream());
      if (memberVarResponseInterceptor != null) {
        memberVarResponseInterceptor.accept(localVarResponse);
      }
      try {
        if (localVarResponse.statusCode()/ 100 != 2) {
          throw getApiException("downloadArtifact", localVarResponse);
        }
        // for plain text response
        if (localVarResponse.headers().map().containsKey("Content-Type") &&
                "text/plain".equalsIgnoreCase(localVarResponse.headers().map().get("Content-Type").get(0).split(";")[0].trim())) {
          java.util.Scanner s = new java.util.Scanner(localVarResponse.body()).useDelimiter("\\A");
          String responseBodyText = s.hasNext() ? s.next() : "";
          return new ApiResponse<String>(
                  localVarResponse.statusCode(),
                  localVarResponse.headers().map(),
                  responseBodyText
          );
        } else {
            throw new RuntimeException("Error! The response Content-Type is supposed to be `text/plain` but it's not: " + localVarResponse);
        }
      } finally {
      }
    } catch (IOException e) {
      throw new ApiException(e);
    }
    catch (InterruptedException e) {
      Thread.currentThread().interrupt();
      throw new ApiException(e);
    }
  }

  private HttpRequest.Builder downloadArtifactRequestBuilder(String url, Boolean mainArtifact, String secretName) throws ApiException {
    // verify the required parameter 'url' is set
    if (url == null) {
      throw new ApiException(400, "Missing the required parameter 'url' when calling downloadArtifact");
    }

    HttpRequest.Builder localVarRequestBuilder = HttpRequest.newBuilder();

    String localVarPath = "/artifact/download";

    localVarRequestBuilder.uri(URI.create(memberVarBaseUri + localVarPath));

    localVarRequestBuilder.header("Accept", "text/plain");

    List<NameValuePair> formValues = new ArrayList<>();
    if (url != null) {
        formValues.add(new BasicNameValuePair("url", url.toString()));
    }
    if (mainArtifact != null) {
        formValues.add(new BasicNameValuePair("mainArtifact", mainArtifact.toString()));
    }
    if (secretName != null) {
        formValues.add(new BasicNameValuePair("secretName", secretName.toString()));
    }
    HttpEntity entity = new UrlEncodedFormEntity(formValues, java.nio.charset.StandardCharsets.UTF_8);
    ByteArrayOutputStream formOutputStream = new ByteArrayOutputStream();
    try {
        entity.writeTo(formOutputStream);
    } catch (IOException e) {
        throw new RuntimeException(e);
    }
    localVarRequestBuilder
        .header("Content-Type", entity.getContentType().getValue())
        .method("POST", HttpRequest.BodyPublishers
            .ofInputStream(() -> new ByteArrayInputStream(formOutputStream.toByteArray())));
    if (memberVarReadTimeout != null) {
      localVarRequestBuilder.timeout(memberVarReadTimeout);
    }
    if (memberVarInterceptor != null) {
      memberVarInterceptor.accept(localVarRequestBuilder);
    }
    return localVarRequestBuilder;
  }

  /**
   * Get ImportJob
   * Retrieve an ImportJob using its identifier
   * @param id Unique identifier of ImportJob to manage (required)
   * @return ImportJob
   * @throws ApiException if fails to make API call
   */
  public ImportJob getImportJob(String id) throws ApiException {
    ApiResponse<ImportJob> localVarResponse = getImportJobWithHttpInfo(id);
    return localVarResponse.getData();
  }

  /**
   * Get ImportJob
   * Retrieve an ImportJob using its identifier
   * @param id Unique identifier of ImportJob to manage (required)
   * @return ApiResponse&lt;ImportJob&gt;
   * @throws ApiException if fails to make API call
   */
  public ApiResponse<ImportJob> getImportJobWithHttpInfo(String id) throws ApiException {
    HttpRequest.Builder localVarRequestBuilder = getImportJobRequestBuilder(id);
    try {
      HttpResponse<InputStream> localVarResponse = memberVarHttpClient.send(
          localVarRequestBuilder.build(),
          HttpResponse.BodyHandlers.ofInputStream());
      if (memberVarResponseInterceptor != null) {
        memberVarResponseInterceptor.accept(localVarResponse);
      }
      try {
        if (localVarResponse.statusCode()/ 100 != 2) {
          throw getApiException("getImportJob", localVarResponse);
        }
        return new ApiResponse<ImportJob>(
          localVarResponse.statusCode(),
          localVarResponse.headers().map(),
          localVarResponse.body() == null ? null : memberVarObjectMapper.readValue(localVarResponse.body(), new TypeReference<ImportJob>() {}) // closes the InputStream
        );
      } finally {
      }
    } catch (IOException e) {
      throw new ApiException(e);
    }
    catch (InterruptedException e) {
      Thread.currentThread().interrupt();
      throw new ApiException(e);
    }
  }

  private HttpRequest.Builder getImportJobRequestBuilder(String id) throws ApiException {
    // verify the required parameter 'id' is set
    if (id == null) {
      throw new ApiException(400, "Missing the required parameter 'id' when calling getImportJob");
    }

    HttpRequest.Builder localVarRequestBuilder = HttpRequest.newBuilder();

    String localVarPath = "/jobs/{id}"
        .replace("{id}", ApiClient.urlEncode(id.toString()));

    localVarRequestBuilder.uri(URI.create(memberVarBaseUri + localVarPath));

    localVarRequestBuilder.header("Accept", "application/json");

    localVarRequestBuilder.method("GET", HttpRequest.BodyPublishers.noBody());
    if (memberVarReadTimeout != null) {
      localVarRequestBuilder.timeout(memberVarReadTimeout);
    }
    if (memberVarInterceptor != null) {
      memberVarInterceptor.accept(localVarRequestBuilder);
    }
    return localVarRequestBuilder;
  }

  /**
   * Get the ImportJobs counter
   * 
   * @return Counter
   * @throws ApiException if fails to make API call
   */
  public Counter getImportJobCounter() throws ApiException {
    ApiResponse<Counter> localVarResponse = getImportJobCounterWithHttpInfo();
    return localVarResponse.getData();
  }

  /**
   * Get the ImportJobs counter
   * 
   * @return ApiResponse&lt;Counter&gt;
   * @throws ApiException if fails to make API call
   */
  public ApiResponse<Counter> getImportJobCounterWithHttpInfo() throws ApiException {
    HttpRequest.Builder localVarRequestBuilder = getImportJobCounterRequestBuilder();
    try {
      HttpResponse<InputStream> localVarResponse = memberVarHttpClient.send(
          localVarRequestBuilder.build(),
          HttpResponse.BodyHandlers.ofInputStream());
      if (memberVarResponseInterceptor != null) {
        memberVarResponseInterceptor.accept(localVarResponse);
      }
      try {
        if (localVarResponse.statusCode()/ 100 != 2) {
          throw getApiException("getImportJobCounter", localVarResponse);
        }
        return new ApiResponse<Counter>(
          localVarResponse.statusCode(),
          localVarResponse.headers().map(),
          localVarResponse.body() == null ? null : memberVarObjectMapper.readValue(localVarResponse.body(), new TypeReference<Counter>() {}) // closes the InputStream
        );
      } finally {
      }
    } catch (IOException e) {
      throw new ApiException(e);
    }
    catch (InterruptedException e) {
      Thread.currentThread().interrupt();
      throw new ApiException(e);
    }
  }

  private HttpRequest.Builder getImportJobCounterRequestBuilder() throws ApiException {

    HttpRequest.Builder localVarRequestBuilder = HttpRequest.newBuilder();

    String localVarPath = "/jobs/count";

    localVarRequestBuilder.uri(URI.create(memberVarBaseUri + localVarPath));

    localVarRequestBuilder.header("Accept", "application/json");

    localVarRequestBuilder.method("GET", HttpRequest.BodyPublishers.noBody());
    if (memberVarReadTimeout != null) {
      localVarRequestBuilder.timeout(memberVarReadTimeout);
    }
    if (memberVarInterceptor != null) {
      memberVarInterceptor.accept(localVarRequestBuilder);
    }
    return localVarRequestBuilder;
  }

  /**
   * Get ImportJobs
   * Retrieve a list of ImportJobs
   * @param page Page of ImportJobs to retrieve (starts at and defaults to 0) (optional)
   * @param size Size of a page. Maximum number of ImportJobs to include in a response (defaults to 20) (optional)
   * @param name Name like criterion for query (optional)
   * @return List&lt;ImportJob&gt;
   * @throws ApiException if fails to make API call
   */
  public List<ImportJob> getImportJobs(Integer page, Integer size, String name) throws ApiException {
    ApiResponse<List<ImportJob>> localVarResponse = getImportJobsWithHttpInfo(page, size, name);
    return localVarResponse.getData();
  }

  /**
   * Get ImportJobs
   * Retrieve a list of ImportJobs
   * @param page Page of ImportJobs to retrieve (starts at and defaults to 0) (optional)
   * @param size Size of a page. Maximum number of ImportJobs to include in a response (defaults to 20) (optional)
   * @param name Name like criterion for query (optional)
   * @return ApiResponse&lt;List&lt;ImportJob&gt;&gt;
   * @throws ApiException if fails to make API call
   */
  public ApiResponse<List<ImportJob>> getImportJobsWithHttpInfo(Integer page, Integer size, String name) throws ApiException {
    HttpRequest.Builder localVarRequestBuilder = getImportJobsRequestBuilder(page, size, name);
    try {
      HttpResponse<InputStream> localVarResponse = memberVarHttpClient.send(
          localVarRequestBuilder.build(),
          HttpResponse.BodyHandlers.ofInputStream());
      if (memberVarResponseInterceptor != null) {
        memberVarResponseInterceptor.accept(localVarResponse);
      }
      try {
        if (localVarResponse.statusCode()/ 100 != 2) {
          throw getApiException("getImportJobs", localVarResponse);
        }
        return new ApiResponse<List<ImportJob>>(
          localVarResponse.statusCode(),
          localVarResponse.headers().map(),
          localVarResponse.body() == null ? null : memberVarObjectMapper.readValue(localVarResponse.body(), new TypeReference<List<ImportJob>>() {}) // closes the InputStream
        );
      } finally {
      }
    } catch (IOException e) {
      throw new ApiException(e);
    }
    catch (InterruptedException e) {
      Thread.currentThread().interrupt();
      throw new ApiException(e);
    }
  }

  private HttpRequest.Builder getImportJobsRequestBuilder(Integer page, Integer size, String name) throws ApiException {

    HttpRequest.Builder localVarRequestBuilder = HttpRequest.newBuilder();

    String localVarPath = "/jobs";

    List<Pair> localVarQueryParams = new ArrayList<>();
    StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
    String localVarQueryParameterBaseName;
    localVarQueryParameterBaseName = "page";
    localVarQueryParams.addAll(ApiClient.parameterToPairs("page", page));
    localVarQueryParameterBaseName = "size";
    localVarQueryParams.addAll(ApiClient.parameterToPairs("size", size));
    localVarQueryParameterBaseName = "name";
    localVarQueryParams.addAll(ApiClient.parameterToPairs("name", name));

    if (!localVarQueryParams.isEmpty() || localVarQueryStringJoiner.length() != 0) {
      StringJoiner queryJoiner = new StringJoiner("&");
      localVarQueryParams.forEach(p -> queryJoiner.add(p.getName() + '=' + p.getValue()));
      if (localVarQueryStringJoiner.length() != 0) {
        queryJoiner.add(localVarQueryStringJoiner.toString());
      }
      localVarRequestBuilder.uri(URI.create(memberVarBaseUri + localVarPath + '?' + queryJoiner.toString()));
    } else {
      localVarRequestBuilder.uri(URI.create(memberVarBaseUri + localVarPath));
    }

    localVarRequestBuilder.header("Accept", "application/json");

    localVarRequestBuilder.method("GET", HttpRequest.BodyPublishers.noBody());
    if (memberVarReadTimeout != null) {
      localVarRequestBuilder.timeout(memberVarReadTimeout);
    }
    if (memberVarInterceptor != null) {
      memberVarInterceptor.accept(localVarRequestBuilder);
    }
    return localVarRequestBuilder;
  }

  /**
   * Start an ImportJob
   * Starting an ImportJob forces it to immediatly import mock definitions
   * @param id Unique identifier of ImportJob to manage (required)
   * @return ImportJob
   * @throws ApiException if fails to make API call
   */
  public ImportJob startImportJob(String id) throws ApiException {
    ApiResponse<ImportJob> localVarResponse = startImportJobWithHttpInfo(id);
    return localVarResponse.getData();
  }

  /**
   * Start an ImportJob
   * Starting an ImportJob forces it to immediatly import mock definitions
   * @param id Unique identifier of ImportJob to manage (required)
   * @return ApiResponse&lt;ImportJob&gt;
   * @throws ApiException if fails to make API call
   */
  public ApiResponse<ImportJob> startImportJobWithHttpInfo(String id) throws ApiException {
    HttpRequest.Builder localVarRequestBuilder = startImportJobRequestBuilder(id);
    try {
      HttpResponse<InputStream> localVarResponse = memberVarHttpClient.send(
          localVarRequestBuilder.build(),
          HttpResponse.BodyHandlers.ofInputStream());
      if (memberVarResponseInterceptor != null) {
        memberVarResponseInterceptor.accept(localVarResponse);
      }
      try {
        if (localVarResponse.statusCode()/ 100 != 2) {
          throw getApiException("startImportJob", localVarResponse);
        }
        return new ApiResponse<ImportJob>(
          localVarResponse.statusCode(),
          localVarResponse.headers().map(),
          localVarResponse.body() == null ? null : memberVarObjectMapper.readValue(localVarResponse.body(), new TypeReference<ImportJob>() {}) // closes the InputStream
        );
      } finally {
      }
    } catch (IOException e) {
      throw new ApiException(e);
    }
    catch (InterruptedException e) {
      Thread.currentThread().interrupt();
      throw new ApiException(e);
    }
  }

  private HttpRequest.Builder startImportJobRequestBuilder(String id) throws ApiException {
    // verify the required parameter 'id' is set
    if (id == null) {
      throw new ApiException(400, "Missing the required parameter 'id' when calling startImportJob");
    }

    HttpRequest.Builder localVarRequestBuilder = HttpRequest.newBuilder();

    String localVarPath = "/jobs/{id}/start"
        .replace("{id}", ApiClient.urlEncode(id.toString()));

    localVarRequestBuilder.uri(URI.create(memberVarBaseUri + localVarPath));

    localVarRequestBuilder.header("Accept", "application/json");

    localVarRequestBuilder.method("PUT", HttpRequest.BodyPublishers.noBody());
    if (memberVarReadTimeout != null) {
      localVarRequestBuilder.timeout(memberVarReadTimeout);
    }
    if (memberVarInterceptor != null) {
      memberVarInterceptor.accept(localVarRequestBuilder);
    }
    return localVarRequestBuilder;
  }

  /**
   * Stop an ImportJob
   * Stopping an ImportJob desactivate it, so that it won&#39;t execute at next schedule
   * @param id Unique identifier of ImportJob to manage (required)
   * @return ImportJob
   * @throws ApiException if fails to make API call
   */
  public ImportJob stopImportJob(String id) throws ApiException {
    ApiResponse<ImportJob> localVarResponse = stopImportJobWithHttpInfo(id);
    return localVarResponse.getData();
  }

  /**
   * Stop an ImportJob
   * Stopping an ImportJob desactivate it, so that it won&#39;t execute at next schedule
   * @param id Unique identifier of ImportJob to manage (required)
   * @return ApiResponse&lt;ImportJob&gt;
   * @throws ApiException if fails to make API call
   */
  public ApiResponse<ImportJob> stopImportJobWithHttpInfo(String id) throws ApiException {
    HttpRequest.Builder localVarRequestBuilder = stopImportJobRequestBuilder(id);
    try {
      HttpResponse<InputStream> localVarResponse = memberVarHttpClient.send(
          localVarRequestBuilder.build(),
          HttpResponse.BodyHandlers.ofInputStream());
      if (memberVarResponseInterceptor != null) {
        memberVarResponseInterceptor.accept(localVarResponse);
      }
      try {
        if (localVarResponse.statusCode()/ 100 != 2) {
          throw getApiException("stopImportJob", localVarResponse);
        }
        return new ApiResponse<ImportJob>(
          localVarResponse.statusCode(),
          localVarResponse.headers().map(),
          localVarResponse.body() == null ? null : memberVarObjectMapper.readValue(localVarResponse.body(), new TypeReference<ImportJob>() {}) // closes the InputStream
        );
      } finally {
      }
    } catch (IOException e) {
      throw new ApiException(e);
    }
    catch (InterruptedException e) {
      Thread.currentThread().interrupt();
      throw new ApiException(e);
    }
  }

  private HttpRequest.Builder stopImportJobRequestBuilder(String id) throws ApiException {
    // verify the required parameter 'id' is set
    if (id == null) {
      throw new ApiException(400, "Missing the required parameter 'id' when calling stopImportJob");
    }

    HttpRequest.Builder localVarRequestBuilder = HttpRequest.newBuilder();

    String localVarPath = "/jobs/{id}/stop"
        .replace("{id}", ApiClient.urlEncode(id.toString()));

    localVarRequestBuilder.uri(URI.create(memberVarBaseUri + localVarPath));

    localVarRequestBuilder.header("Accept", "application/json");

    localVarRequestBuilder.method("PUT", HttpRequest.BodyPublishers.noBody());
    if (memberVarReadTimeout != null) {
      localVarRequestBuilder.timeout(memberVarReadTimeout);
    }
    if (memberVarInterceptor != null) {
      memberVarInterceptor.accept(localVarRequestBuilder);
    }
    return localVarRequestBuilder;
  }

  /**
   * Update ImportJob
   * Update an ImportJob
   * @param id Unique identifier of ImportJob to manage (required)
   * @param importJob  (required)
   * @return ImportJob
   * @throws ApiException if fails to make API call
   */
  public ImportJob updateImportJob(String id, ImportJob importJob) throws ApiException {
    ApiResponse<ImportJob> localVarResponse = updateImportJobWithHttpInfo(id, importJob);
    return localVarResponse.getData();
  }

  /**
   * Update ImportJob
   * Update an ImportJob
   * @param id Unique identifier of ImportJob to manage (required)
   * @param importJob  (required)
   * @return ApiResponse&lt;ImportJob&gt;
   * @throws ApiException if fails to make API call
   */
  public ApiResponse<ImportJob> updateImportJobWithHttpInfo(String id, ImportJob importJob) throws ApiException {
    HttpRequest.Builder localVarRequestBuilder = updateImportJobRequestBuilder(id, importJob);
    try {
      HttpResponse<InputStream> localVarResponse = memberVarHttpClient.send(
          localVarRequestBuilder.build(),
          HttpResponse.BodyHandlers.ofInputStream());
      if (memberVarResponseInterceptor != null) {
        memberVarResponseInterceptor.accept(localVarResponse);
      }
      try {
        if (localVarResponse.statusCode()/ 100 != 2) {
          throw getApiException("updateImportJob", localVarResponse);
        }
        return new ApiResponse<ImportJob>(
          localVarResponse.statusCode(),
          localVarResponse.headers().map(),
          localVarResponse.body() == null ? null : memberVarObjectMapper.readValue(localVarResponse.body(), new TypeReference<ImportJob>() {}) // closes the InputStream
        );
      } finally {
      }
    } catch (IOException e) {
      throw new ApiException(e);
    }
    catch (InterruptedException e) {
      Thread.currentThread().interrupt();
      throw new ApiException(e);
    }
  }

  private HttpRequest.Builder updateImportJobRequestBuilder(String id, ImportJob importJob) throws ApiException {
    // verify the required parameter 'id' is set
    if (id == null) {
      throw new ApiException(400, "Missing the required parameter 'id' when calling updateImportJob");
    }
    // verify the required parameter 'importJob' is set
    if (importJob == null) {
      throw new ApiException(400, "Missing the required parameter 'importJob' when calling updateImportJob");
    }

    HttpRequest.Builder localVarRequestBuilder = HttpRequest.newBuilder();

    String localVarPath = "/jobs/{id}"
        .replace("{id}", ApiClient.urlEncode(id.toString()));

    localVarRequestBuilder.uri(URI.create(memberVarBaseUri + localVarPath));

    localVarRequestBuilder.header("Content-Type", "application/json");
    localVarRequestBuilder.header("Accept", "application/json");

    try {
      byte[] localVarPostBody = memberVarObjectMapper.writeValueAsBytes(importJob);
      localVarRequestBuilder.method("POST", HttpRequest.BodyPublishers.ofByteArray(localVarPostBody));
    } catch (IOException e) {
      throw new ApiException(e);
    }
    if (memberVarReadTimeout != null) {
      localVarRequestBuilder.timeout(memberVarReadTimeout);
    }
    if (memberVarInterceptor != null) {
      memberVarInterceptor.accept(localVarRequestBuilder);
    }
    return localVarRequestBuilder;
  }

  /**
   * Upload an artifact
   * Uploads an artifact to be imported by Microcks.
   * @param mainArtifact Flag telling if this should be considered as primary or secondary artifact. Default to &#39;true&#39; (required)
   * @param _file The artifact to upload (required)
   * @return String
   * @throws ApiException if fails to make API call
   */
  public String uploadArtifact(Boolean mainArtifact, File _file) throws ApiException {
    ApiResponse<String> localVarResponse = uploadArtifactWithHttpInfo(mainArtifact, _file);
    return localVarResponse.getData();
  }

  /**
   * Upload an artifact
   * Uploads an artifact to be imported by Microcks.
   * @param mainArtifact Flag telling if this should be considered as primary or secondary artifact. Default to &#39;true&#39; (required)
   * @param _file The artifact to upload (required)
   * @return ApiResponse&lt;String&gt;
   * @throws ApiException if fails to make API call
   */
  public ApiResponse<String> uploadArtifactWithHttpInfo(Boolean mainArtifact, File _file) throws ApiException {
    HttpRequest.Builder localVarRequestBuilder = uploadArtifactRequestBuilder(mainArtifact, _file);
    try {
      HttpResponse<InputStream> localVarResponse = memberVarHttpClient.send(
          localVarRequestBuilder.build(),
          HttpResponse.BodyHandlers.ofInputStream());
      if (memberVarResponseInterceptor != null) {
        memberVarResponseInterceptor.accept(localVarResponse);
      }
      try {
        if (localVarResponse.statusCode()/ 100 != 2) {
          throw getApiException("uploadArtifact", localVarResponse);
        }
        // for plain text response
        if (localVarResponse.headers().map().containsKey("Content-Type") &&
                "text/plain".equalsIgnoreCase(localVarResponse.headers().map().get("Content-Type").get(0).split(";")[0].trim())) {
          java.util.Scanner s = new java.util.Scanner(localVarResponse.body()).useDelimiter("\\A");
          String responseBodyText = s.hasNext() ? s.next() : "";
          return new ApiResponse<String>(
                  localVarResponse.statusCode(),
                  localVarResponse.headers().map(),
                  responseBodyText
          );
        } else {
            throw new RuntimeException("Error! The response Content-Type is supposed to be `text/plain` but it's not: " + localVarResponse);
        }
      } finally {
      }
    } catch (IOException e) {
      throw new ApiException(e);
    }
    catch (InterruptedException e) {
      Thread.currentThread().interrupt();
      throw new ApiException(e);
    }
  }

  private HttpRequest.Builder uploadArtifactRequestBuilder(Boolean mainArtifact, File _file) throws ApiException {
    // verify the required parameter 'mainArtifact' is set
    if (mainArtifact == null) {
      throw new ApiException(400, "Missing the required parameter 'mainArtifact' when calling uploadArtifact");
    }
    // verify the required parameter '_file' is set
    if (_file == null) {
      throw new ApiException(400, "Missing the required parameter '_file' when calling uploadArtifact");
    }

    HttpRequest.Builder localVarRequestBuilder = HttpRequest.newBuilder();

    String localVarPath = "/artifact/upload";

    List<Pair> localVarQueryParams = new ArrayList<>();
    StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
    String localVarQueryParameterBaseName;
    localVarQueryParameterBaseName = "mainArtifact";
    localVarQueryParams.addAll(ApiClient.parameterToPairs("mainArtifact", mainArtifact));

    if (!localVarQueryParams.isEmpty() || localVarQueryStringJoiner.length() != 0) {
      StringJoiner queryJoiner = new StringJoiner("&");
      localVarQueryParams.forEach(p -> queryJoiner.add(p.getName() + '=' + p.getValue()));
      if (localVarQueryStringJoiner.length() != 0) {
        queryJoiner.add(localVarQueryStringJoiner.toString());
      }
      localVarRequestBuilder.uri(URI.create(memberVarBaseUri + localVarPath + '?' + queryJoiner.toString()));
    } else {
      localVarRequestBuilder.uri(URI.create(memberVarBaseUri + localVarPath));
    }

    localVarRequestBuilder.header("Accept", "text/plain");

    MultipartEntityBuilder multiPartBuilder = MultipartEntityBuilder.create();
    boolean hasFiles = false;
    multiPartBuilder.addBinaryBody("file", _file);
    hasFiles = true;
    HttpEntity entity = multiPartBuilder.build();
    HttpRequest.BodyPublisher formDataPublisher;
    if (hasFiles) {
        Pipe pipe;
        try {
            pipe = Pipe.open();
        } catch (IOException e) {
            throw new RuntimeException(e);
        }
        new Thread(() -> {
            try (OutputStream outputStream = Channels.newOutputStream(pipe.sink())) {
                entity.writeTo(outputStream);
            } catch (IOException e) {
                e.printStackTrace();
            }
        }).start();
        formDataPublisher = HttpRequest.BodyPublishers.ofInputStream(() -> Channels.newInputStream(pipe.source()));
    } else {
        ByteArrayOutputStream formOutputStream = new ByteArrayOutputStream();
        try {
            entity.writeTo(formOutputStream);
        } catch (IOException e) {
            throw new RuntimeException(e);
        }
        formDataPublisher = HttpRequest.BodyPublishers
            .ofInputStream(() -> new ByteArrayInputStream(formOutputStream.toByteArray()));
    }
    localVarRequestBuilder
        .header("Content-Type", entity.getContentType().getValue())
        .method("POST", formDataPublisher);
    if (memberVarReadTimeout != null) {
      localVarRequestBuilder.timeout(memberVarReadTimeout);
    }
    if (memberVarInterceptor != null) {
      memberVarInterceptor.accept(localVarRequestBuilder);
    }
    return localVarRequestBuilder;
  }

}
