/*
 * Microcks API v1.10
 * API offered by Microcks, the Kubernetes native tool for API and microservices mocking and testing (microcks.io)
 *
 * The version of the OpenAPI document: 1.10.0
 * Contact: laurent@microcks.io
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

package io.github.microcks.client.api;

import io.github.microcks.client.ApiClient;
import io.github.microcks.client.ApiException;
import io.github.microcks.client.ApiResponse;
import io.github.microcks.client.Pair;

import io.github.microcks.client.model.Counter;
import io.github.microcks.client.model.RequestResponsePair;
import io.github.microcks.client.model.TestCaseResult;
import io.github.microcks.client.model.TestCaseReturnDTO;
import io.github.microcks.client.model.TestRequest;
import io.github.microcks.client.model.TestResult;
import io.github.microcks.client.model.UnidirectionalEvent;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;

import org.apache.http.HttpEntity;
import org.apache.http.NameValuePair;
import org.apache.http.entity.mime.MultipartEntityBuilder;
import org.apache.http.message.BasicNameValuePair;
import org.apache.http.client.entity.UrlEncodedFormEntity;

import java.io.InputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.net.http.HttpRequest;
import java.nio.channels.Channels;
import java.nio.channels.Pipe;
import java.net.URI;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.time.Duration;

import java.util.ArrayList;
import java.util.StringJoiner;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;

@jakarta.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2024-08-23T22:01:06.998198+02:00[Europe/Paris]", comments = "Generator version: 7.7.0")
public class TestApi {
  private final HttpClient memberVarHttpClient;
  private final ObjectMapper memberVarObjectMapper;
  private final String memberVarBaseUri;
  private final Consumer<HttpRequest.Builder> memberVarInterceptor;
  private final Duration memberVarReadTimeout;
  private final Consumer<HttpResponse<InputStream>> memberVarResponseInterceptor;
  private final Consumer<HttpResponse<String>> memberVarAsyncResponseInterceptor;

  public TestApi() {
    this(new ApiClient());
  }

  public TestApi(ApiClient apiClient) {
    memberVarHttpClient = apiClient.getHttpClient();
    memberVarObjectMapper = apiClient.getObjectMapper();
    memberVarBaseUri = apiClient.getBaseUri();
    memberVarInterceptor = apiClient.getRequestInterceptor();
    memberVarReadTimeout = apiClient.getReadTimeout();
    memberVarResponseInterceptor = apiClient.getResponseInterceptor();
    memberVarAsyncResponseInterceptor = apiClient.getAsyncResponseInterceptor();
  }

  protected ApiException getApiException(String operationId, HttpResponse<InputStream> response) throws IOException {
    String body = response.body() == null ? null : new String(response.body().readAllBytes());
    String message = formatExceptionMessage(operationId, response.statusCode(), body);
    return new ApiException(response.statusCode(), message, response.headers(), body);
  }

  private String formatExceptionMessage(String operationId, int statusCode, String body) {
    if (body == null || body.isEmpty()) {
      body = "[no body]";
    }
    return operationId + " call failed with: " + statusCode + " - " + body;
  }

  /**
   * Create a new Test
   * 
   * @param testRequest  (required)
   * @return TestResult
   * @throws ApiException if fails to make API call
   */
  public TestResult createTest(TestRequest testRequest) throws ApiException {
    ApiResponse<TestResult> localVarResponse = createTestWithHttpInfo(testRequest);
    return localVarResponse.getData();
  }

  /**
   * Create a new Test
   * 
   * @param testRequest  (required)
   * @return ApiResponse&lt;TestResult&gt;
   * @throws ApiException if fails to make API call
   */
  public ApiResponse<TestResult> createTestWithHttpInfo(TestRequest testRequest) throws ApiException {
    HttpRequest.Builder localVarRequestBuilder = createTestRequestBuilder(testRequest);
    try {
      HttpResponse<InputStream> localVarResponse = memberVarHttpClient.send(
          localVarRequestBuilder.build(),
          HttpResponse.BodyHandlers.ofInputStream());
      if (memberVarResponseInterceptor != null) {
        memberVarResponseInterceptor.accept(localVarResponse);
      }
      try {
        if (localVarResponse.statusCode()/ 100 != 2) {
          throw getApiException("createTest", localVarResponse);
        }
        return new ApiResponse<TestResult>(
          localVarResponse.statusCode(),
          localVarResponse.headers().map(),
          localVarResponse.body() == null ? null : memberVarObjectMapper.readValue(localVarResponse.body(), new TypeReference<TestResult>() {}) // closes the InputStream
        );
      } finally {
      }
    } catch (IOException e) {
      throw new ApiException(e);
    }
    catch (InterruptedException e) {
      Thread.currentThread().interrupt();
      throw new ApiException(e);
    }
  }

  private HttpRequest.Builder createTestRequestBuilder(TestRequest testRequest) throws ApiException {
    // verify the required parameter 'testRequest' is set
    if (testRequest == null) {
      throw new ApiException(400, "Missing the required parameter 'testRequest' when calling createTest");
    }

    HttpRequest.Builder localVarRequestBuilder = HttpRequest.newBuilder();

    String localVarPath = "/tests";

    localVarRequestBuilder.uri(URI.create(memberVarBaseUri + localVarPath));

    localVarRequestBuilder.header("Content-Type", "application/json");
    localVarRequestBuilder.header("Accept", "application/json");

    try {
      byte[] localVarPostBody = memberVarObjectMapper.writeValueAsBytes(testRequest);
      localVarRequestBuilder.method("POST", HttpRequest.BodyPublishers.ofByteArray(localVarPostBody));
    } catch (IOException e) {
      throw new ApiException(e);
    }
    if (memberVarReadTimeout != null) {
      localVarRequestBuilder.timeout(memberVarReadTimeout);
    }
    if (memberVarInterceptor != null) {
      memberVarInterceptor.accept(localVarRequestBuilder);
    }
    return localVarRequestBuilder;
  }

  /**
   * Get events for TestCase
   * 
   * @param id Unique identifier of TestResult to manage (required)
   * @param testCaseId Unique identifier of TetsCaseResult to manage (required)
   * @return List&lt;UnidirectionalEvent&gt;
   * @throws ApiException if fails to make API call
   */
  public List<UnidirectionalEvent> getEventsByTestCase(String id, String testCaseId) throws ApiException {
    ApiResponse<List<UnidirectionalEvent>> localVarResponse = getEventsByTestCaseWithHttpInfo(id, testCaseId);
    return localVarResponse.getData();
  }

  /**
   * Get events for TestCase
   * 
   * @param id Unique identifier of TestResult to manage (required)
   * @param testCaseId Unique identifier of TetsCaseResult to manage (required)
   * @return ApiResponse&lt;List&lt;UnidirectionalEvent&gt;&gt;
   * @throws ApiException if fails to make API call
   */
  public ApiResponse<List<UnidirectionalEvent>> getEventsByTestCaseWithHttpInfo(String id, String testCaseId) throws ApiException {
    HttpRequest.Builder localVarRequestBuilder = getEventsByTestCaseRequestBuilder(id, testCaseId);
    try {
      HttpResponse<InputStream> localVarResponse = memberVarHttpClient.send(
          localVarRequestBuilder.build(),
          HttpResponse.BodyHandlers.ofInputStream());
      if (memberVarResponseInterceptor != null) {
        memberVarResponseInterceptor.accept(localVarResponse);
      }
      try {
        if (localVarResponse.statusCode()/ 100 != 2) {
          throw getApiException("getEventsByTestCase", localVarResponse);
        }
        return new ApiResponse<List<UnidirectionalEvent>>(
          localVarResponse.statusCode(),
          localVarResponse.headers().map(),
          localVarResponse.body() == null ? null : memberVarObjectMapper.readValue(localVarResponse.body(), new TypeReference<List<UnidirectionalEvent>>() {}) // closes the InputStream
        );
      } finally {
      }
    } catch (IOException e) {
      throw new ApiException(e);
    }
    catch (InterruptedException e) {
      Thread.currentThread().interrupt();
      throw new ApiException(e);
    }
  }

  private HttpRequest.Builder getEventsByTestCaseRequestBuilder(String id, String testCaseId) throws ApiException {
    // verify the required parameter 'id' is set
    if (id == null) {
      throw new ApiException(400, "Missing the required parameter 'id' when calling getEventsByTestCase");
    }
    // verify the required parameter 'testCaseId' is set
    if (testCaseId == null) {
      throw new ApiException(400, "Missing the required parameter 'testCaseId' when calling getEventsByTestCase");
    }

    HttpRequest.Builder localVarRequestBuilder = HttpRequest.newBuilder();

    String localVarPath = "/tests/{id}/events/{testCaseId}"
        .replace("{id}", ApiClient.urlEncode(id.toString()))
        .replace("{testCaseId}", ApiClient.urlEncode(testCaseId.toString()));

    localVarRequestBuilder.uri(URI.create(memberVarBaseUri + localVarPath));

    localVarRequestBuilder.header("Accept", "application/json");

    localVarRequestBuilder.method("GET", HttpRequest.BodyPublishers.noBody());
    if (memberVarReadTimeout != null) {
      localVarRequestBuilder.timeout(memberVarReadTimeout);
    }
    if (memberVarInterceptor != null) {
      memberVarInterceptor.accept(localVarRequestBuilder);
    }
    return localVarRequestBuilder;
  }

  /**
   * Get messages for TestCase
   * 
   * @param id Unique identifier of TestResult to manage (required)
   * @param testCaseId Unique identifier of TetsCaseResult to manage (required)
   * @return List&lt;RequestResponsePair&gt;
   * @throws ApiException if fails to make API call
   */
  public List<RequestResponsePair> getMessagesByTestCase(String id, String testCaseId) throws ApiException {
    ApiResponse<List<RequestResponsePair>> localVarResponse = getMessagesByTestCaseWithHttpInfo(id, testCaseId);
    return localVarResponse.getData();
  }

  /**
   * Get messages for TestCase
   * 
   * @param id Unique identifier of TestResult to manage (required)
   * @param testCaseId Unique identifier of TetsCaseResult to manage (required)
   * @return ApiResponse&lt;List&lt;RequestResponsePair&gt;&gt;
   * @throws ApiException if fails to make API call
   */
  public ApiResponse<List<RequestResponsePair>> getMessagesByTestCaseWithHttpInfo(String id, String testCaseId) throws ApiException {
    HttpRequest.Builder localVarRequestBuilder = getMessagesByTestCaseRequestBuilder(id, testCaseId);
    try {
      HttpResponse<InputStream> localVarResponse = memberVarHttpClient.send(
          localVarRequestBuilder.build(),
          HttpResponse.BodyHandlers.ofInputStream());
      if (memberVarResponseInterceptor != null) {
        memberVarResponseInterceptor.accept(localVarResponse);
      }
      try {
        if (localVarResponse.statusCode()/ 100 != 2) {
          throw getApiException("getMessagesByTestCase", localVarResponse);
        }
        return new ApiResponse<List<RequestResponsePair>>(
          localVarResponse.statusCode(),
          localVarResponse.headers().map(),
          localVarResponse.body() == null ? null : memberVarObjectMapper.readValue(localVarResponse.body(), new TypeReference<List<RequestResponsePair>>() {}) // closes the InputStream
        );
      } finally {
      }
    } catch (IOException e) {
      throw new ApiException(e);
    }
    catch (InterruptedException e) {
      Thread.currentThread().interrupt();
      throw new ApiException(e);
    }
  }

  private HttpRequest.Builder getMessagesByTestCaseRequestBuilder(String id, String testCaseId) throws ApiException {
    // verify the required parameter 'id' is set
    if (id == null) {
      throw new ApiException(400, "Missing the required parameter 'id' when calling getMessagesByTestCase");
    }
    // verify the required parameter 'testCaseId' is set
    if (testCaseId == null) {
      throw new ApiException(400, "Missing the required parameter 'testCaseId' when calling getMessagesByTestCase");
    }

    HttpRequest.Builder localVarRequestBuilder = HttpRequest.newBuilder();

    String localVarPath = "/tests/{id}/messages/{testCaseId}"
        .replace("{id}", ApiClient.urlEncode(id.toString()))
        .replace("{testCaseId}", ApiClient.urlEncode(testCaseId.toString()));

    localVarRequestBuilder.uri(URI.create(memberVarBaseUri + localVarPath));

    localVarRequestBuilder.header("Accept", "application/json");

    localVarRequestBuilder.method("GET", HttpRequest.BodyPublishers.noBody());
    if (memberVarReadTimeout != null) {
      localVarRequestBuilder.timeout(memberVarReadTimeout);
    }
    if (memberVarInterceptor != null) {
      memberVarInterceptor.accept(localVarRequestBuilder);
    }
    return localVarRequestBuilder;
  }

  /**
   * Get TestResult
   * 
   * @param id Unique identifier of TestResult to manage (required)
   * @return TestResult
   * @throws ApiException if fails to make API call
   */
  public TestResult getTestResult(String id) throws ApiException {
    ApiResponse<TestResult> localVarResponse = getTestResultWithHttpInfo(id);
    return localVarResponse.getData();
  }

  /**
   * Get TestResult
   * 
   * @param id Unique identifier of TestResult to manage (required)
   * @return ApiResponse&lt;TestResult&gt;
   * @throws ApiException if fails to make API call
   */
  public ApiResponse<TestResult> getTestResultWithHttpInfo(String id) throws ApiException {
    HttpRequest.Builder localVarRequestBuilder = getTestResultRequestBuilder(id);
    try {
      HttpResponse<InputStream> localVarResponse = memberVarHttpClient.send(
          localVarRequestBuilder.build(),
          HttpResponse.BodyHandlers.ofInputStream());
      if (memberVarResponseInterceptor != null) {
        memberVarResponseInterceptor.accept(localVarResponse);
      }
      try {
        if (localVarResponse.statusCode()/ 100 != 2) {
          throw getApiException("getTestResult", localVarResponse);
        }
        return new ApiResponse<TestResult>(
          localVarResponse.statusCode(),
          localVarResponse.headers().map(),
          localVarResponse.body() == null ? null : memberVarObjectMapper.readValue(localVarResponse.body(), new TypeReference<TestResult>() {}) // closes the InputStream
        );
      } finally {
      }
    } catch (IOException e) {
      throw new ApiException(e);
    }
    catch (InterruptedException e) {
      Thread.currentThread().interrupt();
      throw new ApiException(e);
    }
  }

  private HttpRequest.Builder getTestResultRequestBuilder(String id) throws ApiException {
    // verify the required parameter 'id' is set
    if (id == null) {
      throw new ApiException(400, "Missing the required parameter 'id' when calling getTestResult");
    }

    HttpRequest.Builder localVarRequestBuilder = HttpRequest.newBuilder();

    String localVarPath = "/tests/{id}"
        .replace("{id}", ApiClient.urlEncode(id.toString()));

    localVarRequestBuilder.uri(URI.create(memberVarBaseUri + localVarPath));

    localVarRequestBuilder.header("Accept", "application/json");

    localVarRequestBuilder.method("GET", HttpRequest.BodyPublishers.noBody());
    if (memberVarReadTimeout != null) {
      localVarRequestBuilder.timeout(memberVarReadTimeout);
    }
    if (memberVarInterceptor != null) {
      memberVarInterceptor.accept(localVarRequestBuilder);
    }
    return localVarRequestBuilder;
  }

  /**
   * Get TestResults by Service
   * 
   * @param serviceId Unique identifier of Service to manage TestResults for (required)
   * @return List&lt;TestResult&gt;
   * @throws ApiException if fails to make API call
   */
  public List<TestResult> getTestResultsByService(String serviceId) throws ApiException {
    ApiResponse<List<TestResult>> localVarResponse = getTestResultsByServiceWithHttpInfo(serviceId);
    return localVarResponse.getData();
  }

  /**
   * Get TestResults by Service
   * 
   * @param serviceId Unique identifier of Service to manage TestResults for (required)
   * @return ApiResponse&lt;List&lt;TestResult&gt;&gt;
   * @throws ApiException if fails to make API call
   */
  public ApiResponse<List<TestResult>> getTestResultsByServiceWithHttpInfo(String serviceId) throws ApiException {
    HttpRequest.Builder localVarRequestBuilder = getTestResultsByServiceRequestBuilder(serviceId);
    try {
      HttpResponse<InputStream> localVarResponse = memberVarHttpClient.send(
          localVarRequestBuilder.build(),
          HttpResponse.BodyHandlers.ofInputStream());
      if (memberVarResponseInterceptor != null) {
        memberVarResponseInterceptor.accept(localVarResponse);
      }
      try {
        if (localVarResponse.statusCode()/ 100 != 2) {
          throw getApiException("getTestResultsByService", localVarResponse);
        }
        return new ApiResponse<List<TestResult>>(
          localVarResponse.statusCode(),
          localVarResponse.headers().map(),
          localVarResponse.body() == null ? null : memberVarObjectMapper.readValue(localVarResponse.body(), new TypeReference<List<TestResult>>() {}) // closes the InputStream
        );
      } finally {
      }
    } catch (IOException e) {
      throw new ApiException(e);
    }
    catch (InterruptedException e) {
      Thread.currentThread().interrupt();
      throw new ApiException(e);
    }
  }

  private HttpRequest.Builder getTestResultsByServiceRequestBuilder(String serviceId) throws ApiException {
    // verify the required parameter 'serviceId' is set
    if (serviceId == null) {
      throw new ApiException(400, "Missing the required parameter 'serviceId' when calling getTestResultsByService");
    }

    HttpRequest.Builder localVarRequestBuilder = HttpRequest.newBuilder();

    String localVarPath = "/tests/service/{serviceId}"
        .replace("{serviceId}", ApiClient.urlEncode(serviceId.toString()));

    localVarRequestBuilder.uri(URI.create(memberVarBaseUri + localVarPath));

    localVarRequestBuilder.header("Accept", "application/json");

    localVarRequestBuilder.method("GET", HttpRequest.BodyPublishers.noBody());
    if (memberVarReadTimeout != null) {
      localVarRequestBuilder.timeout(memberVarReadTimeout);
    }
    if (memberVarInterceptor != null) {
      memberVarInterceptor.accept(localVarRequestBuilder);
    }
    return localVarRequestBuilder;
  }

  /**
   * Get the TestResults for Service counter
   * 
   * @param serviceId Unique identifier of Service to manage TestResults for (required)
   * @return Counter
   * @throws ApiException if fails to make API call
   */
  public Counter getTestResultsByServiceCounter(String serviceId) throws ApiException {
    ApiResponse<Counter> localVarResponse = getTestResultsByServiceCounterWithHttpInfo(serviceId);
    return localVarResponse.getData();
  }

  /**
   * Get the TestResults for Service counter
   * 
   * @param serviceId Unique identifier of Service to manage TestResults for (required)
   * @return ApiResponse&lt;Counter&gt;
   * @throws ApiException if fails to make API call
   */
  public ApiResponse<Counter> getTestResultsByServiceCounterWithHttpInfo(String serviceId) throws ApiException {
    HttpRequest.Builder localVarRequestBuilder = getTestResultsByServiceCounterRequestBuilder(serviceId);
    try {
      HttpResponse<InputStream> localVarResponse = memberVarHttpClient.send(
          localVarRequestBuilder.build(),
          HttpResponse.BodyHandlers.ofInputStream());
      if (memberVarResponseInterceptor != null) {
        memberVarResponseInterceptor.accept(localVarResponse);
      }
      try {
        if (localVarResponse.statusCode()/ 100 != 2) {
          throw getApiException("getTestResultsByServiceCounter", localVarResponse);
        }
        return new ApiResponse<Counter>(
          localVarResponse.statusCode(),
          localVarResponse.headers().map(),
          localVarResponse.body() == null ? null : memberVarObjectMapper.readValue(localVarResponse.body(), new TypeReference<Counter>() {}) // closes the InputStream
        );
      } finally {
      }
    } catch (IOException e) {
      throw new ApiException(e);
    }
    catch (InterruptedException e) {
      Thread.currentThread().interrupt();
      throw new ApiException(e);
    }
  }

  private HttpRequest.Builder getTestResultsByServiceCounterRequestBuilder(String serviceId) throws ApiException {
    // verify the required parameter 'serviceId' is set
    if (serviceId == null) {
      throw new ApiException(400, "Missing the required parameter 'serviceId' when calling getTestResultsByServiceCounter");
    }

    HttpRequest.Builder localVarRequestBuilder = HttpRequest.newBuilder();

    String localVarPath = "/tests/service/{serviceId}/count"
        .replace("{serviceId}", ApiClient.urlEncode(serviceId.toString()));

    localVarRequestBuilder.uri(URI.create(memberVarBaseUri + localVarPath));

    localVarRequestBuilder.header("Accept", "application/json");

    localVarRequestBuilder.method("GET", HttpRequest.BodyPublishers.noBody());
    if (memberVarReadTimeout != null) {
      localVarRequestBuilder.timeout(memberVarReadTimeout);
    }
    if (memberVarInterceptor != null) {
      memberVarInterceptor.accept(localVarRequestBuilder);
    }
    return localVarRequestBuilder;
  }

  /**
   * Report and create a new TestCaseResult
   * Report a TestCaseResult (typically used by a Test runner)
   * @param id Unique identifier of TestResult to manage (required)
   * @param testCaseReturnDTO TestCase return wrapper object (required)
   * @return TestCaseResult
   * @throws ApiException if fails to make API call
   */
  public TestCaseResult reportTestCaseResult(String id, TestCaseReturnDTO testCaseReturnDTO) throws ApiException {
    ApiResponse<TestCaseResult> localVarResponse = reportTestCaseResultWithHttpInfo(id, testCaseReturnDTO);
    return localVarResponse.getData();
  }

  /**
   * Report and create a new TestCaseResult
   * Report a TestCaseResult (typically used by a Test runner)
   * @param id Unique identifier of TestResult to manage (required)
   * @param testCaseReturnDTO TestCase return wrapper object (required)
   * @return ApiResponse&lt;TestCaseResult&gt;
   * @throws ApiException if fails to make API call
   */
  public ApiResponse<TestCaseResult> reportTestCaseResultWithHttpInfo(String id, TestCaseReturnDTO testCaseReturnDTO) throws ApiException {
    HttpRequest.Builder localVarRequestBuilder = reportTestCaseResultRequestBuilder(id, testCaseReturnDTO);
    try {
      HttpResponse<InputStream> localVarResponse = memberVarHttpClient.send(
          localVarRequestBuilder.build(),
          HttpResponse.BodyHandlers.ofInputStream());
      if (memberVarResponseInterceptor != null) {
        memberVarResponseInterceptor.accept(localVarResponse);
      }
      try {
        if (localVarResponse.statusCode()/ 100 != 2) {
          throw getApiException("reportTestCaseResult", localVarResponse);
        }
        return new ApiResponse<TestCaseResult>(
          localVarResponse.statusCode(),
          localVarResponse.headers().map(),
          localVarResponse.body() == null ? null : memberVarObjectMapper.readValue(localVarResponse.body(), new TypeReference<TestCaseResult>() {}) // closes the InputStream
        );
      } finally {
      }
    } catch (IOException e) {
      throw new ApiException(e);
    }
    catch (InterruptedException e) {
      Thread.currentThread().interrupt();
      throw new ApiException(e);
    }
  }

  private HttpRequest.Builder reportTestCaseResultRequestBuilder(String id, TestCaseReturnDTO testCaseReturnDTO) throws ApiException {
    // verify the required parameter 'id' is set
    if (id == null) {
      throw new ApiException(400, "Missing the required parameter 'id' when calling reportTestCaseResult");
    }
    // verify the required parameter 'testCaseReturnDTO' is set
    if (testCaseReturnDTO == null) {
      throw new ApiException(400, "Missing the required parameter 'testCaseReturnDTO' when calling reportTestCaseResult");
    }

    HttpRequest.Builder localVarRequestBuilder = HttpRequest.newBuilder();

    String localVarPath = "/tests/{id}/testCaseResult"
        .replace("{id}", ApiClient.urlEncode(id.toString()));

    localVarRequestBuilder.uri(URI.create(memberVarBaseUri + localVarPath));

    localVarRequestBuilder.header("Content-Type", "application/json");
    localVarRequestBuilder.header("Accept", "application/json");

    try {
      byte[] localVarPostBody = memberVarObjectMapper.writeValueAsBytes(testCaseReturnDTO);
      localVarRequestBuilder.method("POST", HttpRequest.BodyPublishers.ofByteArray(localVarPostBody));
    } catch (IOException e) {
      throw new ApiException(e);
    }
    if (memberVarReadTimeout != null) {
      localVarRequestBuilder.timeout(memberVarReadTimeout);
    }
    if (memberVarInterceptor != null) {
      memberVarInterceptor.accept(localVarRequestBuilder);
    }
    return localVarRequestBuilder;
  }

}
