/*
 * Microcks API v1.10
 * API offered by Microcks, the Kubernetes native tool for API and microservices mocking and testing (microcks.io)
 *
 * The version of the OpenAPI document: 1.10.0
 * Contact: laurent@microcks.io
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package io.github.microcks.client.model;

import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.StringJoiner;
import java.util.Objects;
import java.util.Map;
import java.util.HashMap;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;


import io.github.microcks.client.ApiClient;
/**
 * Protocol binding details for asynchronous operations
 */
@JsonPropertyOrder({
  Binding.JSON_PROPERTY_TYPE,
  Binding.JSON_PROPERTY_KEY_TYPE,
  Binding.JSON_PROPERTY_DESTINATION_TYPE,
  Binding.JSON_PROPERTY_DESTINATION_NAME,
  Binding.JSON_PROPERTY_QO_S,
  Binding.JSON_PROPERTY_PERSISTENT,
  Binding.JSON_PROPERTY_METHOD
})
@jakarta.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2024-08-23T22:01:06.998198+02:00[Europe/Paris]", comments = "Generator version: 7.7.0")
public class Binding {
  /**
   * Protocol binding identifier
   */
  public enum TypeEnum {
    KAFKA("KAFKA"),
    
    MQTT("MQTT"),
    
    WS("WS"),
    
    AMQP("AMQP"),
    
    NATS("NATS"),
    
    GOOGLEPUBSUB("GOOGLEPUBSUB");

    private String value;

    TypeEnum(String value) {
      this.value = value;
    }

    @JsonValue
    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    @JsonCreator
    public static TypeEnum fromValue(String value) {
      for (TypeEnum b : TypeEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }
  }

  public static final String JSON_PROPERTY_TYPE = "type";
  private TypeEnum type;

  public static final String JSON_PROPERTY_KEY_TYPE = "keyType";
  private String keyType;

  public static final String JSON_PROPERTY_DESTINATION_TYPE = "destinationType";
  private String destinationType;

  public static final String JSON_PROPERTY_DESTINATION_NAME = "destinationName";
  private String destinationName;

  public static final String JSON_PROPERTY_QO_S = "qoS";
  private String qoS;

  public static final String JSON_PROPERTY_PERSISTENT = "persistent";
  private Boolean persistent;

  public static final String JSON_PROPERTY_METHOD = "method";
  private String method;

  public Binding() { 
  }

  public Binding type(TypeEnum type) {
    this.type = type;
    return this;
  }

  /**
   * Protocol binding identifier
   * @return type
   */
  @jakarta.annotation.Nonnull
  @JsonProperty(JSON_PROPERTY_TYPE)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public TypeEnum getType() {
    return type;
  }


  @JsonProperty(JSON_PROPERTY_TYPE)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setType(TypeEnum type) {
    this.type = type;
  }


  public Binding keyType(String keyType) {
    this.keyType = keyType;
    return this;
  }

  /**
   * Type of key for Kafka messages
   * @return keyType
   */
  @jakarta.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_KEY_TYPE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public String getKeyType() {
    return keyType;
  }


  @JsonProperty(JSON_PROPERTY_KEY_TYPE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setKeyType(String keyType) {
    this.keyType = keyType;
  }


  public Binding destinationType(String destinationType) {
    this.destinationType = destinationType;
    return this;
  }

  /**
   * Type of destination for asynchronous messages of this operation
   * @return destinationType
   */
  @jakarta.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_DESTINATION_TYPE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public String getDestinationType() {
    return destinationType;
  }


  @JsonProperty(JSON_PROPERTY_DESTINATION_TYPE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setDestinationType(String destinationType) {
    this.destinationType = destinationType;
  }


  public Binding destinationName(String destinationName) {
    this.destinationName = destinationName;
    return this;
  }

  /**
   * Name of destination for asynchronous messages of this operation
   * @return destinationName
   */
  @jakarta.annotation.Nonnull
  @JsonProperty(JSON_PROPERTY_DESTINATION_NAME)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public String getDestinationName() {
    return destinationName;
  }


  @JsonProperty(JSON_PROPERTY_DESTINATION_NAME)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setDestinationName(String destinationName) {
    this.destinationName = destinationName;
  }


  public Binding qoS(String qoS) {
    this.qoS = qoS;
    return this;
  }

  /**
   * Quality of Service attribute for MQTT binding
   * @return qoS
   */
  @jakarta.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_QO_S)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public String getQoS() {
    return qoS;
  }


  @JsonProperty(JSON_PROPERTY_QO_S)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setQoS(String qoS) {
    this.qoS = qoS;
  }


  public Binding persistent(Boolean persistent) {
    this.persistent = persistent;
    return this;
  }

  /**
   * Persistent attribute for MQTT binding
   * @return persistent
   */
  @jakarta.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_PERSISTENT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public Boolean getPersistent() {
    return persistent;
  }


  @JsonProperty(JSON_PROPERTY_PERSISTENT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setPersistent(Boolean persistent) {
    this.persistent = persistent;
  }


  public Binding method(String method) {
    this.method = method;
    return this;
  }

  /**
   * HTTP method for WebSocket binding
   * @return method
   */
  @jakarta.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_METHOD)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public String getMethod() {
    return method;
  }


  @JsonProperty(JSON_PROPERTY_METHOD)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setMethod(String method) {
    this.method = method;
  }


  /**
   * Return true if this Binding object is equal to o.
   */
  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    Binding binding = (Binding) o;
    return Objects.equals(this.type, binding.type) &&
        Objects.equals(this.keyType, binding.keyType) &&
        Objects.equals(this.destinationType, binding.destinationType) &&
        Objects.equals(this.destinationName, binding.destinationName) &&
        Objects.equals(this.qoS, binding.qoS) &&
        Objects.equals(this.persistent, binding.persistent) &&
        Objects.equals(this.method, binding.method);
  }

  @Override
  public int hashCode() {
    return Objects.hash(type, keyType, destinationType, destinationName, qoS, persistent, method);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class Binding {\n");
    sb.append("    type: ").append(toIndentedString(type)).append("\n");
    sb.append("    keyType: ").append(toIndentedString(keyType)).append("\n");
    sb.append("    destinationType: ").append(toIndentedString(destinationType)).append("\n");
    sb.append("    destinationName: ").append(toIndentedString(destinationName)).append("\n");
    sb.append("    qoS: ").append(toIndentedString(qoS)).append("\n");
    sb.append("    persistent: ").append(toIndentedString(persistent)).append("\n");
    sb.append("    method: ").append(toIndentedString(method)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

  /**
   * Convert the instance into URL query string.
   *
   * @return URL query string
   */
  public String toUrlQueryString() {
    return toUrlQueryString(null);
  }

  /**
   * Convert the instance into URL query string.
   *
   * @param prefix prefix of the query string
   * @return URL query string
   */
  public String toUrlQueryString(String prefix) {
    String suffix = "";
    String containerSuffix = "";
    String containerPrefix = "";
    if (prefix == null) {
      // style=form, explode=true, e.g. /pet?name=cat&type=manx
      prefix = "";
    } else {
      // deepObject style e.g. /pet?id[name]=cat&id[type]=manx
      prefix = prefix + "[";
      suffix = "]";
      containerSuffix = "]";
      containerPrefix = "[";
    }

    StringJoiner joiner = new StringJoiner("&");

    // add `type` to the URL query string
    if (getType() != null) {
      joiner.add(String.format("%stype%s=%s", prefix, suffix, URLEncoder.encode(ApiClient.valueToString(getType()), StandardCharsets.UTF_8).replaceAll("\\+", "%20")));
    }

    // add `keyType` to the URL query string
    if (getKeyType() != null) {
      joiner.add(String.format("%skeyType%s=%s", prefix, suffix, URLEncoder.encode(ApiClient.valueToString(getKeyType()), StandardCharsets.UTF_8).replaceAll("\\+", "%20")));
    }

    // add `destinationType` to the URL query string
    if (getDestinationType() != null) {
      joiner.add(String.format("%sdestinationType%s=%s", prefix, suffix, URLEncoder.encode(ApiClient.valueToString(getDestinationType()), StandardCharsets.UTF_8).replaceAll("\\+", "%20")));
    }

    // add `destinationName` to the URL query string
    if (getDestinationName() != null) {
      joiner.add(String.format("%sdestinationName%s=%s", prefix, suffix, URLEncoder.encode(ApiClient.valueToString(getDestinationName()), StandardCharsets.UTF_8).replaceAll("\\+", "%20")));
    }

    // add `qoS` to the URL query string
    if (getQoS() != null) {
      joiner.add(String.format("%sqoS%s=%s", prefix, suffix, URLEncoder.encode(ApiClient.valueToString(getQoS()), StandardCharsets.UTF_8).replaceAll("\\+", "%20")));
    }

    // add `persistent` to the URL query string
    if (getPersistent() != null) {
      joiner.add(String.format("%spersistent%s=%s", prefix, suffix, URLEncoder.encode(ApiClient.valueToString(getPersistent()), StandardCharsets.UTF_8).replaceAll("\\+", "%20")));
    }

    // add `method` to the URL query string
    if (getMethod() != null) {
      joiner.add(String.format("%smethod%s=%s", prefix, suffix, URLEncoder.encode(ApiClient.valueToString(getMethod()), StandardCharsets.UTF_8).replaceAll("\\+", "%20")));
    }

    return joiner.toString();
  }
}

