/*
 * Microcks API v1.10
 * API offered by Microcks, the Kubernetes native tool for API and microservices mocking and testing (microcks.io)
 *
 * The version of the OpenAPI document: 1.10.0
 * Contact: laurent@microcks.io
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package io.github.microcks.client.model;

import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.StringJoiner;
import java.util.Objects;
import java.util.Map;
import java.util.HashMap;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;


import io.github.microcks.client.ApiClient;
/**
 * Representation of Keycloak / SSO configuration used by Microcks server
 */
@JsonPropertyOrder({
  KeycloakConfig.JSON_PROPERTY_REALM,
  KeycloakConfig.JSON_PROPERTY_AUTH_SERVER_URL,
  KeycloakConfig.JSON_PROPERTY_PUBLIC_CLIENT,
  KeycloakConfig.JSON_PROPERTY_SSL_REQUIRED,
  KeycloakConfig.JSON_PROPERTY_RESOURCE,
  KeycloakConfig.JSON_PROPERTY_ENABLED
})
@jakarta.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2024-08-23T22:01:06.998198+02:00[Europe/Paris]", comments = "Generator version: 7.7.0")
public class KeycloakConfig {
  public static final String JSON_PROPERTY_REALM = "realm";
  private String realm;

  public static final String JSON_PROPERTY_AUTH_SERVER_URL = "auth-server-url";
  private String authServerUrl;

  public static final String JSON_PROPERTY_PUBLIC_CLIENT = "public-client";
  private Boolean publicClient;

  /**
   * SSL certificates requirements
   */
  public enum SslRequiredEnum {
    NONE("none"),
    
    EXTERNAL("external");

    private String value;

    SslRequiredEnum(String value) {
      this.value = value;
    }

    @JsonValue
    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    @JsonCreator
    public static SslRequiredEnum fromValue(String value) {
      for (SslRequiredEnum b : SslRequiredEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }
  }

  public static final String JSON_PROPERTY_SSL_REQUIRED = "ssl-required";
  private SslRequiredEnum sslRequired;

  public static final String JSON_PROPERTY_RESOURCE = "resource";
  private String resource;

  public static final String JSON_PROPERTY_ENABLED = "enabled";
  private Boolean enabled;

  public KeycloakConfig() { 
  }

  public KeycloakConfig realm(String realm) {
    this.realm = realm;
    return this;
  }

  /**
   * Authentication realm name
   * @return realm
   */
  @jakarta.annotation.Nonnull
  @JsonProperty(JSON_PROPERTY_REALM)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public String getRealm() {
    return realm;
  }


  @JsonProperty(JSON_PROPERTY_REALM)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setRealm(String realm) {
    this.realm = realm;
  }


  public KeycloakConfig authServerUrl(String authServerUrl) {
    this.authServerUrl = authServerUrl;
    return this;
  }

  /**
   * SSO Server authentication url
   * @return authServerUrl
   */
  @jakarta.annotation.Nonnull
  @JsonProperty(JSON_PROPERTY_AUTH_SERVER_URL)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public String getAuthServerUrl() {
    return authServerUrl;
  }


  @JsonProperty(JSON_PROPERTY_AUTH_SERVER_URL)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setAuthServerUrl(String authServerUrl) {
    this.authServerUrl = authServerUrl;
  }


  public KeycloakConfig publicClient(Boolean publicClient) {
    this.publicClient = publicClient;
    return this;
  }

  /**
   * Name of public-client that can be used for requesting OAuth token
   * @return publicClient
   */
  @jakarta.annotation.Nonnull
  @JsonProperty(JSON_PROPERTY_PUBLIC_CLIENT)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public Boolean getPublicClient() {
    return publicClient;
  }


  @JsonProperty(JSON_PROPERTY_PUBLIC_CLIENT)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setPublicClient(Boolean publicClient) {
    this.publicClient = publicClient;
  }


  public KeycloakConfig sslRequired(SslRequiredEnum sslRequired) {
    this.sslRequired = sslRequired;
    return this;
  }

  /**
   * SSL certificates requirements
   * @return sslRequired
   */
  @jakarta.annotation.Nonnull
  @JsonProperty(JSON_PROPERTY_SSL_REQUIRED)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public SslRequiredEnum getSslRequired() {
    return sslRequired;
  }


  @JsonProperty(JSON_PROPERTY_SSL_REQUIRED)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setSslRequired(SslRequiredEnum sslRequired) {
    this.sslRequired = sslRequired;
  }


  public KeycloakConfig resource(String resource) {
    this.resource = resource;
    return this;
  }

  /**
   * Name of Keycloak resource/application used on client side
   * @return resource
   */
  @jakarta.annotation.Nonnull
  @JsonProperty(JSON_PROPERTY_RESOURCE)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public String getResource() {
    return resource;
  }


  @JsonProperty(JSON_PROPERTY_RESOURCE)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setResource(String resource) {
    this.resource = resource;
  }


  public KeycloakConfig enabled(Boolean enabled) {
    this.enabled = enabled;
    return this;
  }

  /**
   * Whether Keycloak authentification and usage is enabled
   * @return enabled
   */
  @jakarta.annotation.Nonnull
  @JsonProperty(JSON_PROPERTY_ENABLED)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public Boolean getEnabled() {
    return enabled;
  }


  @JsonProperty(JSON_PROPERTY_ENABLED)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setEnabled(Boolean enabled) {
    this.enabled = enabled;
  }


  /**
   * Return true if this KeycloakConfig object is equal to o.
   */
  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    KeycloakConfig keycloakConfig = (KeycloakConfig) o;
    return Objects.equals(this.realm, keycloakConfig.realm) &&
        Objects.equals(this.authServerUrl, keycloakConfig.authServerUrl) &&
        Objects.equals(this.publicClient, keycloakConfig.publicClient) &&
        Objects.equals(this.sslRequired, keycloakConfig.sslRequired) &&
        Objects.equals(this.resource, keycloakConfig.resource) &&
        Objects.equals(this.enabled, keycloakConfig.enabled);
  }

  @Override
  public int hashCode() {
    return Objects.hash(realm, authServerUrl, publicClient, sslRequired, resource, enabled);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class KeycloakConfig {\n");
    sb.append("    realm: ").append(toIndentedString(realm)).append("\n");
    sb.append("    authServerUrl: ").append(toIndentedString(authServerUrl)).append("\n");
    sb.append("    publicClient: ").append(toIndentedString(publicClient)).append("\n");
    sb.append("    sslRequired: ").append(toIndentedString(sslRequired)).append("\n");
    sb.append("    resource: ").append(toIndentedString(resource)).append("\n");
    sb.append("    enabled: ").append(toIndentedString(enabled)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

  /**
   * Convert the instance into URL query string.
   *
   * @return URL query string
   */
  public String toUrlQueryString() {
    return toUrlQueryString(null);
  }

  /**
   * Convert the instance into URL query string.
   *
   * @param prefix prefix of the query string
   * @return URL query string
   */
  public String toUrlQueryString(String prefix) {
    String suffix = "";
    String containerSuffix = "";
    String containerPrefix = "";
    if (prefix == null) {
      // style=form, explode=true, e.g. /pet?name=cat&type=manx
      prefix = "";
    } else {
      // deepObject style e.g. /pet?id[name]=cat&id[type]=manx
      prefix = prefix + "[";
      suffix = "]";
      containerSuffix = "]";
      containerPrefix = "[";
    }

    StringJoiner joiner = new StringJoiner("&");

    // add `realm` to the URL query string
    if (getRealm() != null) {
      joiner.add(String.format("%srealm%s=%s", prefix, suffix, URLEncoder.encode(ApiClient.valueToString(getRealm()), StandardCharsets.UTF_8).replaceAll("\\+", "%20")));
    }

    // add `auth-server-url` to the URL query string
    if (getAuthServerUrl() != null) {
      joiner.add(String.format("%sauth-server-url%s=%s", prefix, suffix, URLEncoder.encode(ApiClient.valueToString(getAuthServerUrl()), StandardCharsets.UTF_8).replaceAll("\\+", "%20")));
    }

    // add `public-client` to the URL query string
    if (getPublicClient() != null) {
      joiner.add(String.format("%spublic-client%s=%s", prefix, suffix, URLEncoder.encode(ApiClient.valueToString(getPublicClient()), StandardCharsets.UTF_8).replaceAll("\\+", "%20")));
    }

    // add `ssl-required` to the URL query string
    if (getSslRequired() != null) {
      joiner.add(String.format("%sssl-required%s=%s", prefix, suffix, URLEncoder.encode(ApiClient.valueToString(getSslRequired()), StandardCharsets.UTF_8).replaceAll("\\+", "%20")));
    }

    // add `resource` to the URL query string
    if (getResource() != null) {
      joiner.add(String.format("%sresource%s=%s", prefix, suffix, URLEncoder.encode(ApiClient.valueToString(getResource()), StandardCharsets.UTF_8).replaceAll("\\+", "%20")));
    }

    // add `enabled` to the URL query string
    if (getEnabled() != null) {
      joiner.add(String.format("%senabled%s=%s", prefix, suffix, URLEncoder.encode(ApiClient.valueToString(getEnabled()), StandardCharsets.UTF_8).replaceAll("\\+", "%20")));
    }

    return joiner.toString();
  }
}

