/*
 * Microcks API v1.10
 * API offered by Microcks, the Kubernetes native tool for API and microservices mocking and testing (microcks.io)
 *
 * The version of the OpenAPI document: 1.10.0
 * Contact: laurent@microcks.io
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package io.github.microcks.client.model;

import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.StringJoiner;
import java.util.Objects;
import java.util.Map;
import java.util.HashMap;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import io.github.microcks.client.model.OAuth2GrantType;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;


import io.github.microcks.client.ApiClient;
/**
 * OAuth2 authorized client that performed a test
 */
@JsonPropertyOrder({
  OAuth2AuthorizedClient.JSON_PROPERTY_GRANT_TYPE,
  OAuth2AuthorizedClient.JSON_PROPERTY_PRINCIPAL_NAME,
  OAuth2AuthorizedClient.JSON_PROPERTY_TOKEN_URI,
  OAuth2AuthorizedClient.JSON_PROPERTY_SCOPES
})
@jakarta.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2024-08-23T22:01:06.998198+02:00[Europe/Paris]", comments = "Generator version: 7.7.0")
public class OAuth2AuthorizedClient {
  public static final String JSON_PROPERTY_GRANT_TYPE = "grantType";
  private OAuth2GrantType grantType;

  public static final String JSON_PROPERTY_PRINCIPAL_NAME = "principalName";
  private String principalName;

  public static final String JSON_PROPERTY_TOKEN_URI = "tokenUri";
  private String tokenUri;

  public static final String JSON_PROPERTY_SCOPES = "scopes";
  private String scopes;

  public OAuth2AuthorizedClient() { 
  }

  public OAuth2AuthorizedClient grantType(OAuth2GrantType grantType) {
    this.grantType = grantType;
    return this;
  }

  /**
   * Get grantType
   * @return grantType
   */
  @jakarta.annotation.Nonnull
  @JsonProperty(JSON_PROPERTY_GRANT_TYPE)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public OAuth2GrantType getGrantType() {
    return grantType;
  }


  @JsonProperty(JSON_PROPERTY_GRANT_TYPE)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setGrantType(OAuth2GrantType grantType) {
    this.grantType = grantType;
  }


  public OAuth2AuthorizedClient principalName(String principalName) {
    this.principalName = principalName;
    return this;
  }

  /**
   * Name of authorized principal (clientId or username in the case of Password grant type)
   * @return principalName
   */
  @jakarta.annotation.Nonnull
  @JsonProperty(JSON_PROPERTY_PRINCIPAL_NAME)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public String getPrincipalName() {
    return principalName;
  }


  @JsonProperty(JSON_PROPERTY_PRINCIPAL_NAME)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setPrincipalName(String principalName) {
    this.principalName = principalName;
  }


  public OAuth2AuthorizedClient tokenUri(String tokenUri) {
    this.tokenUri = tokenUri;
    return this;
  }

  /**
   * Identity Provider URI used for token retrieval
   * @return tokenUri
   */
  @jakarta.annotation.Nonnull
  @JsonProperty(JSON_PROPERTY_TOKEN_URI)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public String getTokenUri() {
    return tokenUri;
  }


  @JsonProperty(JSON_PROPERTY_TOKEN_URI)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setTokenUri(String tokenUri) {
    this.tokenUri = tokenUri;
  }


  public OAuth2AuthorizedClient scopes(String scopes) {
    this.scopes = scopes;
    return this;
  }

  /**
   * Included scopes (separated using space)
   * @return scopes
   */
  @jakarta.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_SCOPES)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public String getScopes() {
    return scopes;
  }


  @JsonProperty(JSON_PROPERTY_SCOPES)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setScopes(String scopes) {
    this.scopes = scopes;
  }


  /**
   * Return true if this OAuth2AuthorizedClient object is equal to o.
   */
  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    OAuth2AuthorizedClient oauth2AuthorizedClient = (OAuth2AuthorizedClient) o;
    return Objects.equals(this.grantType, oauth2AuthorizedClient.grantType) &&
        Objects.equals(this.principalName, oauth2AuthorizedClient.principalName) &&
        Objects.equals(this.tokenUri, oauth2AuthorizedClient.tokenUri) &&
        Objects.equals(this.scopes, oauth2AuthorizedClient.scopes);
  }

  @Override
  public int hashCode() {
    return Objects.hash(grantType, principalName, tokenUri, scopes);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class OAuth2AuthorizedClient {\n");
    sb.append("    grantType: ").append(toIndentedString(grantType)).append("\n");
    sb.append("    principalName: ").append(toIndentedString(principalName)).append("\n");
    sb.append("    tokenUri: ").append(toIndentedString(tokenUri)).append("\n");
    sb.append("    scopes: ").append(toIndentedString(scopes)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

  /**
   * Convert the instance into URL query string.
   *
   * @return URL query string
   */
  public String toUrlQueryString() {
    return toUrlQueryString(null);
  }

  /**
   * Convert the instance into URL query string.
   *
   * @param prefix prefix of the query string
   * @return URL query string
   */
  public String toUrlQueryString(String prefix) {
    String suffix = "";
    String containerSuffix = "";
    String containerPrefix = "";
    if (prefix == null) {
      // style=form, explode=true, e.g. /pet?name=cat&type=manx
      prefix = "";
    } else {
      // deepObject style e.g. /pet?id[name]=cat&id[type]=manx
      prefix = prefix + "[";
      suffix = "]";
      containerSuffix = "]";
      containerPrefix = "[";
    }

    StringJoiner joiner = new StringJoiner("&");

    // add `grantType` to the URL query string
    if (getGrantType() != null) {
      joiner.add(String.format("%sgrantType%s=%s", prefix, suffix, URLEncoder.encode(ApiClient.valueToString(getGrantType()), StandardCharsets.UTF_8).replaceAll("\\+", "%20")));
    }

    // add `principalName` to the URL query string
    if (getPrincipalName() != null) {
      joiner.add(String.format("%sprincipalName%s=%s", prefix, suffix, URLEncoder.encode(ApiClient.valueToString(getPrincipalName()), StandardCharsets.UTF_8).replaceAll("\\+", "%20")));
    }

    // add `tokenUri` to the URL query string
    if (getTokenUri() != null) {
      joiner.add(String.format("%stokenUri%s=%s", prefix, suffix, URLEncoder.encode(ApiClient.valueToString(getTokenUri()), StandardCharsets.UTF_8).replaceAll("\\+", "%20")));
    }

    // add `scopes` to the URL query string
    if (getScopes() != null) {
      joiner.add(String.format("%sscopes%s=%s", prefix, suffix, URLEncoder.encode(ApiClient.valueToString(getScopes()), StandardCharsets.UTF_8).replaceAll("\\+", "%20")));
    }

    return joiner.toString();
  }
}

