/*
 * Microcks API v1.10
 * API offered by Microcks, the Kubernetes native tool for API and microservices mocking and testing (microcks.io)
 *
 * The version of the OpenAPI document: 1.10.0
 * Contact: laurent@microcks.io
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package io.github.microcks.client.model;

import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.StringJoiner;
import java.util.Objects;
import java.util.Map;
import java.util.HashMap;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import io.github.microcks.client.model.Binding;
import io.github.microcks.client.model.ParameterConstraint;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;


import io.github.microcks.client.ApiClient;
/**
 * An Operation of a Service or API
 */
@JsonPropertyOrder({
  Operation.JSON_PROPERTY_NAME,
  Operation.JSON_PROPERTY_METHOD,
  Operation.JSON_PROPERTY_INPUT_NAME,
  Operation.JSON_PROPERTY_OUTPUT_NAME,
  Operation.JSON_PROPERTY_DISPATCHER,
  Operation.JSON_PROPERTY_DISPATCHER_RULES,
  Operation.JSON_PROPERTY_DEFAULT_DELAY,
  Operation.JSON_PROPERTY_RESOURCE_PATHS,
  Operation.JSON_PROPERTY_PARAMETER_CONTRAINTS,
  Operation.JSON_PROPERTY_BINDINGS
})
@jakarta.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2024-08-23T22:01:06.998198+02:00[Europe/Paris]", comments = "Generator version: 7.7.0")
public class Operation {
  public static final String JSON_PROPERTY_NAME = "name";
  private String name;

  public static final String JSON_PROPERTY_METHOD = "method";
  private String method;

  public static final String JSON_PROPERTY_INPUT_NAME = "inputName";
  private String inputName;

  public static final String JSON_PROPERTY_OUTPUT_NAME = "outputName";
  private String outputName;

  public static final String JSON_PROPERTY_DISPATCHER = "dispatcher";
  private String dispatcher;

  public static final String JSON_PROPERTY_DISPATCHER_RULES = "dispatcherRules";
  private String dispatcherRules;

  public static final String JSON_PROPERTY_DEFAULT_DELAY = "defaultDelay";
  private BigDecimal defaultDelay;

  public static final String JSON_PROPERTY_RESOURCE_PATHS = "resourcePaths";
  private List<String> resourcePaths = new ArrayList<>();

  public static final String JSON_PROPERTY_PARAMETER_CONTRAINTS = "parameterContraints";
  private List<ParameterConstraint> parameterContraints = new ArrayList<>();

  public static final String JSON_PROPERTY_BINDINGS = "bindings";
  private Map<String, Binding> bindings = new HashMap<>();

  public Operation() { 
  }

  public Operation name(String name) {
    this.name = name;
    return this;
  }

  /**
   * Unique name of this Operation within Service scope
   * @return name
   */
  @jakarta.annotation.Nonnull
  @JsonProperty(JSON_PROPERTY_NAME)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public String getName() {
    return name;
  }


  @JsonProperty(JSON_PROPERTY_NAME)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setName(String name) {
    this.name = name;
  }


  public Operation method(String method) {
    this.method = method;
    return this;
  }

  /**
   * Represents transport method
   * @return method
   */
  @jakarta.annotation.Nonnull
  @JsonProperty(JSON_PROPERTY_METHOD)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public String getMethod() {
    return method;
  }


  @JsonProperty(JSON_PROPERTY_METHOD)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setMethod(String method) {
    this.method = method;
  }


  public Operation inputName(String inputName) {
    this.inputName = inputName;
    return this;
  }

  /**
   * Name of input parameters in case of Xml based Service
   * @return inputName
   */
  @jakarta.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_INPUT_NAME)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public String getInputName() {
    return inputName;
  }


  @JsonProperty(JSON_PROPERTY_INPUT_NAME)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setInputName(String inputName) {
    this.inputName = inputName;
  }


  public Operation outputName(String outputName) {
    this.outputName = outputName;
    return this;
  }

  /**
   * Name of output parameters in case of Xml based Service
   * @return outputName
   */
  @jakarta.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_OUTPUT_NAME)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public String getOutputName() {
    return outputName;
  }


  @JsonProperty(JSON_PROPERTY_OUTPUT_NAME)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setOutputName(String outputName) {
    this.outputName = outputName;
  }


  public Operation dispatcher(String dispatcher) {
    this.dispatcher = dispatcher;
    return this;
  }

  /**
   * Dispatcher strategy used for mocks
   * @return dispatcher
   */
  @jakarta.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_DISPATCHER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public String getDispatcher() {
    return dispatcher;
  }


  @JsonProperty(JSON_PROPERTY_DISPATCHER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setDispatcher(String dispatcher) {
    this.dispatcher = dispatcher;
  }


  public Operation dispatcherRules(String dispatcherRules) {
    this.dispatcherRules = dispatcherRules;
    return this;
  }

  /**
   * DispatcherRules used for mocks
   * @return dispatcherRules
   */
  @jakarta.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_DISPATCHER_RULES)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public String getDispatcherRules() {
    return dispatcherRules;
  }


  @JsonProperty(JSON_PROPERTY_DISPATCHER_RULES)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setDispatcherRules(String dispatcherRules) {
    this.dispatcherRules = dispatcherRules;
  }


  public Operation defaultDelay(BigDecimal defaultDelay) {
    this.defaultDelay = defaultDelay;
    return this;
  }

  /**
   * Default response time delay for mocks
   * @return defaultDelay
   */
  @jakarta.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_DEFAULT_DELAY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public BigDecimal getDefaultDelay() {
    return defaultDelay;
  }


  @JsonProperty(JSON_PROPERTY_DEFAULT_DELAY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setDefaultDelay(BigDecimal defaultDelay) {
    this.defaultDelay = defaultDelay;
  }


  public Operation resourcePaths(List<String> resourcePaths) {
    this.resourcePaths = resourcePaths;
    return this;
  }

  public Operation addResourcePathsItem(String resourcePathsItem) {
    if (this.resourcePaths == null) {
      this.resourcePaths = new ArrayList<>();
    }
    this.resourcePaths.add(resourcePathsItem);
    return this;
  }

  /**
   * Paths the mocks endpoints are mapped on
   * @return resourcePaths
   */
  @jakarta.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_RESOURCE_PATHS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public List<String> getResourcePaths() {
    return resourcePaths;
  }


  @JsonProperty(JSON_PROPERTY_RESOURCE_PATHS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setResourcePaths(List<String> resourcePaths) {
    this.resourcePaths = resourcePaths;
  }


  public Operation parameterContraints(List<ParameterConstraint> parameterContraints) {
    this.parameterContraints = parameterContraints;
    return this;
  }

  public Operation addParameterContraintsItem(ParameterConstraint parameterContraintsItem) {
    if (this.parameterContraints == null) {
      this.parameterContraints = new ArrayList<>();
    }
    this.parameterContraints.add(parameterContraintsItem);
    return this;
  }

  /**
   * Contraints that may apply to mock invocatino on this operation
   * @return parameterContraints
   */
  @jakarta.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_PARAMETER_CONTRAINTS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public List<ParameterConstraint> getParameterContraints() {
    return parameterContraints;
  }


  @JsonProperty(JSON_PROPERTY_PARAMETER_CONTRAINTS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setParameterContraints(List<ParameterConstraint> parameterContraints) {
    this.parameterContraints = parameterContraints;
  }


  public Operation bindings(Map<String, Binding> bindings) {
    this.bindings = bindings;
    return this;
  }

  public Operation putBindingsItem(String key, Binding bindingsItem) {
    if (this.bindings == null) {
      this.bindings = new HashMap<>();
    }
    this.bindings.put(key, bindingsItem);
    return this;
  }

  /**
   * Map of protocol binding details for this operation
   * @return bindings
   */
  @jakarta.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_BINDINGS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public Map<String, Binding> getBindings() {
    return bindings;
  }


  @JsonProperty(JSON_PROPERTY_BINDINGS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setBindings(Map<String, Binding> bindings) {
    this.bindings = bindings;
  }


  /**
   * Return true if this Operation object is equal to o.
   */
  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    Operation operation = (Operation) o;
    return Objects.equals(this.name, operation.name) &&
        Objects.equals(this.method, operation.method) &&
        Objects.equals(this.inputName, operation.inputName) &&
        Objects.equals(this.outputName, operation.outputName) &&
        Objects.equals(this.dispatcher, operation.dispatcher) &&
        Objects.equals(this.dispatcherRules, operation.dispatcherRules) &&
        Objects.equals(this.defaultDelay, operation.defaultDelay) &&
        Objects.equals(this.resourcePaths, operation.resourcePaths) &&
        Objects.equals(this.parameterContraints, operation.parameterContraints) &&
        Objects.equals(this.bindings, operation.bindings);
  }

  @Override
  public int hashCode() {
    return Objects.hash(name, method, inputName, outputName, dispatcher, dispatcherRules, defaultDelay, resourcePaths, parameterContraints, bindings);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class Operation {\n");
    sb.append("    name: ").append(toIndentedString(name)).append("\n");
    sb.append("    method: ").append(toIndentedString(method)).append("\n");
    sb.append("    inputName: ").append(toIndentedString(inputName)).append("\n");
    sb.append("    outputName: ").append(toIndentedString(outputName)).append("\n");
    sb.append("    dispatcher: ").append(toIndentedString(dispatcher)).append("\n");
    sb.append("    dispatcherRules: ").append(toIndentedString(dispatcherRules)).append("\n");
    sb.append("    defaultDelay: ").append(toIndentedString(defaultDelay)).append("\n");
    sb.append("    resourcePaths: ").append(toIndentedString(resourcePaths)).append("\n");
    sb.append("    parameterContraints: ").append(toIndentedString(parameterContraints)).append("\n");
    sb.append("    bindings: ").append(toIndentedString(bindings)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

  /**
   * Convert the instance into URL query string.
   *
   * @return URL query string
   */
  public String toUrlQueryString() {
    return toUrlQueryString(null);
  }

  /**
   * Convert the instance into URL query string.
   *
   * @param prefix prefix of the query string
   * @return URL query string
   */
  public String toUrlQueryString(String prefix) {
    String suffix = "";
    String containerSuffix = "";
    String containerPrefix = "";
    if (prefix == null) {
      // style=form, explode=true, e.g. /pet?name=cat&type=manx
      prefix = "";
    } else {
      // deepObject style e.g. /pet?id[name]=cat&id[type]=manx
      prefix = prefix + "[";
      suffix = "]";
      containerSuffix = "]";
      containerPrefix = "[";
    }

    StringJoiner joiner = new StringJoiner("&");

    // add `name` to the URL query string
    if (getName() != null) {
      joiner.add(String.format("%sname%s=%s", prefix, suffix, URLEncoder.encode(ApiClient.valueToString(getName()), StandardCharsets.UTF_8).replaceAll("\\+", "%20")));
    }

    // add `method` to the URL query string
    if (getMethod() != null) {
      joiner.add(String.format("%smethod%s=%s", prefix, suffix, URLEncoder.encode(ApiClient.valueToString(getMethod()), StandardCharsets.UTF_8).replaceAll("\\+", "%20")));
    }

    // add `inputName` to the URL query string
    if (getInputName() != null) {
      joiner.add(String.format("%sinputName%s=%s", prefix, suffix, URLEncoder.encode(ApiClient.valueToString(getInputName()), StandardCharsets.UTF_8).replaceAll("\\+", "%20")));
    }

    // add `outputName` to the URL query string
    if (getOutputName() != null) {
      joiner.add(String.format("%soutputName%s=%s", prefix, suffix, URLEncoder.encode(ApiClient.valueToString(getOutputName()), StandardCharsets.UTF_8).replaceAll("\\+", "%20")));
    }

    // add `dispatcher` to the URL query string
    if (getDispatcher() != null) {
      joiner.add(String.format("%sdispatcher%s=%s", prefix, suffix, URLEncoder.encode(ApiClient.valueToString(getDispatcher()), StandardCharsets.UTF_8).replaceAll("\\+", "%20")));
    }

    // add `dispatcherRules` to the URL query string
    if (getDispatcherRules() != null) {
      joiner.add(String.format("%sdispatcherRules%s=%s", prefix, suffix, URLEncoder.encode(ApiClient.valueToString(getDispatcherRules()), StandardCharsets.UTF_8).replaceAll("\\+", "%20")));
    }

    // add `defaultDelay` to the URL query string
    if (getDefaultDelay() != null) {
      joiner.add(String.format("%sdefaultDelay%s=%s", prefix, suffix, URLEncoder.encode(ApiClient.valueToString(getDefaultDelay()), StandardCharsets.UTF_8).replaceAll("\\+", "%20")));
    }

    // add `resourcePaths` to the URL query string
    if (getResourcePaths() != null) {
      for (int i = 0; i < getResourcePaths().size(); i++) {
        joiner.add(String.format("%sresourcePaths%s%s=%s", prefix, suffix,
            "".equals(suffix) ? "" : String.format("%s%d%s", containerPrefix, i, containerSuffix),
            URLEncoder.encode(ApiClient.valueToString(getResourcePaths().get(i)), StandardCharsets.UTF_8).replaceAll("\\+", "%20")));
      }
    }

    // add `parameterContraints` to the URL query string
    if (getParameterContraints() != null) {
      for (int i = 0; i < getParameterContraints().size(); i++) {
        if (getParameterContraints().get(i) != null) {
          joiner.add(getParameterContraints().get(i).toUrlQueryString(String.format("%sparameterContraints%s%s", prefix, suffix,
          "".equals(suffix) ? "" : String.format("%s%d%s", containerPrefix, i, containerSuffix))));
        }
      }
    }

    // add `bindings` to the URL query string
    if (getBindings() != null) {
      for (String _key : getBindings().keySet()) {
        if (getBindings().get(_key) != null) {
          joiner.add(getBindings().get(_key).toUrlQueryString(String.format("%sbindings%s%s", prefix, suffix,
              "".equals(suffix) ? "" : String.format("%s%d%s", containerPrefix, _key, containerSuffix))));
        }
      }
    }

    return joiner.toString();
  }
}

