/*
 * Microcks API v1.10
 * API offered by Microcks, the Kubernetes native tool for API and microservices mocking and testing (microcks.io)
 *
 * The version of the OpenAPI document: 1.10.0
 * Contact: laurent@microcks.io
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package io.github.microcks.client.model;

import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.StringJoiner;
import java.util.Objects;
import java.util.Map;
import java.util.HashMap;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import io.github.microcks.client.model.ParameterConstraint;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;


import io.github.microcks.client.ApiClient;
/**
 * Data Transfer object for grouping the mutable properties of an Operation
 */
@JsonPropertyOrder({
  OperationOverrideDTO.JSON_PROPERTY_DISPATCHER,
  OperationOverrideDTO.JSON_PROPERTY_DISPATCHER_RULES,
  OperationOverrideDTO.JSON_PROPERTY_DEFAULT_DELAY,
  OperationOverrideDTO.JSON_PROPERTY_PARAMETER_CONSTRAINTS
})
@jakarta.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2024-08-23T22:01:06.998198+02:00[Europe/Paris]", comments = "Generator version: 7.7.0")
public class OperationOverrideDTO {
  public static final String JSON_PROPERTY_DISPATCHER = "dispatcher";
  private String dispatcher;

  public static final String JSON_PROPERTY_DISPATCHER_RULES = "dispatcherRules";
  private String dispatcherRules;

  public static final String JSON_PROPERTY_DEFAULT_DELAY = "defaultDelay";
  private Integer defaultDelay;

  public static final String JSON_PROPERTY_PARAMETER_CONSTRAINTS = "parameterConstraints";
  private List<ParameterConstraint> parameterConstraints = new ArrayList<>();

  public OperationOverrideDTO() { 
  }

  public OperationOverrideDTO dispatcher(String dispatcher) {
    this.dispatcher = dispatcher;
    return this;
  }

  /**
   * Type of dispatcher to apply for this operation
   * @return dispatcher
   */
  @jakarta.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_DISPATCHER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public String getDispatcher() {
    return dispatcher;
  }


  @JsonProperty(JSON_PROPERTY_DISPATCHER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setDispatcher(String dispatcher) {
    this.dispatcher = dispatcher;
  }


  public OperationOverrideDTO dispatcherRules(String dispatcherRules) {
    this.dispatcherRules = dispatcherRules;
    return this;
  }

  /**
   * Rules of dispatcher for this operation
   * @return dispatcherRules
   */
  @jakarta.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_DISPATCHER_RULES)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public String getDispatcherRules() {
    return dispatcherRules;
  }


  @JsonProperty(JSON_PROPERTY_DISPATCHER_RULES)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setDispatcherRules(String dispatcherRules) {
    this.dispatcherRules = dispatcherRules;
  }


  public OperationOverrideDTO defaultDelay(Integer defaultDelay) {
    this.defaultDelay = defaultDelay;
    return this;
  }

  /**
   * Default delay in milliseconds to apply to mock responses on this operation
   * @return defaultDelay
   */
  @jakarta.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_DEFAULT_DELAY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public Integer getDefaultDelay() {
    return defaultDelay;
  }


  @JsonProperty(JSON_PROPERTY_DEFAULT_DELAY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setDefaultDelay(Integer defaultDelay) {
    this.defaultDelay = defaultDelay;
  }


  public OperationOverrideDTO parameterConstraints(List<ParameterConstraint> parameterConstraints) {
    this.parameterConstraints = parameterConstraints;
    return this;
  }

  public OperationOverrideDTO addParameterConstraintsItem(ParameterConstraint parameterConstraintsItem) {
    if (this.parameterConstraints == null) {
      this.parameterConstraints = new ArrayList<>();
    }
    this.parameterConstraints.add(parameterConstraintsItem);
    return this;
  }

  /**
   * Constraints that may apply to incoming parameters on this operation
   * @return parameterConstraints
   */
  @jakarta.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_PARAMETER_CONSTRAINTS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public List<ParameterConstraint> getParameterConstraints() {
    return parameterConstraints;
  }


  @JsonProperty(JSON_PROPERTY_PARAMETER_CONSTRAINTS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setParameterConstraints(List<ParameterConstraint> parameterConstraints) {
    this.parameterConstraints = parameterConstraints;
  }


  /**
   * Return true if this OperationOverrideDTO object is equal to o.
   */
  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    OperationOverrideDTO operationOverrideDTO = (OperationOverrideDTO) o;
    return Objects.equals(this.dispatcher, operationOverrideDTO.dispatcher) &&
        Objects.equals(this.dispatcherRules, operationOverrideDTO.dispatcherRules) &&
        Objects.equals(this.defaultDelay, operationOverrideDTO.defaultDelay) &&
        Objects.equals(this.parameterConstraints, operationOverrideDTO.parameterConstraints);
  }

  @Override
  public int hashCode() {
    return Objects.hash(dispatcher, dispatcherRules, defaultDelay, parameterConstraints);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class OperationOverrideDTO {\n");
    sb.append("    dispatcher: ").append(toIndentedString(dispatcher)).append("\n");
    sb.append("    dispatcherRules: ").append(toIndentedString(dispatcherRules)).append("\n");
    sb.append("    defaultDelay: ").append(toIndentedString(defaultDelay)).append("\n");
    sb.append("    parameterConstraints: ").append(toIndentedString(parameterConstraints)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

  /**
   * Convert the instance into URL query string.
   *
   * @return URL query string
   */
  public String toUrlQueryString() {
    return toUrlQueryString(null);
  }

  /**
   * Convert the instance into URL query string.
   *
   * @param prefix prefix of the query string
   * @return URL query string
   */
  public String toUrlQueryString(String prefix) {
    String suffix = "";
    String containerSuffix = "";
    String containerPrefix = "";
    if (prefix == null) {
      // style=form, explode=true, e.g. /pet?name=cat&type=manx
      prefix = "";
    } else {
      // deepObject style e.g. /pet?id[name]=cat&id[type]=manx
      prefix = prefix + "[";
      suffix = "]";
      containerSuffix = "]";
      containerPrefix = "[";
    }

    StringJoiner joiner = new StringJoiner("&");

    // add `dispatcher` to the URL query string
    if (getDispatcher() != null) {
      joiner.add(String.format("%sdispatcher%s=%s", prefix, suffix, URLEncoder.encode(ApiClient.valueToString(getDispatcher()), StandardCharsets.UTF_8).replaceAll("\\+", "%20")));
    }

    // add `dispatcherRules` to the URL query string
    if (getDispatcherRules() != null) {
      joiner.add(String.format("%sdispatcherRules%s=%s", prefix, suffix, URLEncoder.encode(ApiClient.valueToString(getDispatcherRules()), StandardCharsets.UTF_8).replaceAll("\\+", "%20")));
    }

    // add `defaultDelay` to the URL query string
    if (getDefaultDelay() != null) {
      joiner.add(String.format("%sdefaultDelay%s=%s", prefix, suffix, URLEncoder.encode(ApiClient.valueToString(getDefaultDelay()), StandardCharsets.UTF_8).replaceAll("\\+", "%20")));
    }

    // add `parameterConstraints` to the URL query string
    if (getParameterConstraints() != null) {
      for (int i = 0; i < getParameterConstraints().size(); i++) {
        if (getParameterConstraints().get(i) != null) {
          joiner.add(getParameterConstraints().get(i).toUrlQueryString(String.format("%sparameterConstraints%s%s", prefix, suffix,
          "".equals(suffix) ? "" : String.format("%s%d%s", containerPrefix, i, containerSuffix))));
        }
      }
    }

    return joiner.toString();
  }
}

