/*
 * Microcks API v1.10
 * API offered by Microcks, the Kubernetes native tool for API and microservices mocking and testing (microcks.io)
 *
 * The version of the OpenAPI document: 1.10.0
 * Contact: laurent@microcks.io
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package io.github.microcks.client.model;

import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.StringJoiner;
import java.util.Objects;
import java.util.Map;
import java.util.HashMap;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;


import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * Types of managed resources for Services or APIs
 */
public enum ResourceType {
  
  WSDL("WSDL"),
  
  XSD("XSD"),
  
  JSON_SCHEMA("JSON_SCHEMA"),
  
  OPEN_API_SPEC("OPEN_API_SPEC"),
  
  OPEN_API_SCHEMA("OPEN_API_SCHEMA"),
  
  ASYNC_API_SPEC("ASYNC_API_SPEC"),
  
  ASYNC_API_SCHEMA("ASYNC_API_SCHEMA"),
  
  AVRO_SCHEMA("AVRO_SCHEMA"),
  
  PROTOBUF_SCHEMA("PROTOBUF_SCHEMA"),
  
  PROTOBUF_DESCRIPTION("PROTOBUF_DESCRIPTION"),
  
  GRAPHQL_SCHEMA("GRAPHQL_SCHEMA"),
  
  POSTMAN_COLLECTION("POSTMAN_COLLECTION");

  private String value;

  ResourceType(String value) {
    this.value = value;
  }

  @JsonValue
  public String getValue() {
    return value;
  }

  @Override
  public String toString() {
    return String.valueOf(value);
  }

  @JsonCreator
  public static ResourceType fromValue(String value) {
    for (ResourceType b : ResourceType.values()) {
      if (b.value.equals(value)) {
        return b;
      }
    }
    throw new IllegalArgumentException("Unexpected value '" + value + "'");
  }

  /**
   * Convert the instance into URL query string.
   *
   * @param prefix prefix of the query string
   * @return URL query string
   */
  public String toUrlQueryString(String prefix) {
    if (prefix == null) {
      prefix = "";
    }

    return String.format("%s=%s", prefix, this.toString());
  }

}

