/*
 * Microcks API v1.10
 * API offered by Microcks, the Kubernetes native tool for API and microservices mocking and testing (microcks.io)
 *
 * The version of the OpenAPI document: 1.10.0
 * Contact: laurent@microcks.io
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package io.github.microcks.client.model;

import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.StringJoiner;
import java.util.Objects;
import java.util.Map;
import java.util.HashMap;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import io.github.microcks.client.model.Header;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;


import io.github.microcks.client.ApiClient;
/**
 * A mock invocation or test response
 */
@JsonPropertyOrder({
  Response.JSON_PROPERTY_OPERATION_ID,
  Response.JSON_PROPERTY_CONTENT,
  Response.JSON_PROPERTY_ID,
  Response.JSON_PROPERTY_NAME,
  Response.JSON_PROPERTY_TEST_CASE_ID,
  Response.JSON_PROPERTY_HEADERS
})
@jakarta.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2024-08-23T22:01:06.998198+02:00[Europe/Paris]", comments = "Generator version: 7.7.0")
public class Response {
  public static final String JSON_PROPERTY_OPERATION_ID = "operationId";
  private String operationId;

  public static final String JSON_PROPERTY_CONTENT = "content";
  private String content;

  public static final String JSON_PROPERTY_ID = "id";
  private String id;

  public static final String JSON_PROPERTY_NAME = "name";
  private String name;

  public static final String JSON_PROPERTY_TEST_CASE_ID = "testCaseId";
  private String testCaseId;

  public static final String JSON_PROPERTY_HEADERS = "headers";
  private List<Header> headers = new ArrayList<>();

  public Response() { 
  }

  public Response operationId(String operationId) {
    this.operationId = operationId;
    return this;
  }

  /**
   * Identifier of Operation this Response is associated to
   * @return operationId
   */
  @jakarta.annotation.Nonnull
  @JsonProperty(JSON_PROPERTY_OPERATION_ID)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public String getOperationId() {
    return operationId;
  }


  @JsonProperty(JSON_PROPERTY_OPERATION_ID)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setOperationId(String operationId) {
    this.operationId = operationId;
  }


  public Response content(String content) {
    this.content = content;
    return this;
  }

  /**
   * Body content of this Response
   * @return content
   */
  @jakarta.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_CONTENT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public String getContent() {
    return content;
  }


  @JsonProperty(JSON_PROPERTY_CONTENT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setContent(String content) {
    this.content = content;
  }


  public Response id(String id) {
    this.id = id;
    return this;
  }

  /**
   * Unique identifier of Response
   * @return id
   */
  @jakarta.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_ID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public String getId() {
    return id;
  }


  @JsonProperty(JSON_PROPERTY_ID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setId(String id) {
    this.id = id;
  }


  public Response name(String name) {
    this.name = name;
    return this;
  }

  /**
   * Unique distinct name of this Response
   * @return name
   */
  @jakarta.annotation.Nonnull
  @JsonProperty(JSON_PROPERTY_NAME)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public String getName() {
    return name;
  }


  @JsonProperty(JSON_PROPERTY_NAME)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setName(String name) {
    this.name = name;
  }


  public Response testCaseId(String testCaseId) {
    this.testCaseId = testCaseId;
    return this;
  }

  /**
   * Unique identifier of TestCase this Response is attached (in case of a test)
   * @return testCaseId
   */
  @jakarta.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_TEST_CASE_ID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public String getTestCaseId() {
    return testCaseId;
  }


  @JsonProperty(JSON_PROPERTY_TEST_CASE_ID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setTestCaseId(String testCaseId) {
    this.testCaseId = testCaseId;
  }


  public Response headers(List<Header> headers) {
    this.headers = headers;
    return this;
  }

  public Response addHeadersItem(Header headersItem) {
    if (this.headers == null) {
      this.headers = new ArrayList<>();
    }
    this.headers.add(headersItem);
    return this;
  }

  /**
   * Headers for this Response
   * @return headers
   */
  @jakarta.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_HEADERS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public List<Header> getHeaders() {
    return headers;
  }


  @JsonProperty(JSON_PROPERTY_HEADERS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setHeaders(List<Header> headers) {
    this.headers = headers;
  }


  /**
   * Return true if this Response object is equal to o.
   */
  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    Response response = (Response) o;
    return Objects.equals(this.operationId, response.operationId) &&
        Objects.equals(this.content, response.content) &&
        Objects.equals(this.id, response.id) &&
        Objects.equals(this.name, response.name) &&
        Objects.equals(this.testCaseId, response.testCaseId) &&
        Objects.equals(this.headers, response.headers);
  }

  @Override
  public int hashCode() {
    return Objects.hash(operationId, content, id, name, testCaseId, headers);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class Response {\n");
    sb.append("    operationId: ").append(toIndentedString(operationId)).append("\n");
    sb.append("    content: ").append(toIndentedString(content)).append("\n");
    sb.append("    id: ").append(toIndentedString(id)).append("\n");
    sb.append("    name: ").append(toIndentedString(name)).append("\n");
    sb.append("    testCaseId: ").append(toIndentedString(testCaseId)).append("\n");
    sb.append("    headers: ").append(toIndentedString(headers)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

  /**
   * Convert the instance into URL query string.
   *
   * @return URL query string
   */
  public String toUrlQueryString() {
    return toUrlQueryString(null);
  }

  /**
   * Convert the instance into URL query string.
   *
   * @param prefix prefix of the query string
   * @return URL query string
   */
  public String toUrlQueryString(String prefix) {
    String suffix = "";
    String containerSuffix = "";
    String containerPrefix = "";
    if (prefix == null) {
      // style=form, explode=true, e.g. /pet?name=cat&type=manx
      prefix = "";
    } else {
      // deepObject style e.g. /pet?id[name]=cat&id[type]=manx
      prefix = prefix + "[";
      suffix = "]";
      containerSuffix = "]";
      containerPrefix = "[";
    }

    StringJoiner joiner = new StringJoiner("&");

    // add `operationId` to the URL query string
    if (getOperationId() != null) {
      joiner.add(String.format("%soperationId%s=%s", prefix, suffix, URLEncoder.encode(ApiClient.valueToString(getOperationId()), StandardCharsets.UTF_8).replaceAll("\\+", "%20")));
    }

    // add `content` to the URL query string
    if (getContent() != null) {
      joiner.add(String.format("%scontent%s=%s", prefix, suffix, URLEncoder.encode(ApiClient.valueToString(getContent()), StandardCharsets.UTF_8).replaceAll("\\+", "%20")));
    }

    // add `id` to the URL query string
    if (getId() != null) {
      joiner.add(String.format("%sid%s=%s", prefix, suffix, URLEncoder.encode(ApiClient.valueToString(getId()), StandardCharsets.UTF_8).replaceAll("\\+", "%20")));
    }

    // add `name` to the URL query string
    if (getName() != null) {
      joiner.add(String.format("%sname%s=%s", prefix, suffix, URLEncoder.encode(ApiClient.valueToString(getName()), StandardCharsets.UTF_8).replaceAll("\\+", "%20")));
    }

    // add `testCaseId` to the URL query string
    if (getTestCaseId() != null) {
      joiner.add(String.format("%stestCaseId%s=%s", prefix, suffix, URLEncoder.encode(ApiClient.valueToString(getTestCaseId()), StandardCharsets.UTF_8).replaceAll("\\+", "%20")));
    }

    // add `headers` to the URL query string
    if (getHeaders() != null) {
      for (int i = 0; i < getHeaders().size(); i++) {
        if (getHeaders().get(i) != null) {
          joiner.add(getHeaders().get(i).toUrlQueryString(String.format("%sheaders%s%s", prefix, suffix,
          "".equals(suffix) ? "" : String.format("%s%d%s", containerPrefix, i, containerSuffix))));
        }
      }
    }

    return joiner.toString();
  }
}

