/*
 * Microcks API v1.10
 * API offered by Microcks, the Kubernetes native tool for API and microservices mocking and testing (microcks.io)
 *
 * The version of the OpenAPI document: 1.10.0
 * Contact: laurent@microcks.io
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package io.github.microcks.client.model;

import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.StringJoiner;
import java.util.Objects;
import java.util.Map;
import java.util.HashMap;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import io.github.microcks.client.model.Metadata;
import io.github.microcks.client.model.Operation;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;


import io.github.microcks.client.ApiClient;
/**
 * Represents a Service or API definition as registred into Microcks repository
 */
@JsonPropertyOrder({
  Service.JSON_PROPERTY_ID,
  Service.JSON_PROPERTY_NAME,
  Service.JSON_PROPERTY_VERSION,
  Service.JSON_PROPERTY_TYPE,
  Service.JSON_PROPERTY_OPERATIONS,
  Service.JSON_PROPERTY_XML_N_S,
  Service.JSON_PROPERTY_METADATA,
  Service.JSON_PROPERTY_SOURCE_ARTIFACT
})
@jakarta.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2024-08-23T22:01:06.998198+02:00[Europe/Paris]", comments = "Generator version: 7.7.0")
public class Service {
  public static final String JSON_PROPERTY_ID = "id";
  private String id;

  public static final String JSON_PROPERTY_NAME = "name";
  private String name;

  public static final String JSON_PROPERTY_VERSION = "version";
  private String version;

  /**
   * Service or API Type
   */
  public enum TypeEnum {
    REST("REST"),
    
    SOAP_HTTP("SOAP_HTTP"),
    
    GENERIC_REST("GENERIC_REST"),
    
    GENERIC_EVENT("GENERIC_EVENT"),
    
    EVENT("EVENT"),
    
    GRPC("GRPC"),
    
    GRAPHQL("GRAPHQL");

    private String value;

    TypeEnum(String value) {
      this.value = value;
    }

    @JsonValue
    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    @JsonCreator
    public static TypeEnum fromValue(String value) {
      for (TypeEnum b : TypeEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }
  }

  public static final String JSON_PROPERTY_TYPE = "type";
  private TypeEnum type;

  public static final String JSON_PROPERTY_OPERATIONS = "operations";
  private List<Operation> operations = new ArrayList<>();

  public static final String JSON_PROPERTY_XML_N_S = "xmlNS";
  private String xmlNS;

  public static final String JSON_PROPERTY_METADATA = "metadata";
  private Metadata metadata;

  public static final String JSON_PROPERTY_SOURCE_ARTIFACT = "sourceArtifact";
  private String sourceArtifact;

  public Service() { 
  }

  public Service id(String id) {
    this.id = id;
    return this;
  }

  /**
   * Unique identifier for this Service or API
   * @return id
   */
  @jakarta.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_ID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public String getId() {
    return id;
  }


  @JsonProperty(JSON_PROPERTY_ID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setId(String id) {
    this.id = id;
  }


  public Service name(String name) {
    this.name = name;
    return this;
  }

  /**
   * Distinct name for this Service or API (maybe shared among many versions)
   * @return name
   */
  @jakarta.annotation.Nonnull
  @JsonProperty(JSON_PROPERTY_NAME)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public String getName() {
    return name;
  }


  @JsonProperty(JSON_PROPERTY_NAME)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setName(String name) {
    this.name = name;
  }


  public Service version(String version) {
    this.version = version;
    return this;
  }

  /**
   * Distinct version for a named Service or API
   * @return version
   */
  @jakarta.annotation.Nonnull
  @JsonProperty(JSON_PROPERTY_VERSION)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public String getVersion() {
    return version;
  }


  @JsonProperty(JSON_PROPERTY_VERSION)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setVersion(String version) {
    this.version = version;
  }


  public Service type(TypeEnum type) {
    this.type = type;
    return this;
  }

  /**
   * Service or API Type
   * @return type
   */
  @jakarta.annotation.Nonnull
  @JsonProperty(JSON_PROPERTY_TYPE)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public TypeEnum getType() {
    return type;
  }


  @JsonProperty(JSON_PROPERTY_TYPE)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setType(TypeEnum type) {
    this.type = type;
  }


  public Service operations(List<Operation> operations) {
    this.operations = operations;
    return this;
  }

  public Service addOperationsItem(Operation operationsItem) {
    if (this.operations == null) {
      this.operations = new ArrayList<>();
    }
    this.operations.add(operationsItem);
    return this;
  }

  /**
   * Set of Operations for Service or API
   * @return operations
   */
  @jakarta.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_OPERATIONS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public List<Operation> getOperations() {
    return operations;
  }


  @JsonProperty(JSON_PROPERTY_OPERATIONS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setOperations(List<Operation> operations) {
    this.operations = operations;
  }


  public Service xmlNS(String xmlNS) {
    this.xmlNS = xmlNS;
    return this;
  }

  /**
   * Associated Xml Namespace in case of Xml based Service
   * @return xmlNS
   */
  @jakarta.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_XML_N_S)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public String getXmlNS() {
    return xmlNS;
  }


  @JsonProperty(JSON_PROPERTY_XML_N_S)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setXmlNS(String xmlNS) {
    this.xmlNS = xmlNS;
  }


  public Service metadata(Metadata metadata) {
    this.metadata = metadata;
    return this;
  }

  /**
   * Get metadata
   * @return metadata
   */
  @jakarta.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_METADATA)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public Metadata getMetadata() {
    return metadata;
  }


  @JsonProperty(JSON_PROPERTY_METADATA)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setMetadata(Metadata metadata) {
    this.metadata = metadata;
  }


  public Service sourceArtifact(String sourceArtifact) {
    this.sourceArtifact = sourceArtifact;
    return this;
  }

  /**
   * Short name of the main/primary artifact this service was created from
   * @return sourceArtifact
   */
  @jakarta.annotation.Nonnull
  @JsonProperty(JSON_PROPERTY_SOURCE_ARTIFACT)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public String getSourceArtifact() {
    return sourceArtifact;
  }


  @JsonProperty(JSON_PROPERTY_SOURCE_ARTIFACT)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setSourceArtifact(String sourceArtifact) {
    this.sourceArtifact = sourceArtifact;
  }


  /**
   * Return true if this Service object is equal to o.
   */
  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    Service service = (Service) o;
    return Objects.equals(this.id, service.id) &&
        Objects.equals(this.name, service.name) &&
        Objects.equals(this.version, service.version) &&
        Objects.equals(this.type, service.type) &&
        Objects.equals(this.operations, service.operations) &&
        Objects.equals(this.xmlNS, service.xmlNS) &&
        Objects.equals(this.metadata, service.metadata) &&
        Objects.equals(this.sourceArtifact, service.sourceArtifact);
  }

  @Override
  public int hashCode() {
    return Objects.hash(id, name, version, type, operations, xmlNS, metadata, sourceArtifact);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class Service {\n");
    sb.append("    id: ").append(toIndentedString(id)).append("\n");
    sb.append("    name: ").append(toIndentedString(name)).append("\n");
    sb.append("    version: ").append(toIndentedString(version)).append("\n");
    sb.append("    type: ").append(toIndentedString(type)).append("\n");
    sb.append("    operations: ").append(toIndentedString(operations)).append("\n");
    sb.append("    xmlNS: ").append(toIndentedString(xmlNS)).append("\n");
    sb.append("    metadata: ").append(toIndentedString(metadata)).append("\n");
    sb.append("    sourceArtifact: ").append(toIndentedString(sourceArtifact)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

  /**
   * Convert the instance into URL query string.
   *
   * @return URL query string
   */
  public String toUrlQueryString() {
    return toUrlQueryString(null);
  }

  /**
   * Convert the instance into URL query string.
   *
   * @param prefix prefix of the query string
   * @return URL query string
   */
  public String toUrlQueryString(String prefix) {
    String suffix = "";
    String containerSuffix = "";
    String containerPrefix = "";
    if (prefix == null) {
      // style=form, explode=true, e.g. /pet?name=cat&type=manx
      prefix = "";
    } else {
      // deepObject style e.g. /pet?id[name]=cat&id[type]=manx
      prefix = prefix + "[";
      suffix = "]";
      containerSuffix = "]";
      containerPrefix = "[";
    }

    StringJoiner joiner = new StringJoiner("&");

    // add `id` to the URL query string
    if (getId() != null) {
      joiner.add(String.format("%sid%s=%s", prefix, suffix, URLEncoder.encode(ApiClient.valueToString(getId()), StandardCharsets.UTF_8).replaceAll("\\+", "%20")));
    }

    // add `name` to the URL query string
    if (getName() != null) {
      joiner.add(String.format("%sname%s=%s", prefix, suffix, URLEncoder.encode(ApiClient.valueToString(getName()), StandardCharsets.UTF_8).replaceAll("\\+", "%20")));
    }

    // add `version` to the URL query string
    if (getVersion() != null) {
      joiner.add(String.format("%sversion%s=%s", prefix, suffix, URLEncoder.encode(ApiClient.valueToString(getVersion()), StandardCharsets.UTF_8).replaceAll("\\+", "%20")));
    }

    // add `type` to the URL query string
    if (getType() != null) {
      joiner.add(String.format("%stype%s=%s", prefix, suffix, URLEncoder.encode(ApiClient.valueToString(getType()), StandardCharsets.UTF_8).replaceAll("\\+", "%20")));
    }

    // add `operations` to the URL query string
    if (getOperations() != null) {
      for (int i = 0; i < getOperations().size(); i++) {
        if (getOperations().get(i) != null) {
          joiner.add(getOperations().get(i).toUrlQueryString(String.format("%soperations%s%s", prefix, suffix,
          "".equals(suffix) ? "" : String.format("%s%d%s", containerPrefix, i, containerSuffix))));
        }
      }
    }

    // add `xmlNS` to the URL query string
    if (getXmlNS() != null) {
      joiner.add(String.format("%sxmlNS%s=%s", prefix, suffix, URLEncoder.encode(ApiClient.valueToString(getXmlNS()), StandardCharsets.UTF_8).replaceAll("\\+", "%20")));
    }

    // add `metadata` to the URL query string
    if (getMetadata() != null) {
      joiner.add(getMetadata().toUrlQueryString(prefix + "metadata" + suffix));
    }

    // add `sourceArtifact` to the URL query string
    if (getSourceArtifact() != null) {
      joiner.add(String.format("%ssourceArtifact%s=%s", prefix, suffix, URLEncoder.encode(ApiClient.valueToString(getSourceArtifact()), StandardCharsets.UTF_8).replaceAll("\\+", "%20")));
    }

    return joiner.toString();
  }
}

