/*
 * Microcks API v1.10
 * API offered by Microcks, the Kubernetes native tool for API and microservices mocking and testing (microcks.io)
 *
 * The version of the OpenAPI document: 1.10.0
 * Contact: laurent@microcks.io
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package io.github.microcks.client.model;

import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.StringJoiner;
import java.util.Objects;
import java.util.Map;
import java.util.HashMap;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import io.github.microcks.client.model.TestStepResult;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;


import io.github.microcks.client.ApiClient;
/**
 * Companion objects for TestResult. Each TestCaseResult correspond to a particuliar service operation / action reference by the operationName field. TestCaseResults owns a collection of TestStepResults (one for every request associated to service operation / action).
 */
@JsonPropertyOrder({
  TestCaseResult.JSON_PROPERTY_SUCCESS,
  TestCaseResult.JSON_PROPERTY_ELAPSED_TIME,
  TestCaseResult.JSON_PROPERTY_OPERATION_NAME,
  TestCaseResult.JSON_PROPERTY_TEST_STEP_RESULTS
})
@jakarta.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2024-08-23T22:01:06.998198+02:00[Europe/Paris]", comments = "Generator version: 7.7.0")
public class TestCaseResult {
  public static final String JSON_PROPERTY_SUCCESS = "success";
  private Boolean success;

  public static final String JSON_PROPERTY_ELAPSED_TIME = "elapsedTime";
  private BigDecimal elapsedTime;

  public static final String JSON_PROPERTY_OPERATION_NAME = "operationName";
  private String operationName;

  public static final String JSON_PROPERTY_TEST_STEP_RESULTS = "testStepResults";
  private List<TestStepResult> testStepResults = new ArrayList<>();

  public TestCaseResult() { 
  }

  public TestCaseResult success(Boolean success) {
    this.success = success;
    return this;
  }

  /**
   * Flag telling if test case is a success
   * @return success
   */
  @jakarta.annotation.Nonnull
  @JsonProperty(JSON_PROPERTY_SUCCESS)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public Boolean getSuccess() {
    return success;
  }


  @JsonProperty(JSON_PROPERTY_SUCCESS)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setSuccess(Boolean success) {
    this.success = success;
  }


  public TestCaseResult elapsedTime(BigDecimal elapsedTime) {
    this.elapsedTime = elapsedTime;
    return this;
  }

  /**
   * Elapsed time in milliseconds since the test case beginning
   * @return elapsedTime
   */
  @jakarta.annotation.Nonnull
  @JsonProperty(JSON_PROPERTY_ELAPSED_TIME)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public BigDecimal getElapsedTime() {
    return elapsedTime;
  }


  @JsonProperty(JSON_PROPERTY_ELAPSED_TIME)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setElapsedTime(BigDecimal elapsedTime) {
    this.elapsedTime = elapsedTime;
  }


  public TestCaseResult operationName(String operationName) {
    this.operationName = operationName;
    return this;
  }

  /**
   * Name of operation this test case is bound to
   * @return operationName
   */
  @jakarta.annotation.Nonnull
  @JsonProperty(JSON_PROPERTY_OPERATION_NAME)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public String getOperationName() {
    return operationName;
  }


  @JsonProperty(JSON_PROPERTY_OPERATION_NAME)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setOperationName(String operationName) {
    this.operationName = operationName;
  }


  public TestCaseResult testStepResults(List<TestStepResult> testStepResults) {
    this.testStepResults = testStepResults;
    return this;
  }

  public TestCaseResult addTestStepResultsItem(TestStepResult testStepResultsItem) {
    if (this.testStepResults == null) {
      this.testStepResults = new ArrayList<>();
    }
    this.testStepResults.add(testStepResultsItem);
    return this;
  }

  /**
   * Test steps associated to this test case
   * @return testStepResults
   */
  @jakarta.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_TEST_STEP_RESULTS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public List<TestStepResult> getTestStepResults() {
    return testStepResults;
  }


  @JsonProperty(JSON_PROPERTY_TEST_STEP_RESULTS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setTestStepResults(List<TestStepResult> testStepResults) {
    this.testStepResults = testStepResults;
  }


  /**
   * Return true if this TestCaseResult object is equal to o.
   */
  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    TestCaseResult testCaseResult = (TestCaseResult) o;
    return Objects.equals(this.success, testCaseResult.success) &&
        Objects.equals(this.elapsedTime, testCaseResult.elapsedTime) &&
        Objects.equals(this.operationName, testCaseResult.operationName) &&
        Objects.equals(this.testStepResults, testCaseResult.testStepResults);
  }

  @Override
  public int hashCode() {
    return Objects.hash(success, elapsedTime, operationName, testStepResults);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class TestCaseResult {\n");
    sb.append("    success: ").append(toIndentedString(success)).append("\n");
    sb.append("    elapsedTime: ").append(toIndentedString(elapsedTime)).append("\n");
    sb.append("    operationName: ").append(toIndentedString(operationName)).append("\n");
    sb.append("    testStepResults: ").append(toIndentedString(testStepResults)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

  /**
   * Convert the instance into URL query string.
   *
   * @return URL query string
   */
  public String toUrlQueryString() {
    return toUrlQueryString(null);
  }

  /**
   * Convert the instance into URL query string.
   *
   * @param prefix prefix of the query string
   * @return URL query string
   */
  public String toUrlQueryString(String prefix) {
    String suffix = "";
    String containerSuffix = "";
    String containerPrefix = "";
    if (prefix == null) {
      // style=form, explode=true, e.g. /pet?name=cat&type=manx
      prefix = "";
    } else {
      // deepObject style e.g. /pet?id[name]=cat&id[type]=manx
      prefix = prefix + "[";
      suffix = "]";
      containerSuffix = "]";
      containerPrefix = "[";
    }

    StringJoiner joiner = new StringJoiner("&");

    // add `success` to the URL query string
    if (getSuccess() != null) {
      joiner.add(String.format("%ssuccess%s=%s", prefix, suffix, URLEncoder.encode(ApiClient.valueToString(getSuccess()), StandardCharsets.UTF_8).replaceAll("\\+", "%20")));
    }

    // add `elapsedTime` to the URL query string
    if (getElapsedTime() != null) {
      joiner.add(String.format("%selapsedTime%s=%s", prefix, suffix, URLEncoder.encode(ApiClient.valueToString(getElapsedTime()), StandardCharsets.UTF_8).replaceAll("\\+", "%20")));
    }

    // add `operationName` to the URL query string
    if (getOperationName() != null) {
      joiner.add(String.format("%soperationName%s=%s", prefix, suffix, URLEncoder.encode(ApiClient.valueToString(getOperationName()), StandardCharsets.UTF_8).replaceAll("\\+", "%20")));
    }

    // add `testStepResults` to the URL query string
    if (getTestStepResults() != null) {
      for (int i = 0; i < getTestStepResults().size(); i++) {
        if (getTestStepResults().get(i) != null) {
          joiner.add(getTestStepResults().get(i).toUrlQueryString(String.format("%stestStepResults%s%s", prefix, suffix,
          "".equals(suffix) ? "" : String.format("%s%d%s", containerPrefix, i, containerSuffix))));
        }
      }
    }

    return joiner.toString();
  }
}

