/*
 * Microcks API v1.10
 * API offered by Microcks, the Kubernetes native tool for API and microservices mocking and testing (microcks.io)
 *
 * The version of the OpenAPI document: 1.10.0
 * Contact: laurent@microcks.io
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package io.github.microcks.client.model;

import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.StringJoiner;
import java.util.Objects;
import java.util.Map;
import java.util.HashMap;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import io.github.microcks.client.model.Trend;
import java.math.BigDecimal;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;


import io.github.microcks.client.ApiClient;
/**
 * Represents the test conformance metrics (current score, history and evolution trend) of a Service
 */
@JsonPropertyOrder({
  TestConformanceMetric.JSON_PROPERTY_ID,
  TestConformanceMetric.JSON_PROPERTY_SERVICE_ID,
  TestConformanceMetric.JSON_PROPERTY_AGGREGATION_LABEL_VALUE,
  TestConformanceMetric.JSON_PROPERTY_MAX_POSSIBLE_SCORE,
  TestConformanceMetric.JSON_PROPERTY_CURRENT_SCORE,
  TestConformanceMetric.JSON_PROPERTY_LAST_UPDATE_DAY,
  TestConformanceMetric.JSON_PROPERTY_LATEST_TREND,
  TestConformanceMetric.JSON_PROPERTY_LATEST_SCORES
})
@jakarta.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2024-08-23T22:01:06.998198+02:00[Europe/Paris]", comments = "Generator version: 7.7.0")
public class TestConformanceMetric {
  public static final String JSON_PROPERTY_ID = "id";
  private String id;

  public static final String JSON_PROPERTY_SERVICE_ID = "serviceId";
  private String serviceId;

  public static final String JSON_PROPERTY_AGGREGATION_LABEL_VALUE = "aggregationLabelValue";
  private String aggregationLabelValue;

  public static final String JSON_PROPERTY_MAX_POSSIBLE_SCORE = "maxPossibleScore";
  private Double maxPossibleScore;

  public static final String JSON_PROPERTY_CURRENT_SCORE = "currentScore";
  private Double currentScore;

  public static final String JSON_PROPERTY_LAST_UPDATE_DAY = "lastUpdateDay";
  private String lastUpdateDay;

  public static final String JSON_PROPERTY_LATEST_TREND = "latestTrend";
  private Trend latestTrend;

  public static final String JSON_PROPERTY_LATEST_SCORES = "latestScores";
  private Map<String, BigDecimal> latestScores = new HashMap<>();

  public TestConformanceMetric() { 
  }

  public TestConformanceMetric id(String id) {
    this.id = id;
    return this;
  }

  /**
   * Unique identifier of coverage metric
   * @return id
   */
  @jakarta.annotation.Nonnull
  @JsonProperty(JSON_PROPERTY_ID)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public String getId() {
    return id;
  }


  @JsonProperty(JSON_PROPERTY_ID)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setId(String id) {
    this.id = id;
  }


  public TestConformanceMetric serviceId(String serviceId) {
    this.serviceId = serviceId;
    return this;
  }

  /**
   * Unique identifier of the Service this metric is related to
   * @return serviceId
   */
  @jakarta.annotation.Nonnull
  @JsonProperty(JSON_PROPERTY_SERVICE_ID)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public String getServiceId() {
    return serviceId;
  }


  @JsonProperty(JSON_PROPERTY_SERVICE_ID)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setServiceId(String serviceId) {
    this.serviceId = serviceId;
  }


  public TestConformanceMetric aggregationLabelValue(String aggregationLabelValue) {
    this.aggregationLabelValue = aggregationLabelValue;
    return this;
  }

  /**
   * Value of the label used for metrics aggregation (if any)
   * @return aggregationLabelValue
   */
  @jakarta.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_AGGREGATION_LABEL_VALUE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public String getAggregationLabelValue() {
    return aggregationLabelValue;
  }


  @JsonProperty(JSON_PROPERTY_AGGREGATION_LABEL_VALUE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setAggregationLabelValue(String aggregationLabelValue) {
    this.aggregationLabelValue = aggregationLabelValue;
  }


  public TestConformanceMetric maxPossibleScore(Double maxPossibleScore) {
    this.maxPossibleScore = maxPossibleScore;
    return this;
  }

  /**
   * Maximum conformance score that can be reached (depends on samples expresiveness)
   * @return maxPossibleScore
   */
  @jakarta.annotation.Nonnull
  @JsonProperty(JSON_PROPERTY_MAX_POSSIBLE_SCORE)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public Double getMaxPossibleScore() {
    return maxPossibleScore;
  }


  @JsonProperty(JSON_PROPERTY_MAX_POSSIBLE_SCORE)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setMaxPossibleScore(Double maxPossibleScore) {
    this.maxPossibleScore = maxPossibleScore;
  }


  public TestConformanceMetric currentScore(Double currentScore) {
    this.currentScore = currentScore;
    return this;
  }

  /**
   * Current test conformance score for the related Service
   * @return currentScore
   */
  @jakarta.annotation.Nonnull
  @JsonProperty(JSON_PROPERTY_CURRENT_SCORE)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public Double getCurrentScore() {
    return currentScore;
  }


  @JsonProperty(JSON_PROPERTY_CURRENT_SCORE)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setCurrentScore(Double currentScore) {
    this.currentScore = currentScore;
  }


  public TestConformanceMetric lastUpdateDay(String lastUpdateDay) {
    this.lastUpdateDay = lastUpdateDay;
    return this;
  }

  /**
   * The day of latest score update (in yyyyMMdd format)
   * @return lastUpdateDay
   */
  @jakarta.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_LAST_UPDATE_DAY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public String getLastUpdateDay() {
    return lastUpdateDay;
  }


  @JsonProperty(JSON_PROPERTY_LAST_UPDATE_DAY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setLastUpdateDay(String lastUpdateDay) {
    this.lastUpdateDay = lastUpdateDay;
  }


  public TestConformanceMetric latestTrend(Trend latestTrend) {
    this.latestTrend = latestTrend;
    return this;
  }

  /**
   * Get latestTrend
   * @return latestTrend
   */
  @jakarta.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_LATEST_TREND)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public Trend getLatestTrend() {
    return latestTrend;
  }


  @JsonProperty(JSON_PROPERTY_LATEST_TREND)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setLatestTrend(Trend latestTrend) {
    this.latestTrend = latestTrend;
  }


  public TestConformanceMetric latestScores(Map<String, BigDecimal> latestScores) {
    this.latestScores = latestScores;
    return this;
  }

  public TestConformanceMetric putLatestScoresItem(String key, BigDecimal latestScoresItem) {
    if (this.latestScores == null) {
      this.latestScores = new HashMap<>();
    }
    this.latestScores.put(key, latestScoresItem);
    return this;
  }

  /**
   * History of latest scores (key is date with format yyyyMMdd, value is score as double)
   * @return latestScores
   */
  @jakarta.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_LATEST_SCORES)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public Map<String, BigDecimal> getLatestScores() {
    return latestScores;
  }


  @JsonProperty(JSON_PROPERTY_LATEST_SCORES)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setLatestScores(Map<String, BigDecimal> latestScores) {
    this.latestScores = latestScores;
  }


  /**
   * Return true if this TestConformanceMetric object is equal to o.
   */
  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    TestConformanceMetric testConformanceMetric = (TestConformanceMetric) o;
    return Objects.equals(this.id, testConformanceMetric.id) &&
        Objects.equals(this.serviceId, testConformanceMetric.serviceId) &&
        Objects.equals(this.aggregationLabelValue, testConformanceMetric.aggregationLabelValue) &&
        Objects.equals(this.maxPossibleScore, testConformanceMetric.maxPossibleScore) &&
        Objects.equals(this.currentScore, testConformanceMetric.currentScore) &&
        Objects.equals(this.lastUpdateDay, testConformanceMetric.lastUpdateDay) &&
        Objects.equals(this.latestTrend, testConformanceMetric.latestTrend) &&
        Objects.equals(this.latestScores, testConformanceMetric.latestScores);
  }

  @Override
  public int hashCode() {
    return Objects.hash(id, serviceId, aggregationLabelValue, maxPossibleScore, currentScore, lastUpdateDay, latestTrend, latestScores);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class TestConformanceMetric {\n");
    sb.append("    id: ").append(toIndentedString(id)).append("\n");
    sb.append("    serviceId: ").append(toIndentedString(serviceId)).append("\n");
    sb.append("    aggregationLabelValue: ").append(toIndentedString(aggregationLabelValue)).append("\n");
    sb.append("    maxPossibleScore: ").append(toIndentedString(maxPossibleScore)).append("\n");
    sb.append("    currentScore: ").append(toIndentedString(currentScore)).append("\n");
    sb.append("    lastUpdateDay: ").append(toIndentedString(lastUpdateDay)).append("\n");
    sb.append("    latestTrend: ").append(toIndentedString(latestTrend)).append("\n");
    sb.append("    latestScores: ").append(toIndentedString(latestScores)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

  /**
   * Convert the instance into URL query string.
   *
   * @return URL query string
   */
  public String toUrlQueryString() {
    return toUrlQueryString(null);
  }

  /**
   * Convert the instance into URL query string.
   *
   * @param prefix prefix of the query string
   * @return URL query string
   */
  public String toUrlQueryString(String prefix) {
    String suffix = "";
    String containerSuffix = "";
    String containerPrefix = "";
    if (prefix == null) {
      // style=form, explode=true, e.g. /pet?name=cat&type=manx
      prefix = "";
    } else {
      // deepObject style e.g. /pet?id[name]=cat&id[type]=manx
      prefix = prefix + "[";
      suffix = "]";
      containerSuffix = "]";
      containerPrefix = "[";
    }

    StringJoiner joiner = new StringJoiner("&");

    // add `id` to the URL query string
    if (getId() != null) {
      joiner.add(String.format("%sid%s=%s", prefix, suffix, URLEncoder.encode(ApiClient.valueToString(getId()), StandardCharsets.UTF_8).replaceAll("\\+", "%20")));
    }

    // add `serviceId` to the URL query string
    if (getServiceId() != null) {
      joiner.add(String.format("%sserviceId%s=%s", prefix, suffix, URLEncoder.encode(ApiClient.valueToString(getServiceId()), StandardCharsets.UTF_8).replaceAll("\\+", "%20")));
    }

    // add `aggregationLabelValue` to the URL query string
    if (getAggregationLabelValue() != null) {
      joiner.add(String.format("%saggregationLabelValue%s=%s", prefix, suffix, URLEncoder.encode(ApiClient.valueToString(getAggregationLabelValue()), StandardCharsets.UTF_8).replaceAll("\\+", "%20")));
    }

    // add `maxPossibleScore` to the URL query string
    if (getMaxPossibleScore() != null) {
      joiner.add(String.format("%smaxPossibleScore%s=%s", prefix, suffix, URLEncoder.encode(ApiClient.valueToString(getMaxPossibleScore()), StandardCharsets.UTF_8).replaceAll("\\+", "%20")));
    }

    // add `currentScore` to the URL query string
    if (getCurrentScore() != null) {
      joiner.add(String.format("%scurrentScore%s=%s", prefix, suffix, URLEncoder.encode(ApiClient.valueToString(getCurrentScore()), StandardCharsets.UTF_8).replaceAll("\\+", "%20")));
    }

    // add `lastUpdateDay` to the URL query string
    if (getLastUpdateDay() != null) {
      joiner.add(String.format("%slastUpdateDay%s=%s", prefix, suffix, URLEncoder.encode(ApiClient.valueToString(getLastUpdateDay()), StandardCharsets.UTF_8).replaceAll("\\+", "%20")));
    }

    // add `latestTrend` to the URL query string
    if (getLatestTrend() != null) {
      joiner.add(String.format("%slatestTrend%s=%s", prefix, suffix, URLEncoder.encode(ApiClient.valueToString(getLatestTrend()), StandardCharsets.UTF_8).replaceAll("\\+", "%20")));
    }

    // add `latestScores` to the URL query string
    if (getLatestScores() != null) {
      for (String _key : getLatestScores().keySet()) {
        joiner.add(String.format("%slatestScores%s%s=%s", prefix, suffix,
            "".equals(suffix) ? "" : String.format("%s%d%s", containerPrefix, _key, containerSuffix),
            getLatestScores().get(_key), URLEncoder.encode(ApiClient.valueToString(getLatestScores().get(_key)), StandardCharsets.UTF_8).replaceAll("\\+", "%20")));
      }
    }

    return joiner.toString();
  }
}

