/*
 * Microcks API v1.10
 * API offered by Microcks, the Kubernetes native tool for API and microservices mocking and testing (microcks.io)
 *
 * The version of the OpenAPI document: 1.10.0
 * Contact: laurent@microcks.io
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package io.github.microcks.client.model;

import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.StringJoiner;
import java.util.Objects;
import java.util.Map;
import java.util.HashMap;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import io.github.microcks.client.model.HeaderDTO;
import io.github.microcks.client.model.OAuth2ClientContent;
import io.github.microcks.client.model.TestRunnerType;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;


import io.github.microcks.client.ApiClient;
/**
 * Test request is a minimalist wrapper for requesting the launch of a new test
 */
@JsonPropertyOrder({
  TestRequest.JSON_PROPERTY_SERVICE_ID,
  TestRequest.JSON_PROPERTY_TEST_ENDPOINT,
  TestRequest.JSON_PROPERTY_RUNNER_TYPE,
  TestRequest.JSON_PROPERTY_TIMEOUT,
  TestRequest.JSON_PROPERTY_FILTERED_OPERATIONS,
  TestRequest.JSON_PROPERTY_SECRET_NAME,
  TestRequest.JSON_PROPERTY_O_AUTH2_CONTEXT,
  TestRequest.JSON_PROPERTY_OPERATIONS_HEADERS
})
@jakarta.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2024-08-23T22:01:06.998198+02:00[Europe/Paris]", comments = "Generator version: 7.7.0")
public class TestRequest {
  public static final String JSON_PROPERTY_SERVICE_ID = "serviceId";
  private String serviceId;

  public static final String JSON_PROPERTY_TEST_ENDPOINT = "testEndpoint";
  private String testEndpoint;

  public static final String JSON_PROPERTY_RUNNER_TYPE = "runnerType";
  private TestRunnerType runnerType;

  public static final String JSON_PROPERTY_TIMEOUT = "timeout";
  private Integer timeout;

  public static final String JSON_PROPERTY_FILTERED_OPERATIONS = "filteredOperations";
  private List<String> filteredOperations = new ArrayList<>();

  public static final String JSON_PROPERTY_SECRET_NAME = "secretName";
  private String secretName;

  public static final String JSON_PROPERTY_O_AUTH2_CONTEXT = "oAuth2Context";
  private OAuth2ClientContent oAuth2Context;

  public static final String JSON_PROPERTY_OPERATIONS_HEADERS = "operationsHeaders";
  private Map<String, List<HeaderDTO>> operationsHeaders = new HashMap<>();

  public TestRequest() { 
  }

  public TestRequest serviceId(String serviceId) {
    this.serviceId = serviceId;
    return this;
  }

  /**
   * Unique identifier of service to test
   * @return serviceId
   */
  @jakarta.annotation.Nonnull
  @JsonProperty(JSON_PROPERTY_SERVICE_ID)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public String getServiceId() {
    return serviceId;
  }


  @JsonProperty(JSON_PROPERTY_SERVICE_ID)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setServiceId(String serviceId) {
    this.serviceId = serviceId;
  }


  public TestRequest testEndpoint(String testEndpoint) {
    this.testEndpoint = testEndpoint;
    return this;
  }

  /**
   * Endpoint to test for this service
   * @return testEndpoint
   */
  @jakarta.annotation.Nonnull
  @JsonProperty(JSON_PROPERTY_TEST_ENDPOINT)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public String getTestEndpoint() {
    return testEndpoint;
  }


  @JsonProperty(JSON_PROPERTY_TEST_ENDPOINT)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setTestEndpoint(String testEndpoint) {
    this.testEndpoint = testEndpoint;
  }


  public TestRequest runnerType(TestRunnerType runnerType) {
    this.runnerType = runnerType;
    return this;
  }

  /**
   * Get runnerType
   * @return runnerType
   */
  @jakarta.annotation.Nonnull
  @JsonProperty(JSON_PROPERTY_RUNNER_TYPE)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public TestRunnerType getRunnerType() {
    return runnerType;
  }


  @JsonProperty(JSON_PROPERTY_RUNNER_TYPE)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setRunnerType(TestRunnerType runnerType) {
    this.runnerType = runnerType;
  }


  public TestRequest timeout(Integer timeout) {
    this.timeout = timeout;
    return this;
  }

  /**
   * The maximum time (in milliseconds) to wait for this test ends
   * @return timeout
   */
  @jakarta.annotation.Nonnull
  @JsonProperty(JSON_PROPERTY_TIMEOUT)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public Integer getTimeout() {
    return timeout;
  }


  @JsonProperty(JSON_PROPERTY_TIMEOUT)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setTimeout(Integer timeout) {
    this.timeout = timeout;
  }


  public TestRequest filteredOperations(List<String> filteredOperations) {
    this.filteredOperations = filteredOperations;
    return this;
  }

  public TestRequest addFilteredOperationsItem(String filteredOperationsItem) {
    if (this.filteredOperations == null) {
      this.filteredOperations = new ArrayList<>();
    }
    this.filteredOperations.add(filteredOperationsItem);
    return this;
  }

  /**
   * A restriction on service operations to test
   * @return filteredOperations
   */
  @jakarta.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_FILTERED_OPERATIONS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public List<String> getFilteredOperations() {
    return filteredOperations;
  }


  @JsonProperty(JSON_PROPERTY_FILTERED_OPERATIONS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setFilteredOperations(List<String> filteredOperations) {
    this.filteredOperations = filteredOperations;
  }


  public TestRequest secretName(String secretName) {
    this.secretName = secretName;
    return this;
  }

  /**
   * The name of Secret to use for connecting the test endpoint
   * @return secretName
   */
  @jakarta.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_SECRET_NAME)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public String getSecretName() {
    return secretName;
  }


  @JsonProperty(JSON_PROPERTY_SECRET_NAME)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setSecretName(String secretName) {
    this.secretName = secretName;
  }


  public TestRequest oAuth2Context(OAuth2ClientContent oAuth2Context) {
    this.oAuth2Context = oAuth2Context;
    return this;
  }

  /**
   * Get oAuth2Context
   * @return oAuth2Context
   */
  @jakarta.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_O_AUTH2_CONTEXT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public OAuth2ClientContent getoAuth2Context() {
    return oAuth2Context;
  }


  @JsonProperty(JSON_PROPERTY_O_AUTH2_CONTEXT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setoAuth2Context(OAuth2ClientContent oAuth2Context) {
    this.oAuth2Context = oAuth2Context;
  }


  public TestRequest operationsHeaders(Map<String, List<HeaderDTO>> operationsHeaders) {
    this.operationsHeaders = operationsHeaders;
    return this;
  }

  public TestRequest putOperationsHeadersItem(String key, List<HeaderDTO> operationsHeadersItem) {
    if (this.operationsHeaders == null) {
      this.operationsHeaders = new HashMap<>();
    }
    this.operationsHeaders.put(key, operationsHeadersItem);
    return this;
  }

  /**
   * Specification of additional headers for a Service/API operations. Keys are operation name or \&quot;globals\&quot; (if header applies to all), values are Header objects DTO.
   * @return operationsHeaders
   */
  @jakarta.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_OPERATIONS_HEADERS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public Map<String, List<HeaderDTO>> getOperationsHeaders() {
    return operationsHeaders;
  }


  @JsonProperty(JSON_PROPERTY_OPERATIONS_HEADERS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setOperationsHeaders(Map<String, List<HeaderDTO>> operationsHeaders) {
    this.operationsHeaders = operationsHeaders;
  }


  /**
   * Return true if this TestRequest object is equal to o.
   */
  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    TestRequest testRequest = (TestRequest) o;
    return Objects.equals(this.serviceId, testRequest.serviceId) &&
        Objects.equals(this.testEndpoint, testRequest.testEndpoint) &&
        Objects.equals(this.runnerType, testRequest.runnerType) &&
        Objects.equals(this.timeout, testRequest.timeout) &&
        Objects.equals(this.filteredOperations, testRequest.filteredOperations) &&
        Objects.equals(this.secretName, testRequest.secretName) &&
        Objects.equals(this.oAuth2Context, testRequest.oAuth2Context) &&
        Objects.equals(this.operationsHeaders, testRequest.operationsHeaders);
  }

  @Override
  public int hashCode() {
    return Objects.hash(serviceId, testEndpoint, runnerType, timeout, filteredOperations, secretName, oAuth2Context, operationsHeaders);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class TestRequest {\n");
    sb.append("    serviceId: ").append(toIndentedString(serviceId)).append("\n");
    sb.append("    testEndpoint: ").append(toIndentedString(testEndpoint)).append("\n");
    sb.append("    runnerType: ").append(toIndentedString(runnerType)).append("\n");
    sb.append("    timeout: ").append(toIndentedString(timeout)).append("\n");
    sb.append("    filteredOperations: ").append(toIndentedString(filteredOperations)).append("\n");
    sb.append("    secretName: ").append(toIndentedString(secretName)).append("\n");
    sb.append("    oAuth2Context: ").append(toIndentedString(oAuth2Context)).append("\n");
    sb.append("    operationsHeaders: ").append(toIndentedString(operationsHeaders)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

  /**
   * Convert the instance into URL query string.
   *
   * @return URL query string
   */
  public String toUrlQueryString() {
    return toUrlQueryString(null);
  }

  /**
   * Convert the instance into URL query string.
   *
   * @param prefix prefix of the query string
   * @return URL query string
   */
  public String toUrlQueryString(String prefix) {
    String suffix = "";
    String containerSuffix = "";
    String containerPrefix = "";
    if (prefix == null) {
      // style=form, explode=true, e.g. /pet?name=cat&type=manx
      prefix = "";
    } else {
      // deepObject style e.g. /pet?id[name]=cat&id[type]=manx
      prefix = prefix + "[";
      suffix = "]";
      containerSuffix = "]";
      containerPrefix = "[";
    }

    StringJoiner joiner = new StringJoiner("&");

    // add `serviceId` to the URL query string
    if (getServiceId() != null) {
      joiner.add(String.format("%sserviceId%s=%s", prefix, suffix, URLEncoder.encode(ApiClient.valueToString(getServiceId()), StandardCharsets.UTF_8).replaceAll("\\+", "%20")));
    }

    // add `testEndpoint` to the URL query string
    if (getTestEndpoint() != null) {
      joiner.add(String.format("%stestEndpoint%s=%s", prefix, suffix, URLEncoder.encode(ApiClient.valueToString(getTestEndpoint()), StandardCharsets.UTF_8).replaceAll("\\+", "%20")));
    }

    // add `runnerType` to the URL query string
    if (getRunnerType() != null) {
      joiner.add(String.format("%srunnerType%s=%s", prefix, suffix, URLEncoder.encode(ApiClient.valueToString(getRunnerType()), StandardCharsets.UTF_8).replaceAll("\\+", "%20")));
    }

    // add `timeout` to the URL query string
    if (getTimeout() != null) {
      joiner.add(String.format("%stimeout%s=%s", prefix, suffix, URLEncoder.encode(ApiClient.valueToString(getTimeout()), StandardCharsets.UTF_8).replaceAll("\\+", "%20")));
    }

    // add `filteredOperations` to the URL query string
    if (getFilteredOperations() != null) {
      for (int i = 0; i < getFilteredOperations().size(); i++) {
        joiner.add(String.format("%sfilteredOperations%s%s=%s", prefix, suffix,
            "".equals(suffix) ? "" : String.format("%s%d%s", containerPrefix, i, containerSuffix),
            URLEncoder.encode(ApiClient.valueToString(getFilteredOperations().get(i)), StandardCharsets.UTF_8).replaceAll("\\+", "%20")));
      }
    }

    // add `secretName` to the URL query string
    if (getSecretName() != null) {
      joiner.add(String.format("%ssecretName%s=%s", prefix, suffix, URLEncoder.encode(ApiClient.valueToString(getSecretName()), StandardCharsets.UTF_8).replaceAll("\\+", "%20")));
    }

    // add `oAuth2Context` to the URL query string
    if (getoAuth2Context() != null) {
      joiner.add(getoAuth2Context().toUrlQueryString(prefix + "oAuth2Context" + suffix));
    }

    // add `operationsHeaders` to the URL query string
    if (getOperationsHeaders() != null) {
      for (String _key : getOperationsHeaders().keySet()) {
        joiner.add(String.format("%soperationsHeaders%s%s=%s", prefix, suffix,
            "".equals(suffix) ? "" : String.format("%s%d%s", containerPrefix, _key, containerSuffix),
            getOperationsHeaders().get(_key), URLEncoder.encode(ApiClient.valueToString(getOperationsHeaders().get(_key)), StandardCharsets.UTF_8).replaceAll("\\+", "%20")));
      }
    }

    return joiner.toString();
  }
}

