/*
 * Microcks API v1.10
 * API offered by Microcks, the Kubernetes native tool for API and microservices mocking and testing (microcks.io)
 *
 * The version of the OpenAPI document: 1.10.0
 * Contact: laurent@microcks.io
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package io.github.microcks.client.model;

import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.StringJoiner;
import java.util.Objects;
import java.util.Map;
import java.util.HashMap;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;


import io.github.microcks.client.ApiClient;
/**
 * Represents the summary result of a Service or API test run by Microcks. 
 */
@JsonPropertyOrder({
  TestResultSummary.JSON_PROPERTY_ID,
  TestResultSummary.JSON_PROPERTY_TEST_DATE,
  TestResultSummary.JSON_PROPERTY_SERVICE_ID,
  TestResultSummary.JSON_PROPERTY_SUCCESS
})
@jakarta.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2024-08-23T22:01:06.998198+02:00[Europe/Paris]", comments = "Generator version: 7.7.0")
public class TestResultSummary {
  public static final String JSON_PROPERTY_ID = "id";
  private String id;

  public static final String JSON_PROPERTY_TEST_DATE = "testDate";
  private Long testDate;

  public static final String JSON_PROPERTY_SERVICE_ID = "serviceId";
  private String serviceId;

  public static final String JSON_PROPERTY_SUCCESS = "success";
  private Boolean success;

  public TestResultSummary() { 
  }

  public TestResultSummary id(String id) {
    this.id = id;
    return this;
  }

  /**
   * Unique identifier of TestResult
   * @return id
   */
  @jakarta.annotation.Nonnull
  @JsonProperty(JSON_PROPERTY_ID)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public String getId() {
    return id;
  }


  @JsonProperty(JSON_PROPERTY_ID)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setId(String id) {
    this.id = id;
  }


  public TestResultSummary testDate(Long testDate) {
    this.testDate = testDate;
    return this;
  }

  /**
   * Timestamp of creation date of this service
   * @return testDate
   */
  @jakarta.annotation.Nonnull
  @JsonProperty(JSON_PROPERTY_TEST_DATE)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public Long getTestDate() {
    return testDate;
  }


  @JsonProperty(JSON_PROPERTY_TEST_DATE)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setTestDate(Long testDate) {
    this.testDate = testDate;
  }


  public TestResultSummary serviceId(String serviceId) {
    this.serviceId = serviceId;
    return this;
  }

  /**
   * Unique identifier of service tested
   * @return serviceId
   */
  @jakarta.annotation.Nonnull
  @JsonProperty(JSON_PROPERTY_SERVICE_ID)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public String getServiceId() {
    return serviceId;
  }


  @JsonProperty(JSON_PROPERTY_SERVICE_ID)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setServiceId(String serviceId) {
    this.serviceId = serviceId;
  }


  public TestResultSummary success(Boolean success) {
    this.success = success;
    return this;
  }

  /**
   * Flag telling if test is a success
   * @return success
   */
  @jakarta.annotation.Nonnull
  @JsonProperty(JSON_PROPERTY_SUCCESS)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public Boolean getSuccess() {
    return success;
  }


  @JsonProperty(JSON_PROPERTY_SUCCESS)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setSuccess(Boolean success) {
    this.success = success;
  }


  /**
   * Return true if this TestResultSummary object is equal to o.
   */
  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    TestResultSummary testResultSummary = (TestResultSummary) o;
    return Objects.equals(this.id, testResultSummary.id) &&
        Objects.equals(this.testDate, testResultSummary.testDate) &&
        Objects.equals(this.serviceId, testResultSummary.serviceId) &&
        Objects.equals(this.success, testResultSummary.success);
  }

  @Override
  public int hashCode() {
    return Objects.hash(id, testDate, serviceId, success);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class TestResultSummary {\n");
    sb.append("    id: ").append(toIndentedString(id)).append("\n");
    sb.append("    testDate: ").append(toIndentedString(testDate)).append("\n");
    sb.append("    serviceId: ").append(toIndentedString(serviceId)).append("\n");
    sb.append("    success: ").append(toIndentedString(success)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

  /**
   * Convert the instance into URL query string.
   *
   * @return URL query string
   */
  public String toUrlQueryString() {
    return toUrlQueryString(null);
  }

  /**
   * Convert the instance into URL query string.
   *
   * @param prefix prefix of the query string
   * @return URL query string
   */
  public String toUrlQueryString(String prefix) {
    String suffix = "";
    String containerSuffix = "";
    String containerPrefix = "";
    if (prefix == null) {
      // style=form, explode=true, e.g. /pet?name=cat&type=manx
      prefix = "";
    } else {
      // deepObject style e.g. /pet?id[name]=cat&id[type]=manx
      prefix = prefix + "[";
      suffix = "]";
      containerSuffix = "]";
      containerPrefix = "[";
    }

    StringJoiner joiner = new StringJoiner("&");

    // add `id` to the URL query string
    if (getId() != null) {
      joiner.add(String.format("%sid%s=%s", prefix, suffix, URLEncoder.encode(ApiClient.valueToString(getId()), StandardCharsets.UTF_8).replaceAll("\\+", "%20")));
    }

    // add `testDate` to the URL query string
    if (getTestDate() != null) {
      joiner.add(String.format("%stestDate%s=%s", prefix, suffix, URLEncoder.encode(ApiClient.valueToString(getTestDate()), StandardCharsets.UTF_8).replaceAll("\\+", "%20")));
    }

    // add `serviceId` to the URL query string
    if (getServiceId() != null) {
      joiner.add(String.format("%sserviceId%s=%s", prefix, suffix, URLEncoder.encode(ApiClient.valueToString(getServiceId()), StandardCharsets.UTF_8).replaceAll("\\+", "%20")));
    }

    // add `success` to the URL query string
    if (getSuccess() != null) {
      joiner.add(String.format("%ssuccess%s=%s", prefix, suffix, URLEncoder.encode(ApiClient.valueToString(getSuccess()), StandardCharsets.UTF_8).replaceAll("\\+", "%20")));
    }

    return joiner.toString();
  }
}

