/*
 * Microcks API v1.10
 * API offered by Microcks, the Kubernetes native tool for API and microservices mocking and testing (microcks.io)
 *
 * The version of the OpenAPI document: 1.10.0
 * Contact: laurent@microcks.io
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package io.github.microcks.client.model;

import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.StringJoiner;
import java.util.Objects;
import java.util.Map;
import java.util.HashMap;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import java.math.BigDecimal;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;


import io.github.microcks.client.ApiClient;
/**
 * TestStepResult is an entity embedded within TestCaseResult. They are created for each request associated with an operation / action of a microservice.
 */
@JsonPropertyOrder({
  TestStepResult.JSON_PROPERTY_SUCCESS,
  TestStepResult.JSON_PROPERTY_ELAPSED_TIME,
  TestStepResult.JSON_PROPERTY_REQUEST_NAME,
  TestStepResult.JSON_PROPERTY_MESSAGE,
  TestStepResult.JSON_PROPERTY_EVENT_MESSAGE_NAME
})
@jakarta.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2024-08-23T22:01:06.998198+02:00[Europe/Paris]", comments = "Generator version: 7.7.0")
public class TestStepResult {
  public static final String JSON_PROPERTY_SUCCESS = "success";
  private Boolean success;

  public static final String JSON_PROPERTY_ELAPSED_TIME = "elapsedTime";
  private BigDecimal elapsedTime;

  public static final String JSON_PROPERTY_REQUEST_NAME = "requestName";
  private String requestName;

  public static final String JSON_PROPERTY_MESSAGE = "message";
  private String message;

  public static final String JSON_PROPERTY_EVENT_MESSAGE_NAME = "eventMessageName";
  private String eventMessageName;

  public TestStepResult() { 
  }

  public TestStepResult success(Boolean success) {
    this.success = success;
    return this;
  }

  /**
   * Flag telling if test case is a success
   * @return success
   */
  @jakarta.annotation.Nonnull
  @JsonProperty(JSON_PROPERTY_SUCCESS)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public Boolean getSuccess() {
    return success;
  }


  @JsonProperty(JSON_PROPERTY_SUCCESS)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setSuccess(Boolean success) {
    this.success = success;
  }


  public TestStepResult elapsedTime(BigDecimal elapsedTime) {
    this.elapsedTime = elapsedTime;
    return this;
  }

  /**
   * Elapsed time in milliseconds since the test step beginning
   * @return elapsedTime
   */
  @jakarta.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_ELAPSED_TIME)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public BigDecimal getElapsedTime() {
    return elapsedTime;
  }


  @JsonProperty(JSON_PROPERTY_ELAPSED_TIME)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setElapsedTime(BigDecimal elapsedTime) {
    this.elapsedTime = elapsedTime;
  }


  public TestStepResult requestName(String requestName) {
    this.requestName = requestName;
    return this;
  }

  /**
   * Name of request this test step is bound to
   * @return requestName
   */
  @jakarta.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_REQUEST_NAME)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public String getRequestName() {
    return requestName;
  }


  @JsonProperty(JSON_PROPERTY_REQUEST_NAME)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setRequestName(String requestName) {
    this.requestName = requestName;
  }


  public TestStepResult message(String message) {
    this.message = message;
    return this;
  }

  /**
   * Error message that may be associated to this test step
   * @return message
   */
  @jakarta.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_MESSAGE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public String getMessage() {
    return message;
  }


  @JsonProperty(JSON_PROPERTY_MESSAGE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setMessage(String message) {
    this.message = message;
  }


  public TestStepResult eventMessageName(String eventMessageName) {
    this.eventMessageName = eventMessageName;
    return this;
  }

  /**
   * Name of event this test step is bound to
   * @return eventMessageName
   */
  @jakarta.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_EVENT_MESSAGE_NAME)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public String getEventMessageName() {
    return eventMessageName;
  }


  @JsonProperty(JSON_PROPERTY_EVENT_MESSAGE_NAME)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setEventMessageName(String eventMessageName) {
    this.eventMessageName = eventMessageName;
  }


  /**
   * Return true if this TestStepResult object is equal to o.
   */
  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    TestStepResult testStepResult = (TestStepResult) o;
    return Objects.equals(this.success, testStepResult.success) &&
        Objects.equals(this.elapsedTime, testStepResult.elapsedTime) &&
        Objects.equals(this.requestName, testStepResult.requestName) &&
        Objects.equals(this.message, testStepResult.message) &&
        Objects.equals(this.eventMessageName, testStepResult.eventMessageName);
  }

  @Override
  public int hashCode() {
    return Objects.hash(success, elapsedTime, requestName, message, eventMessageName);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class TestStepResult {\n");
    sb.append("    success: ").append(toIndentedString(success)).append("\n");
    sb.append("    elapsedTime: ").append(toIndentedString(elapsedTime)).append("\n");
    sb.append("    requestName: ").append(toIndentedString(requestName)).append("\n");
    sb.append("    message: ").append(toIndentedString(message)).append("\n");
    sb.append("    eventMessageName: ").append(toIndentedString(eventMessageName)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

  /**
   * Convert the instance into URL query string.
   *
   * @return URL query string
   */
  public String toUrlQueryString() {
    return toUrlQueryString(null);
  }

  /**
   * Convert the instance into URL query string.
   *
   * @param prefix prefix of the query string
   * @return URL query string
   */
  public String toUrlQueryString(String prefix) {
    String suffix = "";
    String containerSuffix = "";
    String containerPrefix = "";
    if (prefix == null) {
      // style=form, explode=true, e.g. /pet?name=cat&type=manx
      prefix = "";
    } else {
      // deepObject style e.g. /pet?id[name]=cat&id[type]=manx
      prefix = prefix + "[";
      suffix = "]";
      containerSuffix = "]";
      containerPrefix = "[";
    }

    StringJoiner joiner = new StringJoiner("&");

    // add `success` to the URL query string
    if (getSuccess() != null) {
      joiner.add(String.format("%ssuccess%s=%s", prefix, suffix, URLEncoder.encode(ApiClient.valueToString(getSuccess()), StandardCharsets.UTF_8).replaceAll("\\+", "%20")));
    }

    // add `elapsedTime` to the URL query string
    if (getElapsedTime() != null) {
      joiner.add(String.format("%selapsedTime%s=%s", prefix, suffix, URLEncoder.encode(ApiClient.valueToString(getElapsedTime()), StandardCharsets.UTF_8).replaceAll("\\+", "%20")));
    }

    // add `requestName` to the URL query string
    if (getRequestName() != null) {
      joiner.add(String.format("%srequestName%s=%s", prefix, suffix, URLEncoder.encode(ApiClient.valueToString(getRequestName()), StandardCharsets.UTF_8).replaceAll("\\+", "%20")));
    }

    // add `message` to the URL query string
    if (getMessage() != null) {
      joiner.add(String.format("%smessage%s=%s", prefix, suffix, URLEncoder.encode(ApiClient.valueToString(getMessage()), StandardCharsets.UTF_8).replaceAll("\\+", "%20")));
    }

    // add `eventMessageName` to the URL query string
    if (getEventMessageName() != null) {
      joiner.add(String.format("%seventMessageName%s=%s", prefix, suffix, URLEncoder.encode(ApiClient.valueToString(getEventMessageName()), StandardCharsets.UTF_8).replaceAll("\\+", "%20")));
    }

    return joiner.toString();
  }
}

