/*
 * Microcks API v1.10
 * API offered by Microcks, the Kubernetes native tool for API and microservices mocking and testing (microcks.io)
 *
 * The version of the OpenAPI document: 1.10.0
 * Contact: laurent@microcks.io
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package io.github.microcks.client.model;

import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.StringJoiner;
import java.util.Objects;
import java.util.Map;
import java.util.HashMap;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import io.github.microcks.client.model.EventMessage;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;


import io.github.microcks.client.ApiClient;
/**
 * Representation of an unidirectional exchange as an event message
 */
@JsonPropertyOrder({
  UnidirectionalEvent.JSON_PROPERTY_TYPE,
  UnidirectionalEvent.JSON_PROPERTY_EVENT_MESSAGE
})
@jakarta.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2024-08-23T22:01:06.998198+02:00[Europe/Paris]", comments = "Generator version: 7.7.0")
public class UnidirectionalEvent {
  /**
   * Discriminant type for identifying kind of exchange
   */
  public enum TypeEnum {
    REQ_RESP_PAIR("reqRespPair"),
    
    UNIDIR_EVENT("unidirEvent");

    private String value;

    TypeEnum(String value) {
      this.value = value;
    }

    @JsonValue
    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    @JsonCreator
    public static TypeEnum fromValue(String value) {
      for (TypeEnum b : TypeEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }
  }

  public static final String JSON_PROPERTY_TYPE = "type";
  private TypeEnum type;

  public static final String JSON_PROPERTY_EVENT_MESSAGE = "eventMessage";
  private EventMessage eventMessage;

  public UnidirectionalEvent() { 
  }

  public UnidirectionalEvent type(TypeEnum type) {
    this.type = type;
    return this;
  }

  /**
   * Discriminant type for identifying kind of exchange
   * @return type
   */
  @jakarta.annotation.Nonnull
  @JsonProperty(JSON_PROPERTY_TYPE)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public TypeEnum getType() {
    return type;
  }


  @JsonProperty(JSON_PROPERTY_TYPE)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setType(TypeEnum type) {
    this.type = type;
  }


  public UnidirectionalEvent eventMessage(EventMessage eventMessage) {
    this.eventMessage = eventMessage;
    return this;
  }

  /**
   * Get eventMessage
   * @return eventMessage
   */
  @jakarta.annotation.Nonnull
  @JsonProperty(JSON_PROPERTY_EVENT_MESSAGE)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public EventMessage getEventMessage() {
    return eventMessage;
  }


  @JsonProperty(JSON_PROPERTY_EVENT_MESSAGE)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setEventMessage(EventMessage eventMessage) {
    this.eventMessage = eventMessage;
  }


  /**
   * Return true if this UnidirectionalEvent object is equal to o.
   */
  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    UnidirectionalEvent unidirectionalEvent = (UnidirectionalEvent) o;
    return Objects.equals(this.type, unidirectionalEvent.type) &&
        Objects.equals(this.eventMessage, unidirectionalEvent.eventMessage);
  }

  @Override
  public int hashCode() {
    return Objects.hash(type, eventMessage);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class UnidirectionalEvent {\n");
    sb.append("    type: ").append(toIndentedString(type)).append("\n");
    sb.append("    eventMessage: ").append(toIndentedString(eventMessage)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

  /**
   * Convert the instance into URL query string.
   *
   * @return URL query string
   */
  public String toUrlQueryString() {
    return toUrlQueryString(null);
  }

  /**
   * Convert the instance into URL query string.
   *
   * @param prefix prefix of the query string
   * @return URL query string
   */
  public String toUrlQueryString(String prefix) {
    String suffix = "";
    String containerSuffix = "";
    String containerPrefix = "";
    if (prefix == null) {
      // style=form, explode=true, e.g. /pet?name=cat&type=manx
      prefix = "";
    } else {
      // deepObject style e.g. /pet?id[name]=cat&id[type]=manx
      prefix = prefix + "[";
      suffix = "]";
      containerSuffix = "]";
      containerPrefix = "[";
    }

    StringJoiner joiner = new StringJoiner("&");

    // add `type` to the URL query string
    if (getType() != null) {
      joiner.add(String.format("%stype%s=%s", prefix, suffix, URLEncoder.encode(ApiClient.valueToString(getType()), StandardCharsets.UTF_8).replaceAll("\\+", "%20")));
    }

    // add `eventMessage` to the URL query string
    if (getEventMessage() != null) {
      joiner.add(getEventMessage().toUrlQueryString(prefix + "eventMessage" + suffix));
    }

    return joiner.toString();
  }
}

