/*
 * Decompiled with CFR 0.152.
 */
package io.github.microcks.client.model;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import io.github.microcks.client.ApiClient;
import io.github.microcks.client.model.TestStepResult;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.math.BigDecimal;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.StringJoiner;

@JsonPropertyOrder(value={"success", "elapsedTime", "operationName", "testStepResults"})
public class TestCaseResult {
    public static final String JSON_PROPERTY_SUCCESS = "success";
    private Boolean success;
    public static final String JSON_PROPERTY_ELAPSED_TIME = "elapsedTime";
    private BigDecimal elapsedTime;
    public static final String JSON_PROPERTY_OPERATION_NAME = "operationName";
    private String operationName;
    public static final String JSON_PROPERTY_TEST_STEP_RESULTS = "testStepResults";
    private List<TestStepResult> testStepResults = new ArrayList<TestStepResult>();

    public TestCaseResult success(Boolean success) {
        this.success = success;
        return this;
    }

    @Nonnull
    @JsonProperty(value="success")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public Boolean getSuccess() {
        return this.success;
    }

    @JsonProperty(value="success")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setSuccess(Boolean success) {
        this.success = success;
    }

    public TestCaseResult elapsedTime(BigDecimal elapsedTime) {
        this.elapsedTime = elapsedTime;
        return this;
    }

    @Nonnull
    @JsonProperty(value="elapsedTime")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public BigDecimal getElapsedTime() {
        return this.elapsedTime;
    }

    @JsonProperty(value="elapsedTime")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setElapsedTime(BigDecimal elapsedTime) {
        this.elapsedTime = elapsedTime;
    }

    public TestCaseResult operationName(String operationName) {
        this.operationName = operationName;
        return this;
    }

    @Nonnull
    @JsonProperty(value="operationName")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getOperationName() {
        return this.operationName;
    }

    @JsonProperty(value="operationName")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setOperationName(String operationName) {
        this.operationName = operationName;
    }

    public TestCaseResult testStepResults(List<TestStepResult> testStepResults) {
        this.testStepResults = testStepResults;
        return this;
    }

    public TestCaseResult addTestStepResultsItem(TestStepResult testStepResultsItem) {
        if (this.testStepResults == null) {
            this.testStepResults = new ArrayList<TestStepResult>();
        }
        this.testStepResults.add(testStepResultsItem);
        return this;
    }

    @Nullable
    @JsonProperty(value="testStepResults")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<TestStepResult> getTestStepResults() {
        return this.testStepResults;
    }

    @JsonProperty(value="testStepResults")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setTestStepResults(List<TestStepResult> testStepResults) {
        this.testStepResults = testStepResults;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TestCaseResult testCaseResult = (TestCaseResult)o;
        return Objects.equals(this.success, testCaseResult.success) && Objects.equals(this.elapsedTime, testCaseResult.elapsedTime) && Objects.equals(this.operationName, testCaseResult.operationName) && Objects.equals(this.testStepResults, testCaseResult.testStepResults);
    }

    public int hashCode() {
        return Objects.hash(this.success, this.elapsedTime, this.operationName, this.testStepResults);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class TestCaseResult {\n");
        sb.append("    success: ").append(this.toIndentedString(this.success)).append("\n");
        sb.append("    elapsedTime: ").append(this.toIndentedString(this.elapsedTime)).append("\n");
        sb.append("    operationName: ").append(this.toIndentedString(this.operationName)).append("\n");
        sb.append("    testStepResults: ").append(this.toIndentedString(this.testStepResults)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public String toUrlQueryString() {
        return this.toUrlQueryString(null);
    }

    public String toUrlQueryString(String prefix) {
        String suffix = "";
        String containerSuffix = "";
        String containerPrefix = "";
        if (prefix == null) {
            prefix = "";
        } else {
            prefix = (String)prefix + "[";
            suffix = "]";
            containerSuffix = "]";
            containerPrefix = "[";
        }
        StringJoiner joiner = new StringJoiner("&");
        if (this.getSuccess() != null) {
            joiner.add(String.format("%ssuccess%s=%s", prefix, suffix, URLEncoder.encode(ApiClient.valueToString(this.getSuccess()), StandardCharsets.UTF_8).replaceAll("\\+", "%20")));
        }
        if (this.getElapsedTime() != null) {
            joiner.add(String.format("%selapsedTime%s=%s", prefix, suffix, URLEncoder.encode(ApiClient.valueToString(this.getElapsedTime()), StandardCharsets.UTF_8).replaceAll("\\+", "%20")));
        }
        if (this.getOperationName() != null) {
            joiner.add(String.format("%soperationName%s=%s", prefix, suffix, URLEncoder.encode(ApiClient.valueToString(this.getOperationName()), StandardCharsets.UTF_8).replaceAll("\\+", "%20")));
        }
        if (this.getTestStepResults() != null) {
            for (int i = 0; i < this.getTestStepResults().size(); ++i) {
                if (this.getTestStepResults().get(i) == null) continue;
                joiner.add(this.getTestStepResults().get(i).toUrlQueryString(String.format("%stestStepResults%s%s", prefix, suffix, "".equals(suffix) ? "" : String.format("%s%d%s", containerPrefix, i, containerSuffix))));
            }
        }
        return joiner.toString();
    }
}

