# openapi-java-client

Microcks API v1.10

- API version: 1.10.1

- Build date: 2025-01-06T15:57:00.387475551Z[Etc/UTC]

- Generator version: 7.7.0

API offered by Microcks, the Kubernetes native tool for API and microservices mocking and testing (microcks.io)

  For more information, please visit [https://github.com/microcks](https://github.com/microcks)

*Automatically generated by the [OpenAPI Generator](https://openapi-generator.tech)*

## Requirements

Building the API client library requires:

1. Java 11+
2. Maven/Gradle

## Installation

To install the API client library to your local Maven repository, simply execute:

```shell
mvn clean install
```

To deploy it to a remote Maven repository instead, configure the settings of the repository and execute:

```shell
mvn clean deploy
```

Refer to the [OSSRH Guide](http://central.sonatype.org/pages/ossrh-guide.html) for more information.

### Maven users

Add this dependency to your project's POM:

```xml
<dependency>
  <groupId>org.openapitools</groupId>
  <artifactId>openapi-java-client</artifactId>
  <version>1.10.1</version>
  <scope>compile</scope>
</dependency>
```

### Gradle users

Add this dependency to your project's build file:

```groovy
compile "org.openapitools:openapi-java-client:1.10.1"
```

### Others

At first generate the JAR by executing:

```shell
mvn clean package
```

Then manually install the following JARs:

- `target/openapi-java-client-1.10.1.jar`
- `target/lib/*.jar`

## Getting Started

Please follow the [installation](#installation) instruction and execute the following Java code:

```java

import io.github.microcks.client.*;
import io.github.microcks.client.model.*;
import io.github.microcks.client.api.ConfigApi;

public class ConfigApiExample {

    public static void main(String[] args) {
        ApiClient defaultClient = Configuration.getDefaultApiClient();
        // Configure clients using the `defaultClient` object, such as
        // overriding the host and port, timeout, etc.
        ConfigApi apiInstance = new ConfigApi(defaultClient);
        Secret secret = new Secret(); // Secret | 
        try {
            Secret result = apiInstance.createSecret(secret);
            System.out.println(result);
        } catch (ApiException e) {
            System.err.println("Exception when calling ConfigApi#createSecret");
            System.err.println("Status code: " + e.getCode());
            System.err.println("Reason: " + e.getResponseBody());
            System.err.println("Response headers: " + e.getResponseHeaders());
            e.printStackTrace();
        }
    }
}

```

## Documentation for API Endpoints

All URIs are relative to *http://microcks.example.com/api*

Class | Method | HTTP request | Description
------------ | ------------- | ------------- | -------------
*ConfigApi* | [**createSecret**](docs/ConfigApi.md#createSecret) | **POST** /secrets | Create a new Secret
*ConfigApi* | [**createSecretWithHttpInfo**](docs/ConfigApi.md#createSecretWithHttpInfo) | **POST** /secrets | Create a new Secret
*ConfigApi* | [**deleteSecret**](docs/ConfigApi.md#deleteSecret) | **DELETE** /secrets/{id} | Delete Secret
*ConfigApi* | [**deleteSecretWithHttpInfo**](docs/ConfigApi.md#deleteSecretWithHttpInfo) | **DELETE** /secrets/{id} | Delete Secret
*ConfigApi* | [**getFeaturesConfig**](docs/ConfigApi.md#getFeaturesConfig) | **GET** /features/config | Get features configuration
*ConfigApi* | [**getFeaturesConfigWithHttpInfo**](docs/ConfigApi.md#getFeaturesConfigWithHttpInfo) | **GET** /features/config | Get features configuration
*ConfigApi* | [**getKeycloakConfig**](docs/ConfigApi.md#getKeycloakConfig) | **GET** /keycloak/config | Get authentification configuration
*ConfigApi* | [**getKeycloakConfigWithHttpInfo**](docs/ConfigApi.md#getKeycloakConfigWithHttpInfo) | **GET** /keycloak/config | Get authentification configuration
*ConfigApi* | [**getSecret**](docs/ConfigApi.md#getSecret) | **GET** /secrets/{id} | Get Secret
*ConfigApi* | [**getSecretWithHttpInfo**](docs/ConfigApi.md#getSecretWithHttpInfo) | **GET** /secrets/{id} | Get Secret
*ConfigApi* | [**getSecrets**](docs/ConfigApi.md#getSecrets) | **GET** /secrets | Get Secrets
*ConfigApi* | [**getSecretsWithHttpInfo**](docs/ConfigApi.md#getSecretsWithHttpInfo) | **GET** /secrets | Get Secrets
*ConfigApi* | [**getSecretsCounter**](docs/ConfigApi.md#getSecretsCounter) | **GET** /secrets/count | Get the Secrets counter
*ConfigApi* | [**getSecretsCounterWithHttpInfo**](docs/ConfigApi.md#getSecretsCounterWithHttpInfo) | **GET** /secrets/count | Get the Secrets counter
*ConfigApi* | [**searchSecrets**](docs/ConfigApi.md#searchSecrets) | **GET** /secrets/search | Search for Secrets
*ConfigApi* | [**searchSecretsWithHttpInfo**](docs/ConfigApi.md#searchSecretsWithHttpInfo) | **GET** /secrets/search | Search for Secrets
*ConfigApi* | [**updateSecret**](docs/ConfigApi.md#updateSecret) | **PUT** /secrets/{id} | Update Secret
*ConfigApi* | [**updateSecretWithHttpInfo**](docs/ConfigApi.md#updateSecretWithHttpInfo) | **PUT** /secrets/{id} | Update Secret
*DefaultApi* | [**getResource**](docs/DefaultApi.md#getResource) | **GET** /resources/{name} | Get Resource
*DefaultApi* | [**getResourceWithHttpInfo**](docs/DefaultApi.md#getResourceWithHttpInfo) | **GET** /resources/{name} | Get Resource
*DefaultApi* | [**getResourcesByService**](docs/DefaultApi.md#getResourcesByService) | **GET** /resources/service/{serviceId} | Get Resources by Service
*DefaultApi* | [**getResourcesByServiceWithHttpInfo**](docs/DefaultApi.md#getResourcesByServiceWithHttpInfo) | **GET** /resources/service/{serviceId} | Get Resources by Service
*JobApi* | [**activateImportJob**](docs/JobApi.md#activateImportJob) | **PUT** /jobs/{id}/activate | Activate an ImportJob
*JobApi* | [**activateImportJobWithHttpInfo**](docs/JobApi.md#activateImportJobWithHttpInfo) | **PUT** /jobs/{id}/activate | Activate an ImportJob
*JobApi* | [**createImportJob**](docs/JobApi.md#createImportJob) | **POST** /jobs | Create ImportJob
*JobApi* | [**createImportJobWithHttpInfo**](docs/JobApi.md#createImportJobWithHttpInfo) | **POST** /jobs | Create ImportJob
*JobApi* | [**deleteImportJob**](docs/JobApi.md#deleteImportJob) | **DELETE** /jobs/{id} | Delete ImportJob
*JobApi* | [**deleteImportJobWithHttpInfo**](docs/JobApi.md#deleteImportJobWithHttpInfo) | **DELETE** /jobs/{id} | Delete ImportJob
*JobApi* | [**downloadArtifact**](docs/JobApi.md#downloadArtifact) | **POST** /artifact/download | Download an artifact
*JobApi* | [**downloadArtifactWithHttpInfo**](docs/JobApi.md#downloadArtifactWithHttpInfo) | **POST** /artifact/download | Download an artifact
*JobApi* | [**getImportJob**](docs/JobApi.md#getImportJob) | **GET** /jobs/{id} | Get ImportJob
*JobApi* | [**getImportJobWithHttpInfo**](docs/JobApi.md#getImportJobWithHttpInfo) | **GET** /jobs/{id} | Get ImportJob
*JobApi* | [**getImportJobCounter**](docs/JobApi.md#getImportJobCounter) | **GET** /jobs/count | Get the ImportJobs counter
*JobApi* | [**getImportJobCounterWithHttpInfo**](docs/JobApi.md#getImportJobCounterWithHttpInfo) | **GET** /jobs/count | Get the ImportJobs counter
*JobApi* | [**getImportJobs**](docs/JobApi.md#getImportJobs) | **GET** /jobs | Get ImportJobs
*JobApi* | [**getImportJobsWithHttpInfo**](docs/JobApi.md#getImportJobsWithHttpInfo) | **GET** /jobs | Get ImportJobs
*JobApi* | [**startImportJob**](docs/JobApi.md#startImportJob) | **PUT** /jobs/{id}/start | Start an ImportJob
*JobApi* | [**startImportJobWithHttpInfo**](docs/JobApi.md#startImportJobWithHttpInfo) | **PUT** /jobs/{id}/start | Start an ImportJob
*JobApi* | [**stopImportJob**](docs/JobApi.md#stopImportJob) | **PUT** /jobs/{id}/stop | Stop an ImportJob
*JobApi* | [**stopImportJobWithHttpInfo**](docs/JobApi.md#stopImportJobWithHttpInfo) | **PUT** /jobs/{id}/stop | Stop an ImportJob
*JobApi* | [**updateImportJob**](docs/JobApi.md#updateImportJob) | **POST** /jobs/{id} | Update ImportJob
*JobApi* | [**updateImportJobWithHttpInfo**](docs/JobApi.md#updateImportJobWithHttpInfo) | **POST** /jobs/{id} | Update ImportJob
*JobApi* | [**uploadArtifact**](docs/JobApi.md#uploadArtifact) | **POST** /artifact/upload | Upload an artifact
*JobApi* | [**uploadArtifactWithHttpInfo**](docs/JobApi.md#uploadArtifactWithHttpInfo) | **POST** /artifact/upload | Upload an artifact
*MetricsApi* | [**getAggregatedInvocationsStats**](docs/MetricsApi.md#getAggregatedInvocationsStats) | **GET** /metrics/invocations/global | Get aggregated invocation statistics for a day
*MetricsApi* | [**getAggregatedInvocationsStatsWithHttpInfo**](docs/MetricsApi.md#getAggregatedInvocationsStatsWithHttpInfo) | **GET** /metrics/invocations/global | Get aggregated invocation statistics for a day
*MetricsApi* | [**getConformanceMetricsAggregation**](docs/MetricsApi.md#getConformanceMetricsAggregation) | **GET** /metrics/conformance/aggregate | Get aggregation of conformance metrics
*MetricsApi* | [**getConformanceMetricsAggregationWithHttpInfo**](docs/MetricsApi.md#getConformanceMetricsAggregationWithHttpInfo) | **GET** /metrics/conformance/aggregate | Get aggregation of conformance metrics
*MetricsApi* | [**getInvocationStatsByService**](docs/MetricsApi.md#getInvocationStatsByService) | **GET** /metrics/invocations/{serviceName}/{serviceVersion} | Get invocation statistics for Service
*MetricsApi* | [**getInvocationStatsByServiceWithHttpInfo**](docs/MetricsApi.md#getInvocationStatsByServiceWithHttpInfo) | **GET** /metrics/invocations/{serviceName}/{serviceVersion} | Get invocation statistics for Service
*MetricsApi* | [**getLatestAggregatedInvocationsStats**](docs/MetricsApi.md#getLatestAggregatedInvocationsStats) | **GET** /metrics/invocations/global/latest | Get aggregated invocations statistics for latest days
*MetricsApi* | [**getLatestAggregatedInvocationsStatsWithHttpInfo**](docs/MetricsApi.md#getLatestAggregatedInvocationsStatsWithHttpInfo) | **GET** /metrics/invocations/global/latest | Get aggregated invocations statistics for latest days
*MetricsApi* | [**getLatestTestResults**](docs/MetricsApi.md#getLatestTestResults) | **GET** /metrics/tests/latest | Get latest tests results
*MetricsApi* | [**getLatestTestResultsWithHttpInfo**](docs/MetricsApi.md#getLatestTestResultsWithHttpInfo) | **GET** /metrics/tests/latest | Get latest tests results
*MetricsApi* | [**getServiceTestConformanceMetric**](docs/MetricsApi.md#getServiceTestConformanceMetric) | **GET** /metrics/conformance/service/{serviceId} | Get conformance metrics for a Service
*MetricsApi* | [**getServiceTestConformanceMetricWithHttpInfo**](docs/MetricsApi.md#getServiceTestConformanceMetricWithHttpInfo) | **GET** /metrics/conformance/service/{serviceId} | Get conformance metrics for a Service
*MetricsApi* | [**getTopIvnocationsStatsByDay**](docs/MetricsApi.md#getTopIvnocationsStatsByDay) | **GET** /metrics/invocations/top | Get top invocation statistics for a day
*MetricsApi* | [**getTopIvnocationsStatsByDayWithHttpInfo**](docs/MetricsApi.md#getTopIvnocationsStatsByDayWithHttpInfo) | **GET** /metrics/invocations/top | Get top invocation statistics for a day
*MockApi* | [**deleteService**](docs/MockApi.md#deleteService) | **DELETE** /services/{id} | Delete Service
*MockApi* | [**deleteServiceWithHttpInfo**](docs/MockApi.md#deleteServiceWithHttpInfo) | **DELETE** /services/{id} | Delete Service
*MockApi* | [**exportSnapshot**](docs/MockApi.md#exportSnapshot) | **GET** /export | Export a snapshot
*MockApi* | [**exportSnapshotWithHttpInfo**](docs/MockApi.md#exportSnapshotWithHttpInfo) | **GET** /export | Export a snapshot
*MockApi* | [**getService**](docs/MockApi.md#getService) | **GET** /services/{id} | Get Service
*MockApi* | [**getServiceWithHttpInfo**](docs/MockApi.md#getServiceWithHttpInfo) | **GET** /services/{id} | Get Service
*MockApi* | [**getServices**](docs/MockApi.md#getServices) | **GET** /services | Get Services and APIs
*MockApi* | [**getServicesWithHttpInfo**](docs/MockApi.md#getServicesWithHttpInfo) | **GET** /services | Get Services and APIs
*MockApi* | [**getServicesCounter**](docs/MockApi.md#getServicesCounter) | **GET** /services/count | Get the Services counter
*MockApi* | [**getServicesCounterWithHttpInfo**](docs/MockApi.md#getServicesCounterWithHttpInfo) | **GET** /services/count | Get the Services counter
*MockApi* | [**getServicesLabels**](docs/MockApi.md#getServicesLabels) | **GET** /services/labels | Get the already used labels for Services
*MockApi* | [**getServicesLabelsWithHttpInfo**](docs/MockApi.md#getServicesLabelsWithHttpInfo) | **GET** /services/labels | Get the already used labels for Services
*MockApi* | [**importSnapshot**](docs/MockApi.md#importSnapshot) | **POST** /import | Import a snapshot
*MockApi* | [**importSnapshotWithHttpInfo**](docs/MockApi.md#importSnapshotWithHttpInfo) | **POST** /import | Import a snapshot
*MockApi* | [**overrideServiceOperation**](docs/MockApi.md#overrideServiceOperation) | **PUT** /services/{id}/operation | Override Service Operation
*MockApi* | [**overrideServiceOperationWithHttpInfo**](docs/MockApi.md#overrideServiceOperationWithHttpInfo) | **PUT** /services/{id}/operation | Override Service Operation
*MockApi* | [**searchServices**](docs/MockApi.md#searchServices) | **GET** /services/search | Search for Services and APIs
*MockApi* | [**searchServicesWithHttpInfo**](docs/MockApi.md#searchServicesWithHttpInfo) | **GET** /services/search | Search for Services and APIs
*MockApi* | [**updateServiceMetadata**](docs/MockApi.md#updateServiceMetadata) | **PUT** /services/{id}/metadata | Update Service Metadata
*MockApi* | [**updateServiceMetadataWithHttpInfo**](docs/MockApi.md#updateServiceMetadataWithHttpInfo) | **PUT** /services/{id}/metadata | Update Service Metadata
*TestApi* | [**createTest**](docs/TestApi.md#createTest) | **POST** /tests | Create a new Test
*TestApi* | [**createTestWithHttpInfo**](docs/TestApi.md#createTestWithHttpInfo) | **POST** /tests | Create a new Test
*TestApi* | [**getEventsByTestCase**](docs/TestApi.md#getEventsByTestCase) | **GET** /tests/{id}/events/{testCaseId} | Get events for TestCase
*TestApi* | [**getEventsByTestCaseWithHttpInfo**](docs/TestApi.md#getEventsByTestCaseWithHttpInfo) | **GET** /tests/{id}/events/{testCaseId} | Get events for TestCase
*TestApi* | [**getMessagesByTestCase**](docs/TestApi.md#getMessagesByTestCase) | **GET** /tests/{id}/messages/{testCaseId} | Get messages for TestCase
*TestApi* | [**getMessagesByTestCaseWithHttpInfo**](docs/TestApi.md#getMessagesByTestCaseWithHttpInfo) | **GET** /tests/{id}/messages/{testCaseId} | Get messages for TestCase
*TestApi* | [**getTestResult**](docs/TestApi.md#getTestResult) | **GET** /tests/{id} | Get TestResult
*TestApi* | [**getTestResultWithHttpInfo**](docs/TestApi.md#getTestResultWithHttpInfo) | **GET** /tests/{id} | Get TestResult
*TestApi* | [**getTestResultsByService**](docs/TestApi.md#getTestResultsByService) | **GET** /tests/service/{serviceId} | Get TestResults by Service
*TestApi* | [**getTestResultsByServiceWithHttpInfo**](docs/TestApi.md#getTestResultsByServiceWithHttpInfo) | **GET** /tests/service/{serviceId} | Get TestResults by Service
*TestApi* | [**getTestResultsByServiceCounter**](docs/TestApi.md#getTestResultsByServiceCounter) | **GET** /tests/service/{serviceId}/count | Get the TestResults for Service counter
*TestApi* | [**getTestResultsByServiceCounterWithHttpInfo**](docs/TestApi.md#getTestResultsByServiceCounterWithHttpInfo) | **GET** /tests/service/{serviceId}/count | Get the TestResults for Service counter
*TestApi* | [**reportTestCaseResult**](docs/TestApi.md#reportTestCaseResult) | **POST** /tests/{id}/testCaseResult | Report and create a new TestCaseResult
*TestApi* | [**reportTestCaseResultWithHttpInfo**](docs/TestApi.md#reportTestCaseResultWithHttpInfo) | **POST** /tests/{id}/testCaseResult | Report and create a new TestCaseResult


## Documentation for Models

 - [AbstractExchange](docs/AbstractExchange.md)
 - [Binding](docs/Binding.md)
 - [Counter](docs/Counter.md)
 - [DailyInvocationStatistic](docs/DailyInvocationStatistic.md)
 - [EventMessage](docs/EventMessage.md)
 - [Exchange](docs/Exchange.md)
 - [FeaturesConfig](docs/FeaturesConfig.md)
 - [FeaturesConfigAsyncApi](docs/FeaturesConfigAsyncApi.md)
 - [FeaturesConfigMicrocksHub](docs/FeaturesConfigMicrocksHub.md)
 - [FeaturesConfigRepositoryFilter](docs/FeaturesConfigRepositoryFilter.md)
 - [FeaturesConfigRepositoryTenancy](docs/FeaturesConfigRepositoryTenancy.md)
 - [GetService200Response](docs/GetService200Response.md)
 - [Header](docs/Header.md)
 - [HeaderDTO](docs/HeaderDTO.md)
 - [ImportJob](docs/ImportJob.md)
 - [KeycloakConfig](docs/KeycloakConfig.md)
 - [Metadata](docs/Metadata.md)
 - [OAuth2AuthorizedClient](docs/OAuth2AuthorizedClient.md)
 - [OAuth2ClientContent](docs/OAuth2ClientContent.md)
 - [OAuth2GrantType](docs/OAuth2GrantType.md)
 - [Operation](docs/Operation.md)
 - [OperationOverrideDTO](docs/OperationOverrideDTO.md)
 - [ParameterConstraint](docs/ParameterConstraint.md)
 - [Request](docs/Request.md)
 - [RequestResponsePair](docs/RequestResponsePair.md)
 - [Resource](docs/Resource.md)
 - [ResourceType](docs/ResourceType.md)
 - [Response](docs/Response.md)
 - [Secret](docs/Secret.md)
 - [SecretRef](docs/SecretRef.md)
 - [Service](docs/Service.md)
 - [ServiceRef](docs/ServiceRef.md)
 - [ServiceView](docs/ServiceView.md)
 - [TestCaseResult](docs/TestCaseResult.md)
 - [TestCaseReturnDTO](docs/TestCaseReturnDTO.md)
 - [TestConformanceMetric](docs/TestConformanceMetric.md)
 - [TestRequest](docs/TestRequest.md)
 - [TestResult](docs/TestResult.md)
 - [TestResultSummary](docs/TestResultSummary.md)
 - [TestReturn](docs/TestReturn.md)
 - [TestRunnerType](docs/TestRunnerType.md)
 - [TestStepResult](docs/TestStepResult.md)
 - [Trend](docs/Trend.md)
 - [UnidirectionalEvent](docs/UnidirectionalEvent.md)
 - [WeightedMetricValue](docs/WeightedMetricValue.md)


<a id="documentation-for-authorization"></a>
## Documentation for Authorization


Authentication schemes defined for the API:
<a id="jwt-bearer"></a>
### jwt-bearer


- **Type**: OAuth
- **Flow**: application
- **Authorization URL**: 
- **Scopes**: 
  - user: Simple authenticated user
  - manager: Services &amp; APIs content manager
  - admin: Administrator of the Microcks instance


## Recommendation

It's recommended to create an instance of `ApiClient` per thread in a multithreaded environment to avoid any potential issues.
However, the instances of the api clients created from the `ApiClient` are thread-safe and can be re-used.

## Author

laurent@microcks.io

