/*
 * Microcks API v1.10
 * API offered by Microcks, the Kubernetes native tool for API and microservices mocking and testing (microcks.io)
 *
 * The version of the OpenAPI document: 1.10.1
 * Contact: laurent@microcks.io
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

package io.github.microcks.client.api;

import io.github.microcks.client.ApiClient;
import io.github.microcks.client.ApiException;
import io.github.microcks.client.ApiResponse;
import io.github.microcks.client.Pair;

import java.math.BigDecimal;
import io.github.microcks.client.model.DailyInvocationStatistic;
import io.github.microcks.client.model.TestConformanceMetric;
import io.github.microcks.client.model.TestResultSummary;
import io.github.microcks.client.model.WeightedMetricValue;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;

import org.apache.http.HttpEntity;
import org.apache.http.NameValuePair;
import org.apache.http.entity.mime.MultipartEntityBuilder;
import org.apache.http.message.BasicNameValuePair;
import org.apache.http.client.entity.UrlEncodedFormEntity;

import java.io.InputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.net.http.HttpRequest;
import java.nio.channels.Channels;
import java.nio.channels.Pipe;
import java.net.URI;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.time.Duration;

import java.util.ArrayList;
import java.util.StringJoiner;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;

@jakarta.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2025-01-06T15:57:00.387475551Z[Etc/UTC]", comments = "Generator version: 7.7.0")
public class MetricsApi {
  private final HttpClient memberVarHttpClient;
  private final ObjectMapper memberVarObjectMapper;
  private final String memberVarBaseUri;
  private final Consumer<HttpRequest.Builder> memberVarInterceptor;
  private final Duration memberVarReadTimeout;
  private final Consumer<HttpResponse<InputStream>> memberVarResponseInterceptor;
  private final Consumer<HttpResponse<String>> memberVarAsyncResponseInterceptor;

  public MetricsApi() {
    this(new ApiClient());
  }

  public MetricsApi(ApiClient apiClient) {
    memberVarHttpClient = apiClient.getHttpClient();
    memberVarObjectMapper = apiClient.getObjectMapper();
    memberVarBaseUri = apiClient.getBaseUri();
    memberVarInterceptor = apiClient.getRequestInterceptor();
    memberVarReadTimeout = apiClient.getReadTimeout();
    memberVarResponseInterceptor = apiClient.getResponseInterceptor();
    memberVarAsyncResponseInterceptor = apiClient.getAsyncResponseInterceptor();
  }

  protected ApiException getApiException(String operationId, HttpResponse<InputStream> response) throws IOException {
    String body = response.body() == null ? null : new String(response.body().readAllBytes());
    String message = formatExceptionMessage(operationId, response.statusCode(), body);
    return new ApiException(response.statusCode(), message, response.headers(), body);
  }

  private String formatExceptionMessage(String operationId, int statusCode, String body) {
    if (body == null || body.isEmpty()) {
      body = "[no body]";
    }
    return operationId + " call failed with: " + statusCode + " - " + body;
  }

  /**
   * Get aggregated invocation statistics for a day
   * 
   * @param day The day to get statistics for (formatted with yyyyMMdd pattern). Default to today if not provided. (optional)
   * @return DailyInvocationStatistic
   * @throws ApiException if fails to make API call
   */
  public DailyInvocationStatistic getAggregatedInvocationsStats(String day) throws ApiException {
    ApiResponse<DailyInvocationStatistic> localVarResponse = getAggregatedInvocationsStatsWithHttpInfo(day);
    return localVarResponse.getData();
  }

  /**
   * Get aggregated invocation statistics for a day
   * 
   * @param day The day to get statistics for (formatted with yyyyMMdd pattern). Default to today if not provided. (optional)
   * @return ApiResponse&lt;DailyInvocationStatistic&gt;
   * @throws ApiException if fails to make API call
   */
  public ApiResponse<DailyInvocationStatistic> getAggregatedInvocationsStatsWithHttpInfo(String day) throws ApiException {
    HttpRequest.Builder localVarRequestBuilder = getAggregatedInvocationsStatsRequestBuilder(day);
    try {
      HttpResponse<InputStream> localVarResponse = memberVarHttpClient.send(
          localVarRequestBuilder.build(),
          HttpResponse.BodyHandlers.ofInputStream());
      if (memberVarResponseInterceptor != null) {
        memberVarResponseInterceptor.accept(localVarResponse);
      }
      try {
        if (localVarResponse.statusCode()/ 100 != 2) {
          throw getApiException("getAggregatedInvocationsStats", localVarResponse);
        }
        return new ApiResponse<DailyInvocationStatistic>(
          localVarResponse.statusCode(),
          localVarResponse.headers().map(),
          localVarResponse.body() == null ? null : memberVarObjectMapper.readValue(localVarResponse.body(), new TypeReference<DailyInvocationStatistic>() {}) // closes the InputStream
        );
      } finally {
      }
    } catch (IOException e) {
      throw new ApiException(e);
    }
    catch (InterruptedException e) {
      Thread.currentThread().interrupt();
      throw new ApiException(e);
    }
  }

  private HttpRequest.Builder getAggregatedInvocationsStatsRequestBuilder(String day) throws ApiException {

    HttpRequest.Builder localVarRequestBuilder = HttpRequest.newBuilder();

    String localVarPath = "/metrics/invocations/global";

    List<Pair> localVarQueryParams = new ArrayList<>();
    StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
    String localVarQueryParameterBaseName;
    localVarQueryParameterBaseName = "day";
    localVarQueryParams.addAll(ApiClient.parameterToPairs("day", day));

    if (!localVarQueryParams.isEmpty() || localVarQueryStringJoiner.length() != 0) {
      StringJoiner queryJoiner = new StringJoiner("&");
      localVarQueryParams.forEach(p -> queryJoiner.add(p.getName() + '=' + p.getValue()));
      if (localVarQueryStringJoiner.length() != 0) {
        queryJoiner.add(localVarQueryStringJoiner.toString());
      }
      localVarRequestBuilder.uri(URI.create(memberVarBaseUri + localVarPath + '?' + queryJoiner.toString()));
    } else {
      localVarRequestBuilder.uri(URI.create(memberVarBaseUri + localVarPath));
    }

    localVarRequestBuilder.header("Accept", "application/json");

    localVarRequestBuilder.method("GET", HttpRequest.BodyPublishers.noBody());
    if (memberVarReadTimeout != null) {
      localVarRequestBuilder.timeout(memberVarReadTimeout);
    }
    if (memberVarInterceptor != null) {
      memberVarInterceptor.accept(localVarRequestBuilder);
    }
    return localVarRequestBuilder;
  }

  /**
   * Get aggregation of conformance metrics
   * 
   * @return List&lt;WeightedMetricValue&gt;
   * @throws ApiException if fails to make API call
   */
  public List<WeightedMetricValue> getConformanceMetricsAggregation() throws ApiException {
    ApiResponse<List<WeightedMetricValue>> localVarResponse = getConformanceMetricsAggregationWithHttpInfo();
    return localVarResponse.getData();
  }

  /**
   * Get aggregation of conformance metrics
   * 
   * @return ApiResponse&lt;List&lt;WeightedMetricValue&gt;&gt;
   * @throws ApiException if fails to make API call
   */
  public ApiResponse<List<WeightedMetricValue>> getConformanceMetricsAggregationWithHttpInfo() throws ApiException {
    HttpRequest.Builder localVarRequestBuilder = getConformanceMetricsAggregationRequestBuilder();
    try {
      HttpResponse<InputStream> localVarResponse = memberVarHttpClient.send(
          localVarRequestBuilder.build(),
          HttpResponse.BodyHandlers.ofInputStream());
      if (memberVarResponseInterceptor != null) {
        memberVarResponseInterceptor.accept(localVarResponse);
      }
      try {
        if (localVarResponse.statusCode()/ 100 != 2) {
          throw getApiException("getConformanceMetricsAggregation", localVarResponse);
        }
        return new ApiResponse<List<WeightedMetricValue>>(
          localVarResponse.statusCode(),
          localVarResponse.headers().map(),
          localVarResponse.body() == null ? null : memberVarObjectMapper.readValue(localVarResponse.body(), new TypeReference<List<WeightedMetricValue>>() {}) // closes the InputStream
        );
      } finally {
      }
    } catch (IOException e) {
      throw new ApiException(e);
    }
    catch (InterruptedException e) {
      Thread.currentThread().interrupt();
      throw new ApiException(e);
    }
  }

  private HttpRequest.Builder getConformanceMetricsAggregationRequestBuilder() throws ApiException {

    HttpRequest.Builder localVarRequestBuilder = HttpRequest.newBuilder();

    String localVarPath = "/metrics/conformance/aggregate";

    localVarRequestBuilder.uri(URI.create(memberVarBaseUri + localVarPath));

    localVarRequestBuilder.header("Accept", "application/json");

    localVarRequestBuilder.method("GET", HttpRequest.BodyPublishers.noBody());
    if (memberVarReadTimeout != null) {
      localVarRequestBuilder.timeout(memberVarReadTimeout);
    }
    if (memberVarInterceptor != null) {
      memberVarInterceptor.accept(localVarRequestBuilder);
    }
    return localVarRequestBuilder;
  }

  /**
   * Get invocation statistics for Service
   * 
   * @param serviceName Name of service to get statistics for (required)
   * @param serviceVersion Version of service to get statistics for (required)
   * @param day The day to get statistics for (formatted with yyyyMMdd pattern). Default to today if not provided. (optional)
   * @return DailyInvocationStatistic
   * @throws ApiException if fails to make API call
   */
  public DailyInvocationStatistic getInvocationStatsByService(String serviceName, String serviceVersion, String day) throws ApiException {
    ApiResponse<DailyInvocationStatistic> localVarResponse = getInvocationStatsByServiceWithHttpInfo(serviceName, serviceVersion, day);
    return localVarResponse.getData();
  }

  /**
   * Get invocation statistics for Service
   * 
   * @param serviceName Name of service to get statistics for (required)
   * @param serviceVersion Version of service to get statistics for (required)
   * @param day The day to get statistics for (formatted with yyyyMMdd pattern). Default to today if not provided. (optional)
   * @return ApiResponse&lt;DailyInvocationStatistic&gt;
   * @throws ApiException if fails to make API call
   */
  public ApiResponse<DailyInvocationStatistic> getInvocationStatsByServiceWithHttpInfo(String serviceName, String serviceVersion, String day) throws ApiException {
    HttpRequest.Builder localVarRequestBuilder = getInvocationStatsByServiceRequestBuilder(serviceName, serviceVersion, day);
    try {
      HttpResponse<InputStream> localVarResponse = memberVarHttpClient.send(
          localVarRequestBuilder.build(),
          HttpResponse.BodyHandlers.ofInputStream());
      if (memberVarResponseInterceptor != null) {
        memberVarResponseInterceptor.accept(localVarResponse);
      }
      try {
        if (localVarResponse.statusCode()/ 100 != 2) {
          throw getApiException("getInvocationStatsByService", localVarResponse);
        }
        return new ApiResponse<DailyInvocationStatistic>(
          localVarResponse.statusCode(),
          localVarResponse.headers().map(),
          localVarResponse.body() == null ? null : memberVarObjectMapper.readValue(localVarResponse.body(), new TypeReference<DailyInvocationStatistic>() {}) // closes the InputStream
        );
      } finally {
      }
    } catch (IOException e) {
      throw new ApiException(e);
    }
    catch (InterruptedException e) {
      Thread.currentThread().interrupt();
      throw new ApiException(e);
    }
  }

  private HttpRequest.Builder getInvocationStatsByServiceRequestBuilder(String serviceName, String serviceVersion, String day) throws ApiException {
    // verify the required parameter 'serviceName' is set
    if (serviceName == null) {
      throw new ApiException(400, "Missing the required parameter 'serviceName' when calling getInvocationStatsByService");
    }
    // verify the required parameter 'serviceVersion' is set
    if (serviceVersion == null) {
      throw new ApiException(400, "Missing the required parameter 'serviceVersion' when calling getInvocationStatsByService");
    }

    HttpRequest.Builder localVarRequestBuilder = HttpRequest.newBuilder();

    String localVarPath = "/metrics/invocations/{serviceName}/{serviceVersion}"
        .replace("{serviceName}", ApiClient.urlEncode(serviceName.toString()))
        .replace("{serviceVersion}", ApiClient.urlEncode(serviceVersion.toString()));

    List<Pair> localVarQueryParams = new ArrayList<>();
    StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
    String localVarQueryParameterBaseName;
    localVarQueryParameterBaseName = "day";
    localVarQueryParams.addAll(ApiClient.parameterToPairs("day", day));

    if (!localVarQueryParams.isEmpty() || localVarQueryStringJoiner.length() != 0) {
      StringJoiner queryJoiner = new StringJoiner("&");
      localVarQueryParams.forEach(p -> queryJoiner.add(p.getName() + '=' + p.getValue()));
      if (localVarQueryStringJoiner.length() != 0) {
        queryJoiner.add(localVarQueryStringJoiner.toString());
      }
      localVarRequestBuilder.uri(URI.create(memberVarBaseUri + localVarPath + '?' + queryJoiner.toString()));
    } else {
      localVarRequestBuilder.uri(URI.create(memberVarBaseUri + localVarPath));
    }

    localVarRequestBuilder.header("Accept", "application/json");

    localVarRequestBuilder.method("GET", HttpRequest.BodyPublishers.noBody());
    if (memberVarReadTimeout != null) {
      localVarRequestBuilder.timeout(memberVarReadTimeout);
    }
    if (memberVarInterceptor != null) {
      memberVarInterceptor.accept(localVarRequestBuilder);
    }
    return localVarRequestBuilder;
  }

  /**
   * Get aggregated invocations statistics for latest days
   * 
   * @param limit Number of days to get back in time. Default is 20. (optional)
   * @return Map&lt;String, BigDecimal&gt;
   * @throws ApiException if fails to make API call
   */
  public Map<String, BigDecimal> getLatestAggregatedInvocationsStats(Integer limit) throws ApiException {
    ApiResponse<Map<String, BigDecimal>> localVarResponse = getLatestAggregatedInvocationsStatsWithHttpInfo(limit);
    return localVarResponse.getData();
  }

  /**
   * Get aggregated invocations statistics for latest days
   * 
   * @param limit Number of days to get back in time. Default is 20. (optional)
   * @return ApiResponse&lt;Map&lt;String, BigDecimal&gt;&gt;
   * @throws ApiException if fails to make API call
   */
  public ApiResponse<Map<String, BigDecimal>> getLatestAggregatedInvocationsStatsWithHttpInfo(Integer limit) throws ApiException {
    HttpRequest.Builder localVarRequestBuilder = getLatestAggregatedInvocationsStatsRequestBuilder(limit);
    try {
      HttpResponse<InputStream> localVarResponse = memberVarHttpClient.send(
          localVarRequestBuilder.build(),
          HttpResponse.BodyHandlers.ofInputStream());
      if (memberVarResponseInterceptor != null) {
        memberVarResponseInterceptor.accept(localVarResponse);
      }
      try {
        if (localVarResponse.statusCode()/ 100 != 2) {
          throw getApiException("getLatestAggregatedInvocationsStats", localVarResponse);
        }
        return new ApiResponse<Map<String, BigDecimal>>(
          localVarResponse.statusCode(),
          localVarResponse.headers().map(),
          localVarResponse.body() == null ? null : memberVarObjectMapper.readValue(localVarResponse.body(), new TypeReference<Map<String, BigDecimal>>() {}) // closes the InputStream
        );
      } finally {
      }
    } catch (IOException e) {
      throw new ApiException(e);
    }
    catch (InterruptedException e) {
      Thread.currentThread().interrupt();
      throw new ApiException(e);
    }
  }

  private HttpRequest.Builder getLatestAggregatedInvocationsStatsRequestBuilder(Integer limit) throws ApiException {

    HttpRequest.Builder localVarRequestBuilder = HttpRequest.newBuilder();

    String localVarPath = "/metrics/invocations/global/latest";

    List<Pair> localVarQueryParams = new ArrayList<>();
    StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
    String localVarQueryParameterBaseName;
    localVarQueryParameterBaseName = "limit";
    localVarQueryParams.addAll(ApiClient.parameterToPairs("limit", limit));

    if (!localVarQueryParams.isEmpty() || localVarQueryStringJoiner.length() != 0) {
      StringJoiner queryJoiner = new StringJoiner("&");
      localVarQueryParams.forEach(p -> queryJoiner.add(p.getName() + '=' + p.getValue()));
      if (localVarQueryStringJoiner.length() != 0) {
        queryJoiner.add(localVarQueryStringJoiner.toString());
      }
      localVarRequestBuilder.uri(URI.create(memberVarBaseUri + localVarPath + '?' + queryJoiner.toString()));
    } else {
      localVarRequestBuilder.uri(URI.create(memberVarBaseUri + localVarPath));
    }

    localVarRequestBuilder.header("Accept", "application/json");

    localVarRequestBuilder.method("GET", HttpRequest.BodyPublishers.noBody());
    if (memberVarReadTimeout != null) {
      localVarRequestBuilder.timeout(memberVarReadTimeout);
    }
    if (memberVarInterceptor != null) {
      memberVarInterceptor.accept(localVarRequestBuilder);
    }
    return localVarRequestBuilder;
  }

  /**
   * Get latest tests results
   * 
   * @param limit Number of days to consider for test results to return. Default is 7 (one week) (optional)
   * @return List&lt;TestResultSummary&gt;
   * @throws ApiException if fails to make API call
   */
  public List<TestResultSummary> getLatestTestResults(Integer limit) throws ApiException {
    ApiResponse<List<TestResultSummary>> localVarResponse = getLatestTestResultsWithHttpInfo(limit);
    return localVarResponse.getData();
  }

  /**
   * Get latest tests results
   * 
   * @param limit Number of days to consider for test results to return. Default is 7 (one week) (optional)
   * @return ApiResponse&lt;List&lt;TestResultSummary&gt;&gt;
   * @throws ApiException if fails to make API call
   */
  public ApiResponse<List<TestResultSummary>> getLatestTestResultsWithHttpInfo(Integer limit) throws ApiException {
    HttpRequest.Builder localVarRequestBuilder = getLatestTestResultsRequestBuilder(limit);
    try {
      HttpResponse<InputStream> localVarResponse = memberVarHttpClient.send(
          localVarRequestBuilder.build(),
          HttpResponse.BodyHandlers.ofInputStream());
      if (memberVarResponseInterceptor != null) {
        memberVarResponseInterceptor.accept(localVarResponse);
      }
      try {
        if (localVarResponse.statusCode()/ 100 != 2) {
          throw getApiException("getLatestTestResults", localVarResponse);
        }
        return new ApiResponse<List<TestResultSummary>>(
          localVarResponse.statusCode(),
          localVarResponse.headers().map(),
          localVarResponse.body() == null ? null : memberVarObjectMapper.readValue(localVarResponse.body(), new TypeReference<List<TestResultSummary>>() {}) // closes the InputStream
        );
      } finally {
      }
    } catch (IOException e) {
      throw new ApiException(e);
    }
    catch (InterruptedException e) {
      Thread.currentThread().interrupt();
      throw new ApiException(e);
    }
  }

  private HttpRequest.Builder getLatestTestResultsRequestBuilder(Integer limit) throws ApiException {

    HttpRequest.Builder localVarRequestBuilder = HttpRequest.newBuilder();

    String localVarPath = "/metrics/tests/latest";

    List<Pair> localVarQueryParams = new ArrayList<>();
    StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
    String localVarQueryParameterBaseName;
    localVarQueryParameterBaseName = "limit";
    localVarQueryParams.addAll(ApiClient.parameterToPairs("limit", limit));

    if (!localVarQueryParams.isEmpty() || localVarQueryStringJoiner.length() != 0) {
      StringJoiner queryJoiner = new StringJoiner("&");
      localVarQueryParams.forEach(p -> queryJoiner.add(p.getName() + '=' + p.getValue()));
      if (localVarQueryStringJoiner.length() != 0) {
        queryJoiner.add(localVarQueryStringJoiner.toString());
      }
      localVarRequestBuilder.uri(URI.create(memberVarBaseUri + localVarPath + '?' + queryJoiner.toString()));
    } else {
      localVarRequestBuilder.uri(URI.create(memberVarBaseUri + localVarPath));
    }

    localVarRequestBuilder.header("Accept", "application/json");

    localVarRequestBuilder.method("GET", HttpRequest.BodyPublishers.noBody());
    if (memberVarReadTimeout != null) {
      localVarRequestBuilder.timeout(memberVarReadTimeout);
    }
    if (memberVarInterceptor != null) {
      memberVarInterceptor.accept(localVarRequestBuilder);
    }
    return localVarRequestBuilder;
  }

  /**
   * Get conformance metrics for a Service
   * 
   * @param serviceId Unique Services identifier this metrics are related to (required)
   * @return TestConformanceMetric
   * @throws ApiException if fails to make API call
   */
  public TestConformanceMetric getServiceTestConformanceMetric(String serviceId) throws ApiException {
    ApiResponse<TestConformanceMetric> localVarResponse = getServiceTestConformanceMetricWithHttpInfo(serviceId);
    return localVarResponse.getData();
  }

  /**
   * Get conformance metrics for a Service
   * 
   * @param serviceId Unique Services identifier this metrics are related to (required)
   * @return ApiResponse&lt;TestConformanceMetric&gt;
   * @throws ApiException if fails to make API call
   */
  public ApiResponse<TestConformanceMetric> getServiceTestConformanceMetricWithHttpInfo(String serviceId) throws ApiException {
    HttpRequest.Builder localVarRequestBuilder = getServiceTestConformanceMetricRequestBuilder(serviceId);
    try {
      HttpResponse<InputStream> localVarResponse = memberVarHttpClient.send(
          localVarRequestBuilder.build(),
          HttpResponse.BodyHandlers.ofInputStream());
      if (memberVarResponseInterceptor != null) {
        memberVarResponseInterceptor.accept(localVarResponse);
      }
      try {
        if (localVarResponse.statusCode()/ 100 != 2) {
          throw getApiException("getServiceTestConformanceMetric", localVarResponse);
        }
        return new ApiResponse<TestConformanceMetric>(
          localVarResponse.statusCode(),
          localVarResponse.headers().map(),
          localVarResponse.body() == null ? null : memberVarObjectMapper.readValue(localVarResponse.body(), new TypeReference<TestConformanceMetric>() {}) // closes the InputStream
        );
      } finally {
      }
    } catch (IOException e) {
      throw new ApiException(e);
    }
    catch (InterruptedException e) {
      Thread.currentThread().interrupt();
      throw new ApiException(e);
    }
  }

  private HttpRequest.Builder getServiceTestConformanceMetricRequestBuilder(String serviceId) throws ApiException {
    // verify the required parameter 'serviceId' is set
    if (serviceId == null) {
      throw new ApiException(400, "Missing the required parameter 'serviceId' when calling getServiceTestConformanceMetric");
    }

    HttpRequest.Builder localVarRequestBuilder = HttpRequest.newBuilder();

    String localVarPath = "/metrics/conformance/service/{serviceId}"
        .replace("{serviceId}", ApiClient.urlEncode(serviceId.toString()));

    localVarRequestBuilder.uri(URI.create(memberVarBaseUri + localVarPath));

    localVarRequestBuilder.header("Accept", "application/json");

    localVarRequestBuilder.method("GET", HttpRequest.BodyPublishers.noBody());
    if (memberVarReadTimeout != null) {
      localVarRequestBuilder.timeout(memberVarReadTimeout);
    }
    if (memberVarInterceptor != null) {
      memberVarInterceptor.accept(localVarRequestBuilder);
    }
    return localVarRequestBuilder;
  }

  /**
   * Get top invocation statistics for a day
   * 
   * @param day The day to get statistics for (formatted with yyyyMMdd pattern). Default to today if not provided. (optional)
   * @param limit The number of top invoked mocks to return (optional)
   * @return List&lt;DailyInvocationStatistic&gt;
   * @throws ApiException if fails to make API call
   */
  public List<DailyInvocationStatistic> getTopIvnocationsStatsByDay(String day, Integer limit) throws ApiException {
    ApiResponse<List<DailyInvocationStatistic>> localVarResponse = getTopIvnocationsStatsByDayWithHttpInfo(day, limit);
    return localVarResponse.getData();
  }

  /**
   * Get top invocation statistics for a day
   * 
   * @param day The day to get statistics for (formatted with yyyyMMdd pattern). Default to today if not provided. (optional)
   * @param limit The number of top invoked mocks to return (optional)
   * @return ApiResponse&lt;List&lt;DailyInvocationStatistic&gt;&gt;
   * @throws ApiException if fails to make API call
   */
  public ApiResponse<List<DailyInvocationStatistic>> getTopIvnocationsStatsByDayWithHttpInfo(String day, Integer limit) throws ApiException {
    HttpRequest.Builder localVarRequestBuilder = getTopIvnocationsStatsByDayRequestBuilder(day, limit);
    try {
      HttpResponse<InputStream> localVarResponse = memberVarHttpClient.send(
          localVarRequestBuilder.build(),
          HttpResponse.BodyHandlers.ofInputStream());
      if (memberVarResponseInterceptor != null) {
        memberVarResponseInterceptor.accept(localVarResponse);
      }
      try {
        if (localVarResponse.statusCode()/ 100 != 2) {
          throw getApiException("getTopIvnocationsStatsByDay", localVarResponse);
        }
        return new ApiResponse<List<DailyInvocationStatistic>>(
          localVarResponse.statusCode(),
          localVarResponse.headers().map(),
          localVarResponse.body() == null ? null : memberVarObjectMapper.readValue(localVarResponse.body(), new TypeReference<List<DailyInvocationStatistic>>() {}) // closes the InputStream
        );
      } finally {
      }
    } catch (IOException e) {
      throw new ApiException(e);
    }
    catch (InterruptedException e) {
      Thread.currentThread().interrupt();
      throw new ApiException(e);
    }
  }

  private HttpRequest.Builder getTopIvnocationsStatsByDayRequestBuilder(String day, Integer limit) throws ApiException {

    HttpRequest.Builder localVarRequestBuilder = HttpRequest.newBuilder();

    String localVarPath = "/metrics/invocations/top";

    List<Pair> localVarQueryParams = new ArrayList<>();
    StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
    String localVarQueryParameterBaseName;
    localVarQueryParameterBaseName = "day";
    localVarQueryParams.addAll(ApiClient.parameterToPairs("day", day));
    localVarQueryParameterBaseName = "limit";
    localVarQueryParams.addAll(ApiClient.parameterToPairs("limit", limit));

    if (!localVarQueryParams.isEmpty() || localVarQueryStringJoiner.length() != 0) {
      StringJoiner queryJoiner = new StringJoiner("&");
      localVarQueryParams.forEach(p -> queryJoiner.add(p.getName() + '=' + p.getValue()));
      if (localVarQueryStringJoiner.length() != 0) {
        queryJoiner.add(localVarQueryStringJoiner.toString());
      }
      localVarRequestBuilder.uri(URI.create(memberVarBaseUri + localVarPath + '?' + queryJoiner.toString()));
    } else {
      localVarRequestBuilder.uri(URI.create(memberVarBaseUri + localVarPath));
    }

    localVarRequestBuilder.header("Accept", "application/json");

    localVarRequestBuilder.method("GET", HttpRequest.BodyPublishers.noBody());
    if (memberVarReadTimeout != null) {
      localVarRequestBuilder.timeout(memberVarReadTimeout);
    }
    if (memberVarInterceptor != null) {
      memberVarInterceptor.accept(localVarRequestBuilder);
    }
    return localVarRequestBuilder;
  }

}
